//[okio](../../index.md)/[okio](../index.md)/[ForwardingTimeout](index.md)



# ForwardingTimeout  
 [jvm] A [Timeout](../-timeout/index.md) which forwards calls to another. Useful for subclassing.  
  
open class [ForwardingTimeout](index.md)(**delegate**: [Timeout](../-timeout/index.md)) : [Timeout](../-timeout/index.md)   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| [<init>](-init-.md)|  [jvm] fun [<init>](-init-.md)(delegate: [Timeout](../-timeout/index.md))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [clearDeadline](clear-deadline.md)| [jvm]  <br>Brief description  <br>Clears the deadline.  <br>Content  <br>open override fun [clearDeadline](clear-deadline.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [clearTimeout](clear-timeout.md)| [jvm]  <br>Brief description  <br>Clears the timeout. Operating system timeouts may still apply.  <br>Content  <br>open override fun [clearTimeout](clear-timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [deadline](../-timeout/deadline.md)| [jvm]  <br>Brief description  <br>Set a deadline of now plus duration time.  <br>Content  <br>override fun [deadline](../-timeout/deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)  <br><br><br>
| [deadlineNanoTime](deadline-nano-time.md)| [jvm]  <br>Brief description  <br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br>Content  <br>open override fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[jvm]  <br>Brief description  <br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations.  <br>Content  <br>open override fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](../-timeout/index.md)  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hasDeadline](has-deadline.md)| [jvm]  <br>Brief description  <br>Returns true if a deadline is enabled.  <br>Content  <br>open override fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [intersectWith](../-timeout/intersect-with.md)| [jvm]  <br>Brief description  <br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values.  <br>Content  <br>inline override fun [intersectWith](../-timeout/intersect-with.md)(other: [Timeout](../-timeout/index.md), block: () -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| [setDelegate](set-delegate.md)| [jvm]  <br>Content  <br>fun [setDelegate](set-delegate.md)(delegate: [Timeout](../-timeout/index.md)): [ForwardingTimeout](index.md)  <br><br><br>
| [throwIfReached](throw-if-reached.md)| [jvm]  <br>Brief description  <br>Throws an [InterruptedIOException]([InterruptedIOException]) if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation.  <br>Content  <br>open override fun [throwIfReached](throw-if-reached.md)()  <br><br><br>
| [timeout](timeout.md)| [jvm]  <br>Brief description  <br>Wait at most timeout time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail.If timeout == 0, operations will run indefinitely. (Operating system timeouts may still apply.)  <br>Content  <br>open override fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)  <br><br><br>
| [timeoutNanos](timeout-nanos.md)| [jvm]  <br>Brief description  <br>Returns the timeout in nanoseconds, or 0 for no timeout.  <br>Content  <br>open override fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [jvm]  <br>Content  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [waitUntilNotified](../-timeout/wait-until-notified.md)| [jvm]  <br>Brief description  <br>Waits on monitor until it is notified. Throws [InterruptedIOException]([InterruptedIOException]) if either the thread is interrupted or if this timeout elapses before monitor is notified. The caller must be synchronized on monitor.Here's a sample class that uses waitUntilNotified() to await a specific state. Note that the call is made within a loop to avoid unnecessary waiting and to mitigate spurious notifications.class Dice {  <br>  Random random = new Random();  <br>  int latestTotal;  <br>  <br>  public synchronized void roll() {  <br>    latestTotal = 2 + random.nextInt(6) + random.nextInt(6);  <br>    System.out.println("Rolled " + latestTotal);  <br>    notifyAll();  <br>  }  <br>  <br>  public void rollAtFixedRate(int period, TimeUnit timeUnit) {  <br>    Executors.newScheduledThreadPool(0).scheduleAtFixedRate(new Runnable() {  <br>      public void run() {  <br>        roll();  <br>      }  <br>    }, 0, period, timeUnit);  <br>  }  <br>  <br>  public synchronized void awaitTotal(Timeout timeout, int total)  <br>      throws InterruptedIOException {  <br>    while (latestTotal != total) {  <br>      timeout.waitUntilNotified(this);  <br>    }  <br>  }  <br>}  <br>Content  <br>override fun [waitUntilNotified](../-timeout/wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [deadlineNanoTime](deadline-nano-time.md)|  [jvm] override var [deadlineNanoTime](deadline-nano-time.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)   <br>
| [delegate](index.md#okio/ForwardingTimeout/delegate/#/PointingToDeclaration/)|  [jvm] var [delegate](index.md#okio/ForwardingTimeout/delegate/#/PointingToDeclaration/): [Timeout](../-timeout/index.md)   <br>
| [hasDeadline](has-deadline.md)|  [jvm] True if deadlineNanoTime is defined. There is no equivalent to null or 0 for [System.nanoTime](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--).override var [hasDeadline](has-deadline.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)   <br>
| [timeoutNanos](timeout-nanos.md)|  [jvm] override var [timeoutNanos](timeout-nanos.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)   <br>

