//[okio](../../index.md)/[okio](../index.md)/[GzipSink](index.md)



# GzipSink  
 [jvm] A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.

###  Sync flush  
Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.  
  
class [GzipSink](index.md)(**sink**: [Sink](../-sink/index.md)) : [Sink](../-sink/index.md)   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| [<init>](-init-.md)|  [jvm] fun [<init>](-init-.md)(sink: [Sink](../-sink/index.md))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [close](close.md)| [jvm]  <br>Content  <br>open override fun [close](close.md)()  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [flush](flush.md)| [jvm]  <br>Content  <br>open override fun [flush](flush.md)()  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [timeout](timeout.md)| [jvm]  <br>Content  <br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [jvm]  <br>Content  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| [write](write.md)| [jvm]  <br>Content  <br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [deflater](index.md#okio/GzipSink/deflater/#/PointingToDeclaration/)|  [jvm] The deflater used to compress the body.val [deflater](index.md#okio/GzipSink/deflater/#/PointingToDeclaration/): [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)   <br>

