//[okio](../../index.md)/[okio](../index.md)/[Pipe](index.md)



# Pipe  
 [jvm] A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source.This class uses a buffer to decouple source and sink. This buffer has a user-specified maximum size. When a producer thread outruns its consumer the buffer fills up and eventually writes to the sink will block until the consumer has caught up. Symmetrically, if a consumer outruns its producer reads block until there is data to be read. Limits on the amount of time spent waiting for the other party can be configured with [timeouts](../-timeout/index.md) on the source and the sink.When the sink is closed, source reads will continue to complete normally until the buffer has been exhausted. At that point reads will return -1, indicating the end of the stream. But if the source is closed first, writes to the sink will immediately fail with an [IOException](../-i-o-exception/index.md).A pipe may be canceled to immediately fail writes to the sink and reads from the source.  
  
class [Pipe](index.md)(**maxBufferSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| [<init>](-init-.md)|  [jvm] fun [<init>](-init-.md)(maxBufferSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [cancel](cancel.md)| [jvm]  <br>Brief description  <br>Fail any in-flight and future operations. After canceling:<ul><li>Any attempt to write or flush [sink](index.md#okio/Pipe/sink/#/PointingToDeclaration/) will fail immediately with an [IOException](../-i-o-exception/index.md).</li><li>Any attempt to read [source](index.md#okio/Pipe/source/#/PointingToDeclaration/) will fail immediately with an [IOException](../-i-o-exception/index.md).</li><li>Any attempt to [fold](fold.md) will fail immediately with an [IOException](../-i-o-exception/index.md).</li></ul>Closing the source and the sink will complete normally even after a pipe has been canceled. If this sink has been folded, closing it will close the folded sink. This operation may block.This operation may be called by any thread at any time. It is safe to call concurrently while operating on the source or the sink.  <br>Content  <br>fun [cancel](cancel.md)()  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [jvm]  <br>Content  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [fold](fold.md)| [jvm]  <br>Brief description  <br>Writes any buffered contents of this pipe to sink, then replace this pipe's source with sink. This pipe's source is closed and attempts to read it will throw an [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html).This method must not be called while concurrently accessing this pipe's source. It is safe, however, to call this while concurrently writing this pipe's sink.  <br>Content  <br>fun [fold](fold.md)(sink: [Sink](../-sink/index.md))  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [jvm]  <br>Content  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [jvm]  <br>Content  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [sink](index.md#okio/Pipe/sink/#/PointingToDeclaration/)|  [jvm] val [sink](index.md#okio/Pipe/sink/#/PointingToDeclaration/): [Sink](../-sink/index.md)   <br>
| [source](index.md#okio/Pipe/source/#/PointingToDeclaration/)|  [jvm] val [source](index.md#okio/Pipe/source/#/PointingToDeclaration/): [Source](../-source/index.md)   <br>

