//[okio](../../index.md)/[okio](../index.md)/[Source](index.md)



# Source  
 [js, native] interface [Source](index.md)   
 [jvm] interface [Source](index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)   


## Functions  
  
|  Name|  Summary| 
|---|---|
| [close](close.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>abstract fun [close](close.md)()  <br>[jvm]  <br>abstract override fun [close](close.md)()  <br><br><br>
| [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open operator override fun [equals](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/equals.html)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [hashCode](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/hash-code.html)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| [read](read.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>abstract fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>
| [timeout](timeout.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open override fun [toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| [BufferedSource](../-buffered-source/index.md)
| [CipherSource](../-cipher-source/index.md)
| [ForwardingSource](../-forwarding-source/index.md)
| [GzipSource](../-gzip-source/index.md)
| [InflaterSource](../-inflater-source/index.md)


## Extensions  
  
|  Name|  Summary| 
|---|---|
| [cipherSource](../cipher-source.md)| [jvm]  <br>Brief description  <br>Returns a source that uses [cipher]() to encrypt or decrypt [this]().  <br>Content  <br>fun [Source](index.md).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)  <br><br><br>
| [gzip](../gzip.md)| [jvm]  <br>Brief description  <br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](index.md) while reading.  <br>Content  <br>inline fun [Source](index.md).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)  <br><br><br>
| [inflate](../inflate.md)| [jvm]  <br>Brief description  <br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](index.md) while reading.  <br>Content  <br>inline fun [Source](index.md).[inflate](../inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)): [InflaterSource](../-inflater-source/index.md)  <br><br><br>

