//[okio](../index.md)/[okio](index.md)



# Package okio  


## Types  
  
|  Name|  Summary| 
|---|---|
| [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)| [js]  <br>Content  <br>open class [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IndexOutOfBoundsException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-index-out-of-bounds-exception/index.html)  <br><br><br>
| [AsyncTimeout](-async-timeout/index.md)| [jvm]  <br>Brief description  <br>This timeout uses a background thread to take action exactly when the timeout occurs. Use this to implement timeouts where they aren't supported natively, such as to sockets that are blocked on writing.Subclasses should override [timedOut]() to take action when a timeout occurs. This method will be invoked by the shared watchdog thread so it should not do any long-running operations. Otherwise we risk starving other timeouts from being triggered.Use [sink](-async-timeout/sink.md) and [source](-async-timeout/source.md) to apply this timeout to a stream. The returned value will apply the timeout to each operation on the wrapped stream.Callers should call [enter](-async-timeout/enter.md) before doing work that is subject to timeouts, and [exit](-async-timeout/exit.md) afterwards. The return value of [exit](-async-timeout/exit.md) indicates whether a timeout was triggered. Note that the call to [timedOut]() is asynchronous, and may be called after [exit](-async-timeout/exit.md).  <br>Content  <br>open class [AsyncTimeout](-async-timeout/index.md) : [Timeout](-timeout/index.md)  <br><br><br>
| [Buffer](-buffer/index.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md)  <br>[jvm]  <br>class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)  <br><br><br>
| [BufferedSink](-buffered-sink/index.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md)  <br>[jvm]  <br>interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md), [WritableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/WritableByteChannel.html)  <br><br><br>
| [BufferedSource](-buffered-source/index.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md)  <br>[jvm]  <br>interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md), [ReadableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ReadableByteChannel.html)  <br><br><br>
| [ByteString](-byte-string/index.md)| [jvm]  <br>Content  <br>open class [ByteString](-byte-string/index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)  <br><br><br>
| [CipherSink](-cipher-sink/index.md)| [jvm]  <br>Content  <br>class [CipherSink](-cipher-sink/index.md)(**sink**: [BufferedSink](-buffered-sink/index.md),**cipher**: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Sink](-sink/index.md)  <br><br><br>
| [CipherSource](-cipher-source/index.md)| [jvm]  <br>Content  <br>class [CipherSource](-cipher-source/index.md)(**source**: [BufferedSource](-buffered-source/index.md),**cipher**: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Source](-source/index.md)  <br><br><br>
| [DeflaterSink](-deflater-sink/index.md)| [jvm]  <br>Brief description  <br>A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.<br><br> Sync flush  <br>Aggressive flushing of this stream may result in reduced compression. Each call to [flush](-deflater-sink/flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](-deflater-sink/flush.md) when application behavior requires it.  <br>Content  <br>class [DeflaterSink](-deflater-sink/index.md) : [Sink](-sink/index.md)  <br><br><br>
| [EOFException](-e-o-f-exception/index.md)| [js, native]  <br>Content  <br>[js, native]  <br>open class [EOFException](-e-o-f-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)  <br><br><br>
| [ForwardingSink](-forwarding-sink/index.md)| [jvm]  <br>Brief description  <br>A [Sink](-sink/index.md) which forwards calls to another. Useful for subclassing.  <br>Content  <br>abstract class [ForwardingSink](-forwarding-sink/index.md)(**delegate**: [Sink](-sink/index.md)) : [Sink](-sink/index.md)  <br><br><br>
| [ForwardingSource](-forwarding-source/index.md)| [jvm]  <br>Brief description  <br>A [Source](-source/index.md) which forwards calls to another. Useful for subclassing.  <br>Content  <br>abstract class [ForwardingSource](-forwarding-source/index.md)(**delegate**: [Source](-source/index.md)) : [Source](-source/index.md)  <br><br><br>
| [ForwardingTimeout](-forwarding-timeout/index.md)| [jvm]  <br>Brief description  <br>A [Timeout](-timeout/index.md) which forwards calls to another. Useful for subclassing.  <br>Content  <br>open class [ForwardingTimeout](-forwarding-timeout/index.md)(**delegate**: [Timeout](-timeout/index.md)) : [Timeout](-timeout/index.md)  <br><br><br>
| [GzipSink](-gzip-sink/index.md)| [jvm]  <br>Brief description  <br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.<br><br> Sync flush  <br>Aggressive flushing of this stream may result in reduced compression. Each call to [flush](-gzip-sink/flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](-gzip-sink/flush.md) when application behavior requires it.  <br>Content  <br>class [GzipSink](-gzip-sink/index.md)(**sink**: [Sink](-sink/index.md)) : [Sink](-sink/index.md)  <br><br><br>
| [GzipSource](-gzip-source/index.md)| [jvm]  <br>Brief description  <br>A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source.  <br>Content  <br>class [GzipSource](-gzip-source/index.md)(**source**: [Source](-source/index.md)) : [Source](-source/index.md)  <br><br><br>
| [HashingSink](-hashing-sink/index.md)| [jvm]  <br>Brief description  <br>A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](-hashing-sink/index.md#okio/HashingSink/hash/#/PointingToDeclaration/) to compute the final hash value.In this example we use HashingSink with a [BufferedSink](-buffered-sink/index.md) to make writing to the sink easier.HashingSink hashingSink = HashingSink.sha256(s);  <br>BufferedSink bufferedSink = Okio.buffer(hashingSink);  <br>  <br>... // Write to bufferedSink and either flush or close it.  <br>  <br>ByteString hash = hashingSink.hash();  <br>Content  <br>class [HashingSink](-hashing-sink/index.md) : [ForwardingSink](-forwarding-sink/index.md)  <br><br><br>
| [HashingSource](-hashing-source/index.md)| [jvm]  <br>Brief description  <br>A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](-hashing-source/index.md#okio/HashingSource/hash/#/PointingToDeclaration/) to compute the final hash value.In this example we use HashingSource with a [BufferedSource](-buffered-source/index.md) to make reading from the source easier.HashingSource hashingSource = HashingSource.sha256(rawSource);  <br>BufferedSource bufferedSource = Okio.buffer(hashingSource);  <br>  <br>... // Read all of bufferedSource.  <br>  <br>ByteString hash = hashingSource.hash();  <br>Content  <br>class [HashingSource](-hashing-source/index.md) : [ForwardingSource](-forwarding-source/index.md)  <br><br><br>
| [InflaterSource](-inflater-source/index.md)| [jvm]  <br>Brief description  <br>A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.  <br>Content  <br>class [InflaterSource](-inflater-source/index.md) : [Source](-source/index.md)  <br><br><br>
| [IOException](-i-o-exception/index.md)| [js, native]  <br>Content  <br>[js]  <br>open class [IOException](-i-o-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [Exception](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)  <br>[native]  <br>open class [IOException](-i-o-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?)  <br><br><br>
| [Pipe](-pipe/index.md)| [jvm]  <br>Brief description  <br>A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source.This class uses a buffer to decouple source and sink. This buffer has a user-specified maximum size. When a producer thread outruns its consumer the buffer fills up and eventually writes to the sink will block until the consumer has caught up. Symmetrically, if a consumer outruns its producer reads block until there is data to be read. Limits on the amount of time spent waiting for the other party can be configured with [timeouts](-timeout/index.md) on the source and the sink.When the sink is closed, source reads will continue to complete normally until the buffer has been exhausted. At that point reads will return -1, indicating the end of the stream. But if the source is closed first, writes to the sink will immediately fail with an [IOException](-i-o-exception/index.md).A pipe may be canceled to immediately fail writes to the sink and reads from the source.  <br>Content  <br>class [Pipe](-pipe/index.md)(**maxBufferSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>
| [Sink](-sink/index.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>interface [Sink](-sink/index.md)  <br>[jvm]  <br>interface [Sink](-sink/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)  <br><br><br>
| [Source](-source/index.md)| [js, jvm, native]  <br>Content  <br>[js, native]  <br>interface [Source](-source/index.md)  <br>[jvm]  <br>interface [Source](-source/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)  <br><br><br>
| [Throttler](-throttler/index.md)| [jvm]  <br>Brief description  <br>Enables limiting of Source and Sink throughput. Attach to this throttler via [source](-throttler/source.md) and [sink](-throttler/sink.md) and set the desired throughput via [bytesPerSecond](-throttler/bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers.This class has these tuning parameters:<ul><li>bytesPerSecond: Maximum sustained throughput. Use 0 for no limit.</li><li>waitByteCount: When the requested byte count is greater than this many bytes and isn't     immediately available, only wait until we can allocate at least this many bytes. Use this to     set the ideal byte count during sustained throughput.</li><li>maxByteCount: Maximum number of bytes to allocate on any call. This is also the number of     bytes that will be returned before any waiting.</li></ul>  <br>Content  <br>class [Throttler](-throttler/index.md)  <br><br><br>
| [Timeout](-timeout/index.md)| [js, jvm, native]  <br>Content  <br>[js, jvm, native]  <br>open class [Timeout](-timeout/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| [appendingSink](appending-sink.md)| [jvm]  <br>Brief description  <br>Returns a sink that writes to file.  <br>Content  <br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[appendingSink](appending-sink.md)(): [Sink](-sink/index.md)  <br><br><br>
| [cipherSink](cipher-sink.md)| [jvm]  <br>Brief description  <br>Returns a sink that uses [cipher]() to encrypt or decrypt [this]().  <br>Content  <br>fun [Sink](-sink/index.md).[cipherSink](cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](-cipher-sink/index.md)  <br><br><br>
| [cipherSource](cipher-source.md)| [jvm]  <br>Brief description  <br>Returns a source that uses [cipher]() to encrypt or decrypt [this]().  <br>Content  <br>fun [Source](-source/index.md).[cipherSource](cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](-cipher-source/index.md)  <br><br><br>
| [deflate](deflate.md)| [jvm]  <br>Brief description  <br>Returns an [DeflaterSink](-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](-sink/index.md) while writing.  <br>Content  <br>inline fun [Sink](-sink/index.md).[deflate](deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)): [DeflaterSink](-deflater-sink/index.md)  <br><br><br>
| [gzip](gzip.md)| [jvm]  <br>Brief description  <br>Returns a [GzipSink](-gzip-sink/index.md) that gzip-compresses to this [Sink](-sink/index.md) while writing.  <br>Content  <br>inline fun [Sink](-sink/index.md).[gzip](gzip.md)(): [GzipSink](-gzip-sink/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a [GzipSource](-gzip-source/index.md) that gzip-decompresses this [Source](-source/index.md) while reading.  <br>Content  <br>inline fun [Source](-source/index.md).[gzip](gzip.md)(): [GzipSource](-gzip-source/index.md)  <br><br><br>
| [inflate](inflate.md)| [jvm]  <br>Brief description  <br>Returns an [InflaterSource](-inflater-source/index.md) that DEFLATE-decompresses this [Source](-source/index.md) while reading.  <br>Content  <br>inline fun [Source](-source/index.md).[inflate](inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)): [InflaterSource](-inflater-source/index.md)  <br><br><br>
| [sink](sink.md)| [jvm]  <br>Brief description  <br>Returns a sink that writes to out.  <br>Content  <br>fun [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html).[sink](sink.md)(): [Sink](-sink/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a sink that writes to socket. Prefer this over [sink](sink.md) because this method honors timeouts. When the socket write times out, the socket is asynchronously closed by a watchdog thread.  <br>Content  <br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[sink](sink.md)(): [Sink](-sink/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a sink that writes to file.  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[sink](sink.md)(append: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sink](-sink/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a source that reads from path.  <br>Content  <br>@[IgnoreJRERequirement]()()  <br>  <br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[sink](sink.md)(vararg options: [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)<Out [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)>): [Sink](-sink/index.md)  <br><br><br>
| [source](source.md)| [jvm]  <br>Brief description  <br>Returns a source that reads from in.  <br>Content  <br>fun [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html).[source](source.md)(): [Source](-source/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a source that reads from socket. Prefer this over [source](source.md) because this method honors timeouts. When the socket read times out, the socket is asynchronously closed by a watchdog thread.  <br>Content  <br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[source](source.md)(): [Source](-source/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a source that reads from file.  <br>Content  <br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[source](source.md)(): [Source](-source/index.md)  <br><br><br>[jvm]  <br>Brief description  <br>Returns a sink that writes to path.  <br>Content  <br>@[IgnoreJRERequirement]()()  <br>  <br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[source](source.md)(vararg options: [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)<Out [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)>): [Source](-source/index.md)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| [Okio](index.md#okio//Okio/#/PointingToDeclaration/)|  [jvm] val [Okio](index.md#okio//Okio/#/PointingToDeclaration/): [-DeprecatedOkio]()   <br>
| [Utf8](index.md#okio//Utf8/#/PointingToDeclaration/)|  [jvm] val [Utf8](index.md#okio//Utf8/#/PointingToDeclaration/): [-DeprecatedUtf8]()   <br>

