//[okio-fakefilesystem](../../index.md)/[okio.fakefilesystem](../index.md)/[FakeFileSystem](index.md)



# FakeFileSystem  
 [common] class [FakeFileSystem](index.md)(**windowsLimitations**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **workingDirectory**: Path, **clock**: Clock) : FileSystem

A fully in-memory file system useful for testing. It includes features to support writing better tests.



Use [openPaths](open-paths.md) to see which paths have been opened for read or write, but not yet closed. Tests should call [checkNoOpenFiles](check-no-open-files.md) in tearDown() to confirm that no file streams were leaked.



By default this file system permits deletion and removal of open files. Configure windowsLimitations to true to throw an IOException when asked to delete or rename an open file.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio.fakefilesystem/FakeFileSystem/FakeFileSystem/#kotlin.Boolean#okio.Path#kotlinx.datetime.Clock/PointingToDeclaration/"></a>[FakeFileSystem](-fake-file-system.md)| <a name="okio.fakefilesystem/FakeFileSystem/FakeFileSystem/#kotlin.Boolean#okio.Path#kotlinx.datetime.Clock/PointingToDeclaration/"></a> [common] fun [FakeFileSystem](-fake-file-system.md)(windowsLimitations: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, workingDirectory: Path = (if (windowsLimitations) "F:\\".toPath() else "/".toPath()), clock: Clock = Clock.System)   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio.fakefilesystem/FakeFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio.fakefilesystem/FakeFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [appendingSink](appending-sink.md)(file: Path): Sink  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio.fakefilesystem/FakeFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [atomicMove](atomic-move.md)(source: Path, target: Path)  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio.fakefilesystem/FakeFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [canonicalize](canonicalize.md)(path: Path): Path  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/checkNoOpenFiles/#/PointingToDeclaration/"></a>[checkNoOpenFiles](check-no-open-files.md)| <a name="okio.fakefilesystem/FakeFileSystem/checkNoOpenFiles/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [checkNoOpenFiles](check-no-open-files.md)()  <br>More info  <br>Confirm that all files that have been opened on this file system (with [source](source.md), [sink](sink.md), and [appendingSink](appending-sink.md)) have since been closed.  <br><br><br>
| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [copy](index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(source: Path, target: Path)  <br><br><br>
| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [createDirectories](index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(dir: Path)  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio.fakefilesystem/FakeFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [createDirectory](create-directory.md)(dir: Path)  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio.fakefilesystem/FakeFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [delete](delete.md)(path: Path)  <br><br><br>
| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [deleteRecursively](index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(fileOrDirectory: Path)  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common]  <br>Content  <br>open operator fun [equals](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [exists](index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(path: Path): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [hashCode](index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio.fakefilesystem/FakeFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [list](list.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<Path>  <br><br><br>
| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [metadata](index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(path: Path): FileMetadata  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio.fakefilesystem/FakeFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [metadataOrNull](metadata-or-null.md)(path: Path): FileMetadata?  <br><br><br>
| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[read](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)> [read](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(file: Path, readerAction: BufferedSource.() -> [T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)): [T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio.fakefilesystem/FakeFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [sink](sink.md)(file: Path): Sink  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio.fakefilesystem/FakeFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [source](source.md)(file: Path): Source  <br><br><br>
| <a name="okio.fakefilesystem/FakeFileSystem/toString/#/PointingToDeclaration/"></a>[toString](to-string.md)| <a name="okio.fakefilesystem/FakeFileSystem/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[write](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)> [write](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)(file: Path, writerAction: BufferedSink.() -> [T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)): [T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-68573489)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio.fakefilesystem/FakeFileSystem/allPaths/#/PointingToDeclaration/"></a>[allPaths](all-paths.md)| <a name="okio.fakefilesystem/FakeFileSystem/allPaths/#/PointingToDeclaration/"></a> [common] val [allPaths](all-paths.md): [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)<Path>Canonical paths for every file and directory in this file system.   <br>
| <a name="okio.fakefilesystem/FakeFileSystem/clock/#/PointingToDeclaration/"></a>[clock](clock.md)| <a name="okio.fakefilesystem/FakeFileSystem/clock/#/PointingToDeclaration/"></a> [common] @[JvmField](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-field/index.html)()  <br>  <br>val [clock](clock.md): Clock   <br>
| <a name="okio.fakefilesystem/FakeFileSystem/openPaths/#/PointingToDeclaration/"></a>[openPaths](open-paths.md)| <a name="okio.fakefilesystem/FakeFileSystem/openPaths/#/PointingToDeclaration/"></a> [common] val [openPaths](open-paths.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<Path>Canonical paths currently opened for reading or writing in the order they were opened.   <br>

