//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)

# Buffer

[common]\
class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)

A collection of bytes in memory.

**Moving data from one buffer to another is fast.** Instead of copying bytes from one place in memory to another, this class just changes ownership of the underlying byte arrays.

**This buffer grows with your data.** Just like ArrayList, each buffer starts small. It consumes only the memory it needs to.

**This buffer pools its byte arrays.** When you allocate a byte array in Java, the runtime must zero-fill the requested array before returning it to you. Even if you're going to write over that space anyway. This class avoids zero-fill and GC churn by pooling byte arrays.

[jvm]\
class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)

## Constructors

| | |
|---|---|
| [Buffer](index.md#1311751259%2FConstructors%2F-1565995479) | [common]<br>fun [Buffer](index.md#1311751259%2FConstructors%2F-1565995479)() |

## Types

| Name | Summary |
|---|---|
| [UnsafeCursor](-unsafe-cursor/index.md) | [common]<br>class [UnsafeCursor](-unsafe-cursor/index.md)<br>A handle to the underlying data in a buffer.<br>[jvm]<br>class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html) |

## Functions

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [jvm]<br>open override fun [buffer](buffer.md)(): [Buffer](index.md)<br>Returns this source's internal buffer. |
| [clear](clear.md) | [common]<br>fun [clear](clear.md)()<br>Discards all bytes in this buffer.<br>[jvm]<br>fun [clear](clear.md)() |
| [clone](clone.md) | [jvm]<br>open override fun [clone](clone.md)(): [Buffer](index.md)<br>Returns a deep copy of this buffer. |
| close | [jvm, common]<br>[jvm]<br>open override fun [close](close.md)()<br>[common]<br>abstract override fun [close](../-source/close.md)()<br>Closes this source and releases the resources held by this source. |
| [completeSegmentByteCount](complete-segment-byte-count.md) | [common]<br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes in segments that are not writable.<br>[jvm]<br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [copy](copy.md) | [common]<br>fun [copy](copy.md)(): [Buffer](index.md)<br>Returns a deep copy of this buffer.<br>[jvm]<br>fun [copy](copy.md)(): [Buffer](index.md) |
| copyTo | [common]<br>fun [copyTo](index.md#-1210364027%2FFunctions%2F-1565995479)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Buffer](index.md)<br>Overload of [copyTo](index.md#1918394207%2FFunctions%2F-1565995479) with byteCount = size - offset, work around for https://youtrack.jetbrains.<br>[jvm]<br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Buffer](index.md)<br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm, common]<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>fun [copyTo](copy-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = size - offset): [Buffer](index.md)<br>[common]<br>fun [copyTo](index.md#1918394207%2FFunctions%2F-1565995479)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Copy byteCount bytes from this, starting at offset, to out. |
| [emit](emit.md) | [common]<br>open override fun [emit](emit.md)(): [Buffer](index.md)<br>Writes all buffered data to the underlying sink, if one exists.<br>[jvm]<br>open override fun [emit](emit.md)(): [Buffer](index.md) |
| [emitCompleteSegments](emit-complete-segments.md) | [common]<br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)<br>Writes complete segments to the underlying sink, if one exists.<br>[jvm]<br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md) |
| [equals](equals.md) | [jvm]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| exhausted | [jvm]<br>open override fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [exhausted](../-buffered-source/exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if there are no more bytes in this source. |
| flush | [jvm]<br>open override fun [flush](flush.md)()<br>[common]<br>abstract override fun [flush](../-buffered-sink/flush.md)()<br>Writes all buffered data to the underlying sink, if one exists. |
| [get](get.md) | [common]<br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Returns the byte at pos.<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = getByte)<br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html) |
| [hashCode](hash-code.md) | [jvm]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [hmacSha1](hmac-sha1.md) | [common, jvm]<br>[common, jvm]<br>fun [hmacSha1](hmac-sha1.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 HMAC of this buffer. |
| [hmacSha256](hmac-sha256.md) | [common, jvm]<br>[common, jvm]<br>fun [hmacSha256](hmac-sha256.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 HMAC of this buffer. |
| [hmacSha512](hmac-sha512.md) | [common, jvm]<br>[common, jvm]<br>fun [hmacSha512](hmac-sha512.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 HMAC of this buffer. |
| indexOf | [jvm]<br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(b, 0)](../-buffered-source/index-of.md).<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(bytes, 0)](../-buffered-source/index-of.md).<br>[jvm]<br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of b in this at or beyond fromIndex, or -1 if this buffer does not contain b in that range.<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first b in the buffer at or after fromIndex.<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for bytes in the buffer at or after fromIndex.<br>[common]<br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the index of b if it is found in the range of fromIndex inclusive to toIndex exclusive. |
| indexOfElement | [jvm]<br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [indexOfElement](../-buffered-source/index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOfElement(targetBytes, 0)](../-buffered-source/index-of-element.md).<br>[common]<br>abstract fun [indexOfElement](../-buffered-source/index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the first index in this buffer that is at or after fromIndex and that contains any of the bytes in targetBytes. |
| [inputStream](input-stream.md) | [jvm]<br>open override fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)<br>Returns an input stream that reads from this source. |
| [isOpen](is-open.md) | [jvm]<br>open override fun [isOpen](is-open.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [md5](md5.md) | [common]<br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 128-bit MD5 hash of this buffer. |
| [outputStream](output-stream.md) | [jvm]<br>open override fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)<br>Returns an output stream that writes to this sink. |
| peek | [jvm]<br>open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md)<br>[common]<br>abstract fun [peek](../-buffered-source/peek.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new BufferedSource that can read data from this BufferedSource without consuming it. |
| rangeEquals | [jvm]<br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [rangeEquals](../-buffered-source/range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes at offset in this source equal bytes.<br>[common]<br>abstract fun [rangeEquals](../-buffered-source/range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if byteCount bytes at offset in this source equal bytes at bytesOffset. |
| read | [jvm]<br>open override fun [read](read.md)(sink: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [read](../-buffered-source/read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to sink.length bytes from this and copies them into sink.<br>[jvm, common]<br>[jvm]<br>open override fun [read](read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [read](../-source/read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to byteCount bytes from this and appends them to sink.<br>[common]<br>abstract fun [read](../-buffered-source/read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes up to byteCount bytes from this and copies them into sink at offset. |
| readAll | [jvm]<br>open override fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readAll](../-buffered-source/read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from this and appends them to sink. |
| [readAndWriteUnsafe](read-and-write-unsafe.md) | [common, jvm]<br>[common]<br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md) |
| readByte | [jvm]<br>open override fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>[common]<br>abstract fun [readByte](../-buffered-source/read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)<br>Removes a byte from this source and returns it. |
| readByteArray | [jvm]<br>open override fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>open override fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>[common]<br>abstract fun [readByteArray](../-buffered-source/read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes all bytes from this and returns them as a byte array.<br>[common]<br>abstract fun [readByteArray](../-buffered-source/read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Removes byteCount bytes from this and returns them as a byte array. |
| readByteString | [jvm]<br>open override fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>open override fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>abstract fun [readByteString](../-buffered-source/read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>Removes all bytes from this and returns them as a byte string.<br>[common]<br>abstract fun [readByteString](../-buffered-source/read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>Removes byteCount bytes from this and returns them as a byte string. |
| readDecimalLong | [jvm]<br>open override fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readDecimalLong](../-buffered-source/read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). |
| [readFrom](read-from.md) | [jvm]<br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [Buffer](index.md)<br>Read and exhaust bytes from input into this.<br>[jvm]<br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Read byteCount bytes from input into this. |
| readFully | [jvm]<br>open override fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>open override fun [readFully](read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[common]<br>abstract fun [readFully](../-buffered-source/read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))<br>Removes exactly sink.length bytes from this and copies them into sink.<br>[common]<br>abstract fun [readFully](../-buffered-source/read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes exactly byteCount bytes from this and appends them to sink. |
| readHexadecimalUnsignedLong | [jvm]<br>open override fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readHexadecimalUnsignedLong](../-buffered-source/read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16). |
| readInt | [jvm]<br>open override fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [readInt](../-buffered-source/read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a big-endian int. |
| readIntLe | [jvm]<br>open override fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [readIntLe](../-buffered-source/read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a little-endian int. |
| readLong | [jvm]<br>open override fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readLong](../-buffered-source/read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a big-endian long. |
| readLongLe | [jvm]<br>open override fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [readLongLe](../-buffered-source/read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a little-endian long. |
| readShort | [jvm]<br>open override fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>[common]<br>abstract fun [readShort](../-buffered-source/read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a big-endian short. |
| readShortLe | [jvm]<br>open override fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>[common]<br>abstract fun [readShortLe](../-buffered-source/read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a little-endian short. |
| [readString](read-string.md) | [jvm]<br>open override fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as charset, and returns the string.<br>[jvm]<br>open override fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes byteCount bytes from this, decodes them as charset, and returns the string. |
| [readUnsafe](read-unsafe.md) | [common, jvm]<br>[common]<br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md) |
| readUtf8 | [jvm]<br>open override fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>open override fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[common]<br>abstract fun [readUtf8](../-buffered-source/read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as UTF-8, and returns the string.<br>[common]<br>abstract fun [readUtf8](../-buffered-source/read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes byteCount bytes from this, decodes them as UTF-8, and returns the string. |
| readUtf8CodePoint | [jvm]<br>open override fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [readUtf8CodePoint](../-buffered-source/read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary. |
| readUtf8Line | [jvm]<br>open override fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>[common]<br>abstract fun [readUtf8Line](../-buffered-source/read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?<br>Removes and returns characters up to but not including the next line break. |
| readUtf8LineStrict | [jvm]<br>open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>[common]<br>abstract fun [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Removes and returns characters up to but not including the next line break.<br>[common]<br>abstract fun [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Like [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. |
| request | [jvm]<br>open override fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[common]<br>abstract fun [request](../-buffered-source/request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true when the buffer contains at least byteCount bytes, expanding it as necessary. |
| require | [jvm]<br>open override fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[common]<br>abstract fun [require](../-buffered-source/require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Returns when the buffer contains at least byteCount bytes. |
| select | [jvm]<br>open override fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[common]<br>abstract fun [select](../-buffered-source/select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Finds the first string in options that is a prefix of this buffer, consumes it from this buffer, and returns its index. |
| [sha1](sha1.md) | [common]<br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 hash of this buffer. |
| [sha256](sha256.md) | [common]<br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 hash of this buffer. |
| [sha512](sha512.md) | [common]<br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 hash of this buffer. |
| [skip](skip.md) | [common]<br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Discards byteCount bytes from the head of this buffer.<br>[jvm]<br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
| [snapshot](snapshot.md) | [common]<br>fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)<br>Returns an immutable copy of this buffer as a byte string.<br>[jvm]<br>fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)<br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)<br>Returns an immutable copy of the first byteCount bytes of this buffer as a byte string. |
| timeout | [jvm, common]<br>[jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>[common]<br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Returns a human-readable string that describes the contents of this buffer. |
| write | [jvm, common]<br>[jvm]<br>open override fun [write](write.md)(source: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>[jvm]<br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)<br>[common]<br>open override fun [write](index.md#-646832675%2FFunctions%2F-1565995479)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)<br>[jvm]<br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)<br>[jvm]<br>open override fun [write](write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[jvm]<br>open override fun [write](write.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm]<br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>open override fun [write](index.md#1469357565%2FFunctions%2F-1565995479)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[jvm]<br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>open override fun [write](index.md#1813740572%2FFunctions%2F-1565995479)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)<br>open override fun [write](index.md#234369788%2FFunctions%2F-1565995479)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Like OutputStream.<br>[common]<br>open override fun [write](index.md#548939797%2FFunctions%2F-1565995479)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Removes byteCount bytes from source and appends them to this sink.<br>[common]<br>abstract fun [write](../-sink/write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes byteCount bytes from source and appends them to this. |
| writeAll | [jvm]<br>open override fun [writeAll](write-all.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [writeAll](../-buffered-sink/write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes all bytes from source and appends them to this sink. |
| [writeByte](write-byte.md) | [common]<br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a byte to this sink.<br>[jvm]<br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeDecimalLong](write-decimal-long.md) | [common]<br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10).<br>[jvm]<br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | [common]<br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).<br>[jvm]<br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeInt](write-int.md) | [common]<br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a big-endian int to this sink using four bytes.<br>[jvm]<br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeIntLe](write-int-le.md) | [common]<br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a little-endian int to this sink using four bytes.<br>[jvm]<br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeLong](write-long.md) | [common]<br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a big-endian long to this sink using eight bytes.<br>[jvm]<br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeLongLe](write-long-le.md) | [common]<br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a little-endian long to this sink using eight bytes.<br>[jvm]<br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeShort](write-short.md) | [common]<br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a big-endian short to this sink using two bytes.<br>[jvm]<br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeShortLe](write-short-le.md) | [common]<br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a little-endian short to this sink using two bytes.<br>[jvm]<br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeString](write-string.md) | [jvm]<br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)<br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md) |
| [writeTo](write-to.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>fun [writeTo](write-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = size): [Buffer](index.md)<br>Write byteCount bytes from this to out. |
| [writeUtf8](write-utf8.md) | [common]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)<br>Encodes string in UTF-8 and writes it to this sink.<br>[jvm]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Encodes the characters at beginIndex up to endIndex from string in UTF-8 and writes it to this sink. |
| [writeUtf8CodePoint](write-utf8-code-point.md) | [common]<br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Encodes codePoint in UTF-8 and writes it to this sink.<br>[jvm]<br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md) |

## Properties

| Name | Summary |
|---|---|
| buffer | [common]<br>open override val [buffer](index.md#-347552645%2FProperties%2F-1565995479): [Buffer](index.md)<br>This source's internal buffer.<br>[jvm]<br>open override val [buffer](buffer.md): [Buffer](index.md) |
| [size](size.md) | [common, jvm]<br>var [size](size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L |
