//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)

# FileSystem

[common]\
abstract class [FileSystem](index.md)

Read and write access to a hierarchical collection of files, addressed by [paths](../-path/index.md). This is a natural interface to the current computer's local file system.

Other implementations are possible:

<ul><li>FakeFileSystem is an in-memory file system suitable for testing. Note that this class is     included in the okio-fakefilesystem artifact.</li><li>[ForwardingFileSystem](../-forwarding-file-system/index.md) is a file system decorator. Use it to apply monitoring, encryption,     compression, or filtering to another file system.</li><li>A ZIP file system could provide access to the contents of a .zip file.</li></ul>

For improved capability and testability, consider structuring your classes to dependency inject a FileSystem rather than using FileSystem.SYSTEM directly.

Small API

 ---------

This interface is deliberately limited in which features it supports.

It is not suitable for high-latency or unreliable remote file systems. It lacks support for retries, timeouts, cancellation, and bulk operations.

It cannot create special file types like hard links, symlinks, pipes, or mounts. Reading or writing these files works as if they were regular files.

It cannot read or write file access control features like the UNIX chmod and Windows access control lists. It does honor these controls and will fail with an [IOException](../-i-o-exception/index.md) if privileges are insufficient!

It cannot lock files or check which files are locked.

It cannot watch the file system for changes.

Applications that need rich file system features should use another API!

Multiplatform

 -------------

This class supports a matrix of Kotlin platforms (JVM, Kotlin/Native, Kotlin/JS) and operating systems (Linux, macOS, and Windows). It attempts to balance working similarly across platforms with being consistent with the local operating system.

This is a blocking API which limits its applicability on concurrent Node.js services. File operations will block the event loop (and all JavaScript execution!) until they complete.

It supports the path schemes of both Windows (like C:\Users) and UNIX (like /home). Note that path resolution rules differ by platform.

Differences vs. Java IO APIs

 ----------------------------

The java.io.File class is Java's original file system API. The delete and renameTo methods return false if the operation failed. The list method returns null if the file isn't a directory or could not be listed. This class always throws an [IOException](../-i-o-exception/index.md) when an operation doesn't succeed.

The java.nio.Path and java.nio.Files classes are the entry points of Java's new file system API. Each Path instance is scoped to a particular file system, though that is often implicit because the Paths.get() function automatically uses the default (ie. system) file system. In Okio's API paths are just identifiers; you must use a specific FileSystem object to do I/O with.

[js, jvm]\
abstract class [FileSystem](index.md)

## Constructors

| | |
|---|---|
| [FileSystem](index.md#1318479803%2FConstructors%2F-1565995479) | [common]<br>fun [FileSystem](index.md#1318479803%2FConstructors%2F-1565995479)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, js, jvm]<br>[common, js, jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [common]<br>abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)<br>Returns a sink that appends bytes to the end of [file](appending-sink.md), creating it if it doesn't already exist.<br>[js, jvm]<br>[js, jvm]<br>abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md) |
| [atomicMove](atomic-move.md) | [common]<br>abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))<br>Moves [source](atomic-move.md) to [target](atomic-move.md) in-place if the underlying file system supports it.<br>[js, jvm]<br>[js, jvm]<br>abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [canonicalize](canonicalize.md) | [common]<br>abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)<br>Resolves [path](canonicalize.md) against the current working directory and symlinks in this file system.<br>[js, jvm]<br>[js, jvm]<br>abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md) |
| [copy](copy.md) | [common]<br>open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))<br>Copies all of the bytes from the file at [source](copy.md) to the file at [target](copy.md).<br>[js, jvm]<br>[js, jvm]<br>open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [createDirectories](create-directories.md) | [common]<br>fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md))<br>Creates a directory at the path identified by [dir](create-directories.md), and any enclosing parent path directories, recursively.<br>[js, jvm]<br>[js, jvm]<br>fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md)) |
| [createDirectory](create-directory.md) | [common]<br>abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))<br>Creates a directory at the path identified by [dir](create-directory.md).<br>[js, jvm]<br>[js, jvm]<br>abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md)) |
| [delete](delete.md) | [common]<br>abstract fun [delete](delete.md)(path: [Path](../-path/index.md))<br>Deletes the file or directory at [path](delete.md).<br>[js, jvm]<br>[js, jvm]<br>abstract fun [delete](delete.md)(path: [Path](../-path/index.md)) |
| [deleteRecursively](delete-recursively.md) | [common]<br>open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md))<br>Recursively deletes all children of [fileOrDirectory](delete-recursively.md) if it is a directory, then deletes [fileOrDirectory](delete-recursively.md) itself.<br>[js, jvm]<br>[js, jvm]<br>open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md)) |
| [exists](exists.md) | [common]<br>fun [exists](exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [path](exists.md) identifies an object on this file system.<br>[js, jvm]<br>[js, jvm]<br>fun [exists](exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [list](list.md) | [common]<br>abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)><br>Returns the children of the directory identified by [dir](list.md).<br>[js, jvm]<br>[js, jvm]<br>abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)> |
| [metadata](metadata.md) | [common]<br>fun [metadata](metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)<br>Returns metadata of the file, directory, or object identified by [path](metadata.md).<br>[js, jvm]<br>[js, jvm]<br>fun [metadata](metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md) |
| [metadataOrNull](metadata-or-null.md) | [common]<br>abstract fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)?<br>Returns metadata of the file, directory, or object identified by [path](metadata-or-null.md).<br>[js, jvm]<br>[js, jvm]<br>abstract fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)? |
| [openReadOnly](open-read-only.md) | [common]<br>abstract fun [openReadOnly](open-read-only.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md)<br>Returns a handle to read [file](open-read-only.md).<br>[js, jvm]<br>[js, jvm]<br>abstract fun [openReadOnly](open-read-only.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md) |
| [openReadWrite](open-read-write.md) | [common]<br>abstract fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md)<br>Returns a handle to read and write [file](open-read-write.md).<br>[js, jvm]<br>[js, jvm]<br>abstract fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md) |
| [read](read.md) | [common]<br>inline fun <[T](read.md)> [read](read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -> [T](read.md)): [T](read.md)<br>Creates a source to read [file](read.md), executes [readerAction](read.md) to read it, and then closes the source.<br>[js, jvm]<br>[js, jvm]<br>inline fun <[T](read.md)> [read](read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -> [T](read.md)): [T](read.md) |
| [sink](sink.md) | [common]<br>abstract fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)<br>Returns a sink that writes bytes to [file](sink.md) from beginning to end.<br>[js, jvm]<br>[js, jvm]<br>abstract fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md) |
| [source](source.md) | [common]<br>abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md)<br>Returns a source that reads the bytes of [file](source.md) from beginning to end.<br>[js, jvm]<br>[js]<br>abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md)<br>[jvm]<br>abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053) |
| [write](write.md) | [common]<br>inline fun <[T](write.md)> [write](write.md)(file: [Path](../-path/index.md), writerAction: [BufferedSink](../-buffered-sink/index.md).() -> [T](write.md)): [T](write.md)<br>Creates a sink to write [file](write.md), executes [writerAction](write.md) to write it, and then closes the sink.<br>[js, jvm]<br>[js, jvm]<br>inline fun <[T](write.md)> [write](write.md)(file: [Path](../-path/index.md), writerAction: [BufferedSink](../-buffered-sink/index.md).() -> [T](write.md)): [T](write.md) |

## Inheritors

| Name |
|---|
| [ForwardingFileSystem](../-forwarding-file-system/index.md) |
| [ZipFileSystem](../-zip-file-system/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [openZip](../open-zip.md) | [jvm]<br>fun [FileSystem](index.md).[openZip](../open-zip.md)(zipPath: [Path](../-path/index.md)): [FileSystem](index.md) |
