//[okio](../../../index.md)/[okio](../index.md)/[InflaterSource](index.md)

# InflaterSource

[jvm]\
class [InflaterSource](index.md) : [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)

A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.

## Constructors

| | |
|---|---|
| [InflaterSource](-inflater-source.md) | [jvm]<br>fun [InflaterSource](-inflater-source.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053), inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html)) |

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [jvm]<br>open override fun [close](close.md)()<br>Closes this source and releases the resources held by this source. |
| [read](read.md) | [jvm]<br>open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to byteCount bytes from this and appends them to sink. |
| [readOrInflate](read-or-inflate.md) | [jvm]<br>fun [readOrInflate](read-or-inflate.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Consume deflated bytes from the underlying source, and write any inflated bytes to [sink](read-or-inflate.md). |
| [refill](refill.md) | [jvm]<br>fun [refill](refill.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Refills the inflater with compressed data if it needs input. |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
