//[okio](../../../index.md)/[okio](../index.md)/[Throttler](index.md)

# Throttler

[jvm]\
class [Throttler](index.md)

Enables limiting of Source and Sink throughput. Attach to this throttler via [source](source.md) and [sink](sink.md) and set the desired throughput via [bytesPerSecond](bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers.

This class has these tuning parameters:

<ul><li>bytesPerSecond: Maximum sustained throughput. Use 0 for no limit.</li><li>waitByteCount: When the requested byte count is greater than this many bytes and isn't     immediately available, only wait until we can allocate at least this many bytes. Use this to     set the ideal byte count during sustained throughput.</li><li>maxByteCount: Maximum number of bytes to allocate on any call. This is also the number of     bytes that will be returned before any waiting.</li></ul>

## Constructors

| | |
|---|---|
| [Throttler](-throttler.md) | [jvm]<br>fun [Throttler](-throttler.md)() |

## Functions

| Name | Summary |
|---|---|
| [bytesPerSecond](bytes-per-second.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>fun [bytesPerSecond](bytes-per-second.md)(bytesPerSecond: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), waitByteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = this.waitByteCount, maxByteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = this.maxByteCount)<br>Sets the rate at which bytes will be allocated. |
| [sink](sink.md) | [jvm]<br>fun [sink](sink.md)(sink: [Sink](../-sink/index.md)): [Sink](../-sink/index.md)<br>Create a Sink which honors this Throttler. |
| [source](source.md) | [jvm]<br>fun [source](source.md)(source: [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)<br>Create a Source which honors this Throttler. |
