//[okio](../../index.md)/[okio](../index.md)/[ForwardingFileSystem](index.md)



# ForwardingFileSystem  
 [common] abstract class [ForwardingFileSystem](index.md)(**delegate**: [FileSystem](../-file-system/index.md)) : [FileSystem](../-file-system/index.md)

A [FileSystem](../-file-system/index.md) that forwards calls to another, intended for subclassing.



###  Fault Injection  


You can use this to deterministically trigger file system failures in tests. This is useful to confirm that your program behaves correctly even if its file system operations fail. For example, this subclass fails every access of files named unlucky.txt:

val faultyFileSystem = object : ForwardingFileSystem(FileSystem.SYSTEM) {  
  override fun onPathParameter(path: Path, functionName: String, parameterName: String): Path {  
    if (path.name == "unlucky.txt") throw IOException("synthetic failure!")  
    return path  
  }  
}

You can fail specific operations by overriding them directly:

val faultyFileSystem = object : ForwardingFileSystem(FileSystem.SYSTEM) {  
  override fun delete(path: Path) {  
    throw IOException("synthetic failure!")  
  }  
}

###  Observability  


You can extend this to verify which files your program accesses. This is a testing file system that records accesses as they happen:

class LoggingFileSystem : ForwardingFileSystem(FileSystem.SYSTEM) {  
  val log = mutableListOf<String>()  
  
  override fun onPathParameter(path: Path, functionName: String, parameterName: String): Path {  
    log += "$functionName($parameterName=$path)"  
    return path  
  }  
}

This makes it easy for tests to assert exactly which files were accessed.

@Test  
fun testMergeJsonReports() {  
  createSampleJsonReports()  
  loggingFileSystem.log.clear()  
  
  mergeJsonReports()  
  
  assertThat(loggingFileSystem.log).containsExactly(  
    "list(dir=json_reports)",  
    "source(file=json_reports/2020-10.json)",  
    "source(file=json_reports/2020-12.json)",  
    "source(file=json_reports/2020-11.json)",  
    "sink(file=json_reports/2020-all.json)"  
  )  
}

###  Transformations  


Subclasses can transform file names and content.



For example, your program may be written to operate on a well-known directory like /etc/ or /System. You can rewrite paths to make such operations safer to test.



You may also transform file content to apply application-layer encryption or compression. This is particularly useful in situations where it's difficult or impossible to enable those features in the underlying file system.



###  Abstract Functions Only  


Some file system functions like copy are implemented by using other features. These are the non-abstract functions in the [FileSystem](../-file-system/index.md) interface.



**This class forwards only the abstract functions;** non-abstract functions delegate to the other functions of this class. If desired, subclasses may override non-abstract functions to forward them.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingFileSystem/ForwardingFileSystem/#okio.FileSystem/PointingToDeclaration/"></a>[ForwardingFileSystem](-forwarding-file-system.md)| <a name="okio/ForwardingFileSystem/ForwardingFileSystem/#okio.FileSystem/PointingToDeclaration/"></a> [common] fun [ForwardingFileSystem](-forwarding-file-system.md)(delegate: [FileSystem](../-file-system/index.md))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio/ForwardingFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that appends bytes to the end of file, creating it if it doesn't already exist.  <br><br><br>
| <a name="okio/ForwardingFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio/ForwardingFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br>More info  <br>Moves source to target in-place if the underlying file system supports it.  <br><br><br>
| <a name="okio/ForwardingFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio/ForwardingFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)  <br>More info  <br>Resolves path against the current working directory and symlinks in this file system.  <br><br><br>
| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](../-file-system/copy.md)| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [copy](../-file-system/copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br>More info  <br>Copies all of the bytes from the file at source to the file at target.  <br><br><br>
| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](../-file-system/create-directories.md)| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [createDirectories](../-file-system/create-directories.md)(dir: [Path](../-path/index.md))  <br>More info  <br>Creates a directory at the path identified by dir, and any enclosing parent path directories, recursively.  <br><br><br>
| <a name="okio/ForwardingFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio/ForwardingFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))  <br>More info  <br>Creates a directory at the path identified by dir.  <br><br><br>
| <a name="okio/ForwardingFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio/ForwardingFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [delete](delete.md)(path: [Path](../-path/index.md))  <br>More info  <br>Deletes the file or directory at path.  <br><br><br>
| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](../-file-system/delete-recursively.md)| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [deleteRecursively](../-file-system/delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md))  <br>More info  <br>Recursively deletes all children of fileOrDirectory if it is a directory, then deletes fileOrDirectory itself.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](../-file-system/exists.md)| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [exists](../-file-system/exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if path identifies an object on this file system.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ForwardingFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio/ForwardingFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)>  <br>More info  <br>Returns the children of the directory identified by dir.  <br><br><br>
| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](../-file-system/metadata.md)| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [metadata](../-file-system/metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)  <br>More info  <br>Returns metadata of the file, directory, or object identified by path.  <br><br><br>
| <a name="okio/ForwardingFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio/ForwardingFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)?  <br>More info  <br>Returns metadata of the file, directory, or object identified by path.  <br><br><br>
| <a name="okio/ForwardingFileSystem/onPathParameter/#okio.Path#kotlin.String#kotlin.String/PointingToDeclaration/"></a>[onPathParameter](on-path-parameter.md)| <a name="okio/ForwardingFileSystem/onPathParameter/#okio.Path#kotlin.String#kotlin.String/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [onPathParameter](on-path-parameter.md)(path: [Path](../-path/index.md), functionName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), parameterName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Path](../-path/index.md)  <br>More info  <br>Invoked each time a path is passed as a parameter to this file system.  <br><br><br>
| <a name="okio/ForwardingFileSystem/onPathResult/#okio.Path#kotlin.String/PointingToDeclaration/"></a>[onPathResult](on-path-result.md)| <a name="okio/ForwardingFileSystem/onPathResult/#okio.Path#kotlin.String/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [onPathResult](on-path-result.md)(path: [Path](../-path/index.md), functionName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Path](../-path/index.md)  <br>More info  <br>Invoked each time a path is returned by [delegate](delegate.md).  <br><br><br>
| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[read](../-file-system/read.md)| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](../-file-system/read.md)> [read](../-file-system/read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -> [T](../-file-system/read.md)): [T](../-file-system/read.md)  <br>More info  <br>Creates a source to read file, executes readerAction to read it, and then closes the source.  <br><br><br>
| <a name="okio/ForwardingFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/ForwardingFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that writes bytes to file from beginning to end.  <br><br><br>
| <a name="okio/ForwardingFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/ForwardingFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md)  <br>More info  <br>Returns a source that reads the bytes of file from beginning to end.  <br><br><br>
| <a name="okio/ForwardingFileSystem/toString/#/PointingToDeclaration/"></a>[toString](to-string.md)| <a name="okio/ForwardingFileSystem/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[write](../-file-system/write.md)| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](../-file-system/write.md)> [write](../-file-system/write.md)(file: [Path](../-path/index.md), writerAction: [BufferedSink](../-buffered-sink/index.md).() -> [T](../-file-system/write.md)): [T](../-file-system/write.md)  <br>More info  <br>Creates a sink to write file, executes writerAction to write it, and then closes the sink.  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingFileSystem/delegate/#/PointingToDeclaration/"></a>[delegate](delegate.md)| <a name="okio/ForwardingFileSystem/delegate/#/PointingToDeclaration/"></a> [common] val [delegate](delegate.md): [FileSystem](../-file-system/index.md)[FileSystem](../-file-system/index.md) to which this instance is delegating.   <br>

