//[okio](../../index.md)/[okio](../index.md)/[HashingSink](index.md)



# HashingSink  
 [common] class [HashingSink](index.md) : [Sink](../-sink/index.md)

A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](hash.md) to compute the final hash value.



In this example we use HashingSink with a [BufferedSink](../-buffered-sink/index.md) to make writing to the sink easier.

HashingSink hashingSink = HashingSink.sha256(s);  
BufferedSink bufferedSink = Okio.buffer(hashingSink);  
  
... // Write to bufferedSink and either flush or close it.  
  
ByteString hash = hashingSink.hash();   
 [jvm] class [HashingSink](index.md) : [ForwardingSink](../-forwarding-sink/index.md), [Sink](../-sink/index.md)

A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](hash.md) to compute the final hash value.



In this example we use HashingSink with a [BufferedSink](../-buffered-sink/index.md) to make writing to the sink easier.

HashingSink hashingSink = HashingSink.sha256(s);  
BufferedSink bufferedSink = Okio.buffer(hashingSink);  
  
... // Write to bufferedSink and either flush or close it.  
  
ByteString hash = hashingSink.hash();   


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/HashingSink.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/HashingSink.Companion///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingSink/close/#/PointingToDeclaration/"></a>close| <a name="okio/ForwardingSink/close/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [close](../-forwarding-sink/close.md)()  <br><br><br>[common]  <br>Content  <br>abstract override fun [close](../-sink/close.md)()  <br>More info  <br>Pushes all buffered bytes to their final destination and releases the resources held by this sink.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/ForwardingSink/flush/#/PointingToDeclaration/"></a>flush| <a name="okio/ForwardingSink/flush/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [flush](../-forwarding-sink/flush.md)()  <br><br><br>[common]  <br>Content  <br>abstract fun [flush](../-sink/flush.md)()  <br>More info  <br>Pushes all buffered bytes to their final destination.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ForwardingSink/timeout/#/PointingToDeclaration/"></a>timeout| <a name="okio/ForwardingSink/timeout/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [timeout](../-forwarding-sink/timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>[common]  <br>Content  <br>abstract fun [timeout](../-sink/timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this sink.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[jvm]  <br>open override fun [toString](../-forwarding-sink/to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/HashingSink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>write| <a name="okio/HashingSink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>[common]  <br>Content  <br>abstract fun [write](../-sink/write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes byteCount bytes from source and appends them to this.  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/HashingSink/delegate/#/PointingToDeclaration/"></a>[delegate](index.md#%5Bokio%2FHashingSink%2Fdelegate%2F%23%2FPointingToDeclaration%2F%5D%2FProperties%2F-43762623)| <a name="okio/HashingSink/delegate/#/PointingToDeclaration/"></a> [jvm] val [delegate](index.md#%5Bokio%2FHashingSink%2Fdelegate%2F%23%2FPointingToDeclaration%2F%5D%2FProperties%2F-43762623): [Sink](../-sink/index.md)[Sink](../-sink/index.md) to which this instance is delegating.   <br>
| <a name="okio/HashingSink/hash/#/PointingToDeclaration/"></a>[hash](hash.md)| <a name="okio/HashingSink/hash/#/PointingToDeclaration/"></a> [common, jvm] val [hash](hash.md): [ByteString](../-byte-string/index.md)Returns the hash of the bytes accepted thus far and resets the internal state of this sink.   <br>

