//[okio](../index.md)/[okio](index.md)



# Package okio  


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ArrayIndexOutOfBoundsException///PointingToDeclaration/"></a>[ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)| <a name="okio/ArrayIndexOutOfBoundsException///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>class [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IndexOutOfBoundsException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-index-out-of-bounds-exception/index.html)  <br>[jvm]  <br>typealias [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md) = [ArrayIndexOutOfBoundsException](https://docs.oracle.com/javase/8/docs/api/java/lang/ArrayIndexOutOfBoundsException.html)  <br><br><br>
| <a name="okio/AsyncTimeout///PointingToDeclaration/"></a>[AsyncTimeout](-async-timeout/index.md)| <a name="okio/AsyncTimeout///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open class [AsyncTimeout](-async-timeout/index.md) : [Timeout](-timeout/index.md)  <br>More info  <br>This timeout uses a background thread to take action exactly when the timeout occurs.  <br><br><br>
| <a name="okio/Buffer///PointingToDeclaration/"></a>[Buffer](-buffer/index.md)| <a name="okio/Buffer///PointingToDeclaration/"></a>[common]  <br>Content  <br>class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md)  <br>More info  <br>A collection of bytes in memory.  <br><br><br>[jvm]  <br>Content  <br>class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSink///PointingToDeclaration/"></a>[BufferedSink](-buffered-sink/index.md)| <a name="okio/BufferedSink///PointingToDeclaration/"></a>[common]  <br>Content  <br>interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md)  <br>More info  <br>A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.  <br><br><br>[jvm]  <br>Content  <br>interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md), [WritableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/WritableByteChannel.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource///PointingToDeclaration/"></a>[BufferedSource](-buffered-source/index.md)| <a name="okio/BufferedSource///PointingToDeclaration/"></a>[common]  <br>Content  <br>interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md)  <br>More info  <br>A source that keeps a buffer internally so that callers can do small reads without a performance penalty.  <br><br><br>[jvm]  <br>Content  <br>interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557), [ReadableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ReadableByteChannel.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString///PointingToDeclaration/"></a>[ByteString](-byte-string/index.md)| <a name="okio/ByteString///PointingToDeclaration/"></a>[common]  <br>Content  <br>open class [ByteString](-byte-string/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[ByteString](-byte-string/index.md)>   <br>More info  <br>An immutable sequence of bytes.  <br><br><br>[jvm]  <br>Content  <br>open class [ByteString](-byte-string/index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[ByteString](-byte-string/index.md)>   <br>More info  <br>  <br><br><br>
| <a name="okio/CipherSink///PointingToDeclaration/"></a>[CipherSink](-cipher-sink/index.md)| <a name="okio/CipherSink///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [CipherSink](-cipher-sink/index.md)(**sink**: [BufferedSink](-buffered-sink/index.md), **cipher**: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Sink](-sink/index.md)  <br><br><br>
| <a name="okio/CipherSource///PointingToDeclaration/"></a>[CipherSource](-cipher-source/index.md)| <a name="okio/CipherSource///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [CipherSource](-cipher-source/index.md)(**source**: [BufferedSource](-buffered-source/index.md), **cipher**: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br><br><br>
| <a name="okio/Closeable///PointingToDeclaration/"></a>[Closeable](-closeable/index.md)| <a name="okio/Closeable///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>interface [Closeable](-closeable/index.md)  <br>[jvm]  <br>typealias [Closeable](-closeable/index.md) = [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)  <br><br><br>
| <a name="okio/DeflaterSink///PointingToDeclaration/"></a>[DeflaterSink](-deflater-sink/index.md)| <a name="okio/DeflaterSink///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [DeflaterSink](-deflater-sink/index.md) : [Sink](-sink/index.md)  <br>More info  <br>A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.  <br><br><br>
| <a name="okio/EOFException///PointingToDeclaration/"></a>[EOFException](-e-o-f-exception/index.md)| <a name="okio/EOFException///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open class [EOFException](-e-o-f-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)  <br>[jvm]  <br>typealias [EOFException](-e-o-f-exception/index.md) = [EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html)  <br><br><br>
| <a name="okio/ExperimentalFileSystem///PointingToDeclaration/"></a>[ExperimentalFileSystem](-experimental-file-system/index.md)| <a name="okio/ExperimentalFileSystem///PointingToDeclaration/"></a>[common]  <br>Content  <br>@[Target](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-target/index.html)(allowedTargets = [[AnnotationTarget.CLASS](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-c-l-a-s-s/index.html), [AnnotationTarget.FUNCTION](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-f-u-n-c-t-i-o-n/index.html), [AnnotationTarget.PROPERTY](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-p-r-o-p-e-r-t-y/index.html)])  <br>  <br>annotation class [ExperimentalFileSystem](-experimental-file-system/index.md)  <br><br><br>
| <a name="okio/FileHandle///PointingToDeclaration/"></a>[FileHandle](-file-handle/index.md)| <a name="okio/FileHandle///PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract class [FileHandle](-file-handle/index.md)(**readWrite**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) : [Closeable](-closeable/index.md)  <br>More info  <br>An open file for reading and writing; using either streaming and random access.  <br><br><br>
| <a name="okio/FileMetadata///PointingToDeclaration/"></a>[FileMetadata](-file-metadata/index.md)| <a name="okio/FileMetadata///PointingToDeclaration/"></a>[common]  <br>Content  <br>class [FileMetadata](-file-metadata/index.md)(**isRegularFile**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **isDirectory**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **createdAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **lastModifiedAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **lastAccessedAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?)  <br>More info  <br>Description of a file or another object referenced by a path.  <br><br><br>
| <a name="okio/FileNotFoundException///PointingToDeclaration/"></a>[FileNotFoundException](-file-not-found-exception/index.md)| <a name="okio/FileNotFoundException///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>class [FileNotFoundException](-file-not-found-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)  <br>[jvm]  <br>typealias [FileNotFoundException](-file-not-found-exception/index.md) = [FileNotFoundException](https://docs.oracle.com/javase/8/docs/api/java/io/FileNotFoundException.html)  <br><br><br>
| <a name="okio/FileSystem///PointingToDeclaration/"></a>[FileSystem](-file-system/index.md)| <a name="okio/FileSystem///PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract class [FileSystem](-file-system/index.md)  <br>More info  <br>Read and write access to a hierarchical collection of files, addressed by [paths](-path/index.md).  <br><br><br>[js]  <br>Content  <br>abstract class [FileSystem](-file-system/index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ForwardingFileSystem///PointingToDeclaration/"></a>[ForwardingFileSystem](-forwarding-file-system/index.md)| <a name="okio/ForwardingFileSystem///PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract class [ForwardingFileSystem](-forwarding-file-system/index.md)(**delegate**: [FileSystem](-file-system/index.md)) : [FileSystem](-file-system/index.md)  <br>More info  <br>A [FileSystem](-file-system/index.md) that forwards calls to another, intended for subclassing.  <br><br><br>
| <a name="okio/ForwardingSink///PointingToDeclaration/"></a>[ForwardingSink](-forwarding-sink/index.md)| <a name="okio/ForwardingSink///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract class [ForwardingSink](-forwarding-sink/index.md)(**delegate**: [Sink](-sink/index.md)) : [Sink](-sink/index.md)  <br>More info  <br>A [Sink](-sink/index.md) which forwards calls to another.  <br><br><br>
| <a name="okio/ForwardingSource///PointingToDeclaration/"></a>[ForwardingSource](-forwarding-source/index.md)| <a name="okio/ForwardingSource///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract class [ForwardingSource](-forwarding-source/index.md)(**delegate**: [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)) : [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>A [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557) which forwards calls to another.  <br><br><br>
| <a name="okio/ForwardingTimeout///PointingToDeclaration/"></a>[ForwardingTimeout](-forwarding-timeout/index.md)| <a name="okio/ForwardingTimeout///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open class [ForwardingTimeout](-forwarding-timeout/index.md)(**delegate**: [Timeout](-timeout/index.md)) : [Timeout](-timeout/index.md)  <br>More info  <br>A [Timeout](-timeout/index.md) which forwards calls to another.  <br><br><br>
| <a name="okio/GzipSink///PointingToDeclaration/"></a>[GzipSink](-gzip-sink/index.md)| <a name="okio/GzipSink///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [GzipSink](-gzip-sink/index.md)(**sink**: [Sink](-sink/index.md)) : [Sink](-sink/index.md)  <br>More info  <br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.  <br><br><br>
| <a name="okio/GzipSource///PointingToDeclaration/"></a>[GzipSource](-gzip-source/index.md)| <a name="okio/GzipSource///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [GzipSource](-gzip-source/index.md)(**source**: [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)) : [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source.  <br><br><br>
| <a name="okio/HashingSink///PointingToDeclaration/"></a>[HashingSink](-hashing-sink/index.md)| <a name="okio/HashingSink///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>class [HashingSink](-hashing-sink/index.md) : [Sink](-sink/index.md)  <br>[jvm]  <br>class [HashingSink](-hashing-sink/index.md) : [ForwardingSink](-forwarding-sink/index.md), [Sink](-sink/index.md)  <br>More info  <br>A sink that computes a hash of the full stream of bytes it has accepted.  <br><br><br>
| <a name="okio/HashingSource///PointingToDeclaration/"></a>[HashingSource](-hashing-source/index.md)| <a name="okio/HashingSource///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>class [HashingSource](-hashing-source/index.md) : [Source](-source/index.md)  <br>[jvm]  <br>class [HashingSource](-hashing-source/index.md) : [ForwardingSource](-forwarding-source/index.md), [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>A source that computes a hash of the full stream of bytes it has supplied.  <br><br><br>
| <a name="okio/InflaterSource///PointingToDeclaration/"></a>[InflaterSource](-inflater-source/index.md)| <a name="okio/InflaterSource///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [InflaterSource](-inflater-source/index.md) : [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source.  <br><br><br>
| <a name="okio/IOException///PointingToDeclaration/"></a>[IOException](-i-o-exception/index.md)| <a name="okio/IOException///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open class [IOException](-i-o-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **cause**: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)?) : [Exception](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)  <br>[jvm]  <br>typealias [IOException](-i-o-exception/index.md) = [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html)  <br><br><br>
| <a name="okio/Options///PointingToDeclaration/"></a>[Options](-options/index.md)| <a name="okio/Options///PointingToDeclaration/"></a>[common]  <br>Content  <br>class [Options](-options/index.md) : [AbstractList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-abstract-list/index.html)<[ByteString](-byte-string/index.md)> , [RandomAccess](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-random-access/index.html)  <br>More info  <br>An indexed set of values that may be read with [BufferedSource.select](-buffered-source/select.md).  <br><br><br>
| <a name="okio/Path///PointingToDeclaration/"></a>[Path](-path/index.md)| <a name="okio/Path///PointingToDeclaration/"></a>[common]  <br>Content  <br>class [Path](-path/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[Path](-path/index.md)>   <br>More info  <br>A hierarchical address on a file system.  <br><br><br>[jvm]  <br>Content  <br>class [Path](-path/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[Path](-path/index.md)>   <br>More info  <br>  <br><br><br>
| <a name="okio/Pipe///PointingToDeclaration/"></a>[Pipe](-pipe/index.md)| <a name="okio/Pipe///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [Pipe](-pipe/index.md)(**maxBufferSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>A source and a sink that are attached.  <br><br><br>
| <a name="okio/ResourceFileSystem///PointingToDeclaration/"></a>[ResourceFileSystem](-resource-file-system/index.md)| <a name="okio/ResourceFileSystem///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [ResourceFileSystem](-resource-file-system/index.md) : [FileSystem](-file-system/index.md#%5Bokio%2FFileSystem%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>A file system exposing Java classpath resources.  <br><br><br>
| <a name="okio/Sink///PointingToDeclaration/"></a>[Sink](-sink/index.md)| <a name="okio/Sink///PointingToDeclaration/"></a>[common]  <br>Content  <br>interface [Sink](-sink/index.md) : [Closeable](-closeable/index.md)  <br>More info  <br>Receives a stream of bytes.  <br><br><br>[jvm]  <br>Content  <br>interface [Sink](-sink/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/Source///PointingToDeclaration/"></a>[Source](-source/index.md)| <a name="okio/Source///PointingToDeclaration/"></a>[common]  <br>Content  <br>interface [Source](-source/index.md) : [Closeable](-closeable/index.md)  <br>More info  <br>Supplies a stream of bytes.  <br><br><br>
| <a name="okio/Throttler///PointingToDeclaration/"></a>[Throttler](-throttler/index.md)| <a name="okio/Throttler///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [Throttler](-throttler/index.md)  <br>More info  <br>Enables limiting of Source and Sink throughput.  <br><br><br>
| <a name="okio/Timeout///PointingToDeclaration/"></a>[Timeout](-timeout/index.md)| <a name="okio/Timeout///PointingToDeclaration/"></a>[common]  <br>Content  <br>open class [Timeout](-timeout/index.md)  <br>More info  <br>A policy on how much time to spend on a task before giving up.  <br><br><br>[jvm]  <br>Content  <br>open class [Timeout](-timeout/index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ZipFileSystem///PointingToDeclaration/"></a>[ZipFileSystem](-zip-file-system/index.md)| <a name="okio/ZipFileSystem///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>class [ZipFileSystem](-zip-file-system/index.md) : [FileSystem](-file-system/index.md#%5Bokio%2FFileSystem%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>Read only access to a [zip file](https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE_6.2.0.txt) and common [extra fields](https://opensource.apple.com/source/zip/zip-6/unzip/unzip/proginfo/extra.fld).  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio//appendingSink/java.io.File#/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio//appendingSink/java.io.File#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[appendingSink](appending-sink.md)(): [Sink](-sink/index.md)  <br>More info  <br>Returns a sink that writes to file.  <br><br><br>
| <a name="okio//asResourceFileSystem/java.lang.ClassLoader#/PointingToDeclaration/"></a>[asResourceFileSystem](as-resource-file-system.md)| <a name="okio//asResourceFileSystem/java.lang.ClassLoader#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [ClassLoader](https://docs.oracle.com/javase/8/docs/api/java/lang/ClassLoader.html).[asResourceFileSystem](as-resource-file-system.md)(): [FileSystem](-file-system/index.md#%5Bokio%2FFileSystem%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br><br><br>
| <a name="okio//blackholeSink/#/PointingToDeclaration/"></a>[blackholeSink](blackhole-sink.md)| <a name="okio//blackholeSink/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "blackhole")  <br>  <br>fun [blackholeSink](blackhole-sink.md)(): [Sink](-sink/index.md)  <br>More info  <br>Returns a sink that writes nowhere.  <br><br><br>
| <a name="okio//buffer/okio.Sink#/PointingToDeclaration/"></a>[buffer](buffer.md)| <a name="okio//buffer/okio.Sink#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [Sink](-sink/index.md).[buffer](buffer.md)(): [BufferedSink](-buffered-sink/index.md)  <br>More info  <br>Returns a new sink that buffers writes to sink.  <br><br><br>[common]  <br>Content  <br>fun [Source](-source/index.md).[buffer](buffer.md)(): [BufferedSource](-buffered-source/index.md)  <br>More info  <br>Returns a new source that buffers reads from source.  <br><br><br>
| <a name="okio//cipherSink/okio.Sink#javax.crypto.Cipher/PointingToDeclaration/"></a>[cipherSink](cipher-sink.md)| <a name="okio//cipherSink/okio.Sink#javax.crypto.Cipher/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Sink](-sink/index.md).[cipherSink](cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](-cipher-sink/index.md)  <br>More info  <br>Returns a sink that uses cipher to encrypt or decrypt this.  <br><br><br>
| <a name="okio//cipherSource/okio.Source#javax.crypto.Cipher/PointingToDeclaration/"></a>[cipherSource](cipher-source.md)| <a name="okio//cipherSource/okio.Source#javax.crypto.Cipher/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557).[cipherSource](cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](-cipher-source/index.md)  <br>More info  <br>Returns a source that uses cipher to encrypt or decrypt this.  <br><br><br>
| <a name="okio//deflate/okio.Sink#java.util.zip.Deflater/PointingToDeclaration/"></a>[deflate](deflate.md)| <a name="okio//deflate/okio.Sink#java.util.zip.Deflater/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Sink](-sink/index.md).[deflate](deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) = Deflater()): [DeflaterSink](-deflater-sink/index.md)  <br>More info  <br>Returns an [DeflaterSink](-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](-sink/index.md) while writing.  <br><br><br>
| <a name="okio//gzip/okio.Sink#/PointingToDeclaration/"></a>[gzip](gzip.md)| <a name="okio//gzip/okio.Sink#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Sink](-sink/index.md).[gzip](gzip.md)(): [GzipSink](-gzip-sink/index.md)  <br>More info  <br>Returns a [GzipSink](-gzip-sink/index.md) that gzip-compresses to this [Sink](-sink/index.md) while writing.  <br><br><br>[jvm]  <br>Content  <br>inline fun [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557).[gzip](gzip.md)(): [GzipSource](-gzip-source/index.md)  <br>More info  <br>Returns a [GzipSource](-gzip-source/index.md) that gzip-decompresses this [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557) while reading.  <br><br><br>
| <a name="okio//hashingSink/okio.Sink#java.security.MessageDigest/PointingToDeclaration/"></a>[hashingSink](hashing-sink.md)| <a name="okio//hashingSink/okio.Sink#java.security.MessageDigest/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Sink](-sink/index.md).[hashingSink](hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](-hashing-sink/index.md)  <br>More info  <br>Returns a sink that uses digest to hash this.  <br><br><br>[jvm]  <br>Content  <br>fun [Sink](-sink/index.md).[hashingSink](hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](-hashing-sink/index.md)  <br>More info  <br>Returns a sink that uses mac to hash this.  <br><br><br>
| <a name="okio//hashingSource/okio.Source#java.security.MessageDigest/PointingToDeclaration/"></a>[hashingSource](hashing-source.md)| <a name="okio//hashingSource/okio.Source#java.security.MessageDigest/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557).[hashingSource](hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](-hashing-source/index.md)  <br>More info  <br>Returns a source that uses digest to hash this.  <br><br><br>[jvm]  <br>Content  <br>fun [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557).[hashingSource](hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](-hashing-source/index.md)  <br>More info  <br>Returns a source that uses mac to hash this.  <br><br><br>
| <a name="okio//inflate/okio.Source#java.util.zip.Inflater/PointingToDeclaration/"></a>[inflate](inflate.md)| <a name="okio//inflate/okio.Source#java.util.zip.Inflater/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557).[inflate](inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](-inflater-source/index.md)  <br>More info  <br>Returns an [InflaterSource](-inflater-source/index.md) that DEFLATE-decompresses this [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557) while reading.  <br><br><br>
| <a name="okio//openZip/okio.FileSystem#okio.Path/PointingToDeclaration/"></a>[openZip](open-zip.md)| <a name="okio//openZip/okio.FileSystem#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [FileSystem](-file-system/index.md#%5Bokio%2FFileSystem%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557).[openZip](open-zip.md)(zipPath: [Path](-path/index.md)): [FileSystem](-file-system/index.md#%5Bokio%2FFileSystem%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br><br><br>
| <a name="okio//sink/java.io.OutputStream#/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio//sink/java.io.OutputStream#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html).[sink](sink.md)(): [Sink](-sink/index.md)  <br>More info  <br>Returns a sink that writes to out.  <br><br><br>[jvm]  <br>Content  <br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[sink](sink.md)(): [Sink](-sink/index.md)  <br>More info  <br>Returns a sink that writes to socket.  <br><br><br>[jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[sink](sink.md)(append: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sink](-sink/index.md)  <br>More info  <br>Returns a sink that writes to file.  <br><br><br>[jvm]  <br>Content  <br>@IgnoreJRERequirement()  <br>  <br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[sink](sink.md)(vararg options: [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)): [Sink](-sink/index.md)  <br>More info  <br>Returns a source that reads from path.  <br><br><br>
| <a name="okio//source/java.io.File#/PointingToDeclaration/"></a>[source](source.md)| <a name="okio//source/java.io.File#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[source](source.md)(): [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>Returns a source that reads from file.  <br><br><br>[jvm]  <br>Content  <br>fun [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html).[source](source.md)(): [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>Returns a source that reads from in.  <br><br><br>[jvm]  <br>Content  <br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[source](source.md)(): [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>Returns a source that reads from socket.  <br><br><br>[jvm]  <br>Content  <br>@IgnoreJRERequirement()  <br>  <br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[source](source.md)(vararg options: [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)): [Source](-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F780401557)  <br>More info  <br>Returns a sink that writes to path.  <br><br><br>
| <a name="okio//toByteString/#/PointingToDeclaration/"></a>[toByteString](to-byte-string.md)| <a name="okio//toByteString/#/PointingToDeclaration/"></a>[apple]  <br>Content  <br>fun <ERROR CLASS>.[toByteString](to-byte-string.md)(): <ERROR CLASS>  <br><br><br>
| <a name="okio//use/TypeParam(bounds=[okio.Closeable?])#kotlin.Function1[TypeParam(bounds=[okio.Closeable?]),TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[use](use.md)| <a name="okio//use/TypeParam(bounds=[okio.Closeable?])#kotlin.Function1[TypeParam(bounds=[okio.Closeable?]),TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](use.md) : [Closeable](-closeable/index.md)?, [R](use.md)> [T](use.md).[use](use.md)(block: ([T](use.md)) -> [R](use.md)): [R](use.md)  <br>More info  <br>Execute block then close this.  <br><br><br>
| <a name="okio//utf8Size/kotlin.String#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[utf8Size](utf8-size.md)| <a name="okio//utf8Size/kotlin.String#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "size")  <br>  <br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[utf8Size](utf8-size.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = length): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the number of bytes used to encode the slice of string as UTF-8 when using [BufferedSink.writeUtf8](-buffered-sink/write-utf8.md).  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio//Okio/#/PointingToDeclaration/"></a>[Okio](-okio.md)| <a name="okio//Okio/#/PointingToDeclaration/"></a> [jvm] val [Okio](-okio.md): -DeprecatedOkio   <br>
| <a name="okio//Utf8/#/PointingToDeclaration/"></a>[Utf8](-utf8.md)| <a name="okio//Utf8/#/PointingToDeclaration/"></a> [jvm] val [Utf8](-utf8.md): -DeprecatedUtf8   <br>

