//[okio](../../index.md)/[okio](../index.md)/[ByteString](index.md)



# ByteString  
 [common] open class [ByteString](index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[ByteString](index.md)> 

An immutable sequence of bytes.



Byte strings compare lexicographically as a sequence of **unsigned** bytes. That is, the byte string ff sorts after 00. This is counter to the sort order of the corresponding bytes, where -1 sorts before 0.



**Full disclosure:** this class provides untrusted input and output streams with raw access to the underlying byte array. A hostile stream implementation could keep a reference to the mutable byte string, violating the immutable guarantee of this class. For this reason a byte string's immutability guarantee cannot be relied upon for security in applets and other environments that run both trusted and untrusted code in the same process.

   
 [jvm] open class [ByteString](index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[ByteString](index.md)>    


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ByteString.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/ByteString.Companion///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ByteString/asByteBuffer/#/PointingToDeclaration/"></a>[asByteBuffer](as-byte-buffer.md)| <a name="okio/ByteString/asByteBuffer/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [asByteBuffer](as-byte-buffer.md)(): [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)  <br>More info  <br>Returns a ByteBuffer view of the bytes in this ByteString.  <br><br><br>
| <a name="okio/ByteString/base64/#/PointingToDeclaration/"></a>[base64](base64.md)| <a name="okio/ByteString/base64/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [base64](base64.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Returns this byte string encoded as [Base64](http://www.ietf.org/rfc/rfc2045.txt).  <br><br><br>[jvm]  <br>Content  <br>open fun [base64](base64.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/base64Url/#/PointingToDeclaration/"></a>[base64Url](base64-url.md)| <a name="okio/ByteString/base64Url/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [base64Url](base64-url.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Returns this byte string encoded as [URL-safe Base64](http://www.ietf.org/rfc/rfc4648.txt).  <br><br><br>[jvm]  <br>Content  <br>open fun [base64Url](base64-url.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/compareTo/#okio.ByteString/PointingToDeclaration/"></a>[compareTo](compare-to.md)| <a name="okio/ByteString/compareTo/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open operator override fun [compareTo](compare-to.md)(other: [ByteString](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ByteString/copyInto/#kotlin.Int#kotlin.ByteArray#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[copyInto](copy-into.md)| <a name="okio/ByteString/copyInto/#kotlin.Int#kotlin.ByteArray#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [copyInto](copy-into.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, target: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), targetOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))  <br>More info  <br>Copies bytes of this in [offset..offset+byteCount] to other in [targetOffset..targetOffset+byteCount].  <br><br><br>[jvm]  <br>Content  <br>open fun [copyInto](copy-into.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, target: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), targetOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/endsWith/#kotlin.ByteArray/PointingToDeclaration/"></a>[endsWith](ends-with.md)| <a name="okio/ByteString/endsWith/#kotlin.ByteArray/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>fun [endsWith](ends-with.md)(suffix: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[common, jvm]  <br>fun [endsWith](ends-with.md)(suffix: [ByteString](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/ByteString/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](equals.md)| <a name="okio/ByteString/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/ByteString/get/#kotlin.Int/PointingToDeclaration/"></a>[get](get.md)| <a name="okio/ByteString/get/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")  <br>  <br>operator fun [get](get.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>Returns the byte at index.  <br><br><br>[jvm]  <br>Content  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")  <br>  <br>operator fun [get](get.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/hashCode/#/PointingToDeclaration/"></a>[hashCode](hash-code.md)| <a name="okio/ByteString/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ByteString/hex/#/PointingToDeclaration/"></a>[hex](hex.md)| <a name="okio/ByteString/hex/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [hex](hex.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Returns this byte string encoded in hexadecimal.  <br><br><br>[jvm]  <br>Content  <br>open fun [hex](hex.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/hmacSha1/#okio.ByteString/PointingToDeclaration/"></a>[hmacSha1](hmac-sha1.md)| <a name="okio/ByteString/hmacSha1/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>fun [hmacSha1](hmac-sha1.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br>[jvm]  <br>open fun [hmacSha1](hmac-sha1.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br>More info  <br>Returns the 160-bit SHA-1 HMAC of this byte string.  <br><br><br>
| <a name="okio/ByteString/hmacSha256/#okio.ByteString/PointingToDeclaration/"></a>[hmacSha256](hmac-sha256.md)| <a name="okio/ByteString/hmacSha256/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>fun [hmacSha256](hmac-sha256.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br>[jvm]  <br>open fun [hmacSha256](hmac-sha256.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br>More info  <br>Returns the 256-bit SHA-256 HMAC of this byte string.  <br><br><br>
| <a name="okio/ByteString/hmacSha512/#okio.ByteString/PointingToDeclaration/"></a>[hmacSha512](hmac-sha512.md)| <a name="okio/ByteString/hmacSha512/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>fun [hmacSha512](hmac-sha512.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br>[jvm]  <br>open fun [hmacSha512](hmac-sha512.md)(key: [ByteString](index.md)): [ByteString](index.md)  <br>More info  <br>Returns the 512-bit SHA-512 HMAC of this byte string.  <br><br><br>
| <a name="okio/ByteString/indexOf/#kotlin.ByteArray#kotlin.Int/PointingToDeclaration/"></a>[indexOf](index-of.md)| <a name="okio/ByteString/indexOf/#kotlin.ByteArray#kotlin.Int/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [indexOf](index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>open fun [indexOf](index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[common, jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [indexOf](index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ByteString/lastIndexOf/#kotlin.ByteArray#kotlin.Int/PointingToDeclaration/"></a>[lastIndexOf](last-index-of.md)| <a name="okio/ByteString/lastIndexOf/#kotlin.ByteArray#kotlin.Int/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>fun [lastIndexOf](last-index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>open fun [lastIndexOf](last-index-of.md)(other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[common]  <br>fun [lastIndexOf](last-index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [lastIndexOf](last-index-of.md)(other: [ByteString](index.md), fromIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/ByteString/md5/#/PointingToDeclaration/"></a>[md5](md5.md)| <a name="okio/ByteString/md5/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [md5](md5.md)(): [ByteString](index.md)  <br>More info  <br>Returns the 128-bit MD5 hash of this byte string.  <br><br><br>[jvm]  <br>Content  <br>fun [md5](md5.md)(): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/rangeEquals/#kotlin.Int#kotlin.ByteArray#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[rangeEquals](range-equals.md)| <a name="okio/ByteString/rangeEquals/#kotlin.Int#kotlin.ByteArray#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteString](index.md), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if the bytes of this in [offset..offset+byteCount) equal the bytes of other in [otherOffset..otherOffset+byteCount).  <br><br><br>[jvm]  <br>Content  <br>open fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>open fun [rangeEquals](range-equals.md)(offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), other: [ByteString](index.md), otherOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/sha1/#/PointingToDeclaration/"></a>[sha1](sha1.md)| <a name="okio/ByteString/sha1/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sha1](sha1.md)(): [ByteString](index.md)  <br>More info  <br>Returns the 160-bit SHA-1 hash of this byte string.  <br><br><br>[jvm]  <br>Content  <br>fun [sha1](sha1.md)(): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/sha256/#/PointingToDeclaration/"></a>[sha256](sha256.md)| <a name="okio/ByteString/sha256/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sha256](sha256.md)(): [ByteString](index.md)  <br>More info  <br>Returns the 256-bit SHA-256 hash of this byte string.  <br><br><br>[jvm]  <br>Content  <br>fun [sha256](sha256.md)(): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/sha512/#/PointingToDeclaration/"></a>[sha512](sha512.md)| <a name="okio/ByteString/sha512/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sha512](sha512.md)(): [ByteString](index.md)  <br>More info  <br>Returns the 512-bit SHA-512 hash of this byte string.  <br><br><br>[jvm]  <br>Content  <br>fun [sha512](sha512.md)(): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/startsWith/#kotlin.ByteArray/PointingToDeclaration/"></a>[startsWith](starts-with.md)| <a name="okio/ByteString/startsWith/#kotlin.ByteArray/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>fun [startsWith](starts-with.md)(prefix: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[common, jvm]  <br>fun [startsWith](starts-with.md)(prefix: [ByteString](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/ByteString/string/#java.nio.charset.Charset/PointingToDeclaration/"></a>[string](string.md)| <a name="okio/ByteString/string/#java.nio.charset.Charset/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [string](string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Constructs a new String by decoding the bytes using charset.  <br><br><br>
| <a name="okio/ByteString/substring/#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[substring](substring.md)| <a name="okio/ByteString/substring/#kotlin.Int#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [substring](substring.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [ByteString](index.md)  <br>More info  <br>Returns a byte string that is a substring of this byte string, beginning at the specified beginIndex and ends at the specified endIndex.  <br><br><br>[jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>open fun [substring](substring.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = DEFAULT__ByteString_size): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/toAsciiLowercase/#/PointingToDeclaration/"></a>[toAsciiLowercase](to-ascii-lowercase.md)| <a name="okio/ByteString/toAsciiLowercase/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [toAsciiLowercase](to-ascii-lowercase.md)(): [ByteString](index.md)  <br>More info  <br>Returns a byte string equal to this byte string, but with the bytes 'A' through 'Z' replaced with the corresponding byte in 'a' through 'z'.  <br><br><br>[jvm]  <br>Content  <br>open fun [toAsciiLowercase](to-ascii-lowercase.md)(): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/toAsciiUppercase/#/PointingToDeclaration/"></a>[toAsciiUppercase](to-ascii-uppercase.md)| <a name="okio/ByteString/toAsciiUppercase/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [toAsciiUppercase](to-ascii-uppercase.md)(): [ByteString](index.md)  <br>More info  <br>Returns a byte string equal to this byte string, but with the bytes 'a' through 'z' replaced with the corresponding byte in 'A' through 'Z'.  <br><br><br>[jvm]  <br>Content  <br>open fun [toAsciiUppercase](to-ascii-uppercase.md)(): [ByteString](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/toByteArray/#/PointingToDeclaration/"></a>[toByteArray](to-byte-array.md)| <a name="okio/ByteString/toByteArray/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [toByteArray](to-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>Returns a byte array containing a copy of the bytes in this ByteString.  <br><br><br>[jvm]  <br>Content  <br>open fun [toByteArray](to-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/toString/#/PointingToDeclaration/"></a>[toString](to-string.md)| <a name="okio/ByteString/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Returns a human-readable string that describes the contents of this byte string.  <br><br><br>[jvm]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/utf8/#/PointingToDeclaration/"></a>[utf8](utf8.md)| <a name="okio/ByteString/utf8/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [utf8](utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Constructs a new String by decoding the bytes as UTF-8.  <br><br><br>[jvm]  <br>Content  <br>open fun [utf8](utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/ByteString/write/#java.io.OutputStream/PointingToDeclaration/"></a>[write](write.md)| <a name="okio/ByteString/write/#java.io.OutputStream/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [write](write.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html))  <br>More info  <br>Writes the contents of this byte string to out.  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ByteString/size/#/PointingToDeclaration/"></a>[size](size.md)| <a name="okio/ByteString/size/#/PointingToDeclaration/"></a> [common] val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)Returns the number of bytes in this ByteString.   <br> [jvm] val [size](size.md): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)   <br>

