//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[indexOf](index-of.md)

# indexOf

[common]\
expect abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

Equivalent to [indexOf(b, 0)](index-of.md).

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

[jvm, nonJvm]\
actual abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

[jvm, nonJvm]\
actual abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

[jvm, nonJvm]\
actual abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

[jvm, nonJvm]\
actual abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

[common]\
expect abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

Returns the index of the first `b` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `b` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.

```java
Buffer buffer = new Buffer();
buffer.writeUtf8("Don't move! He can't see us if we don't move.");

byte m = 'm';
assertEquals(6,  buffer.indexOf(m));
assertEquals(40, buffer.indexOf(m, 12));
```

[common]\
expect abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

Returns the index of `b` if it is found in the range of `fromIndex` inclusive to `toIndex` exclusive. If `b` isn't found, or if `fromIndex == toIndex`, then -1 is returned.

The scan terminates at either `toIndex` or the end of the buffer, whichever comes first. The maximum number of bytes scanned is `toIndex-fromIndex`.

[common]\
expect abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

Equivalent to [indexOf(bytes, 0)](index-of.md).

[common]\
expect abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)

Returns the index of the first match for `bytes` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `bytes` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested bytes are found.

```java
ByteString MOVE = ByteString.encodeUtf8("move");

Buffer buffer = new Buffer();
buffer.writeUtf8("Don't move! He can't see us if we don't move.");

assertEquals(6,  buffer.indexOf(MOVE));
assertEquals(40, buffer.indexOf(MOVE, 12));
```