//[okio](../../../index.md)/[okio](../index.md)/[BufferedSink](index.md)/[writeIntLe](write-int-le.md)

# writeIntLe

[common]\
expect abstract fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)

Writes a little-endian int to this sink using four bytes.

```java
Buffer buffer = new Buffer();
buffer.writeIntLe(2147483647);
buffer.writeIntLe(15);

assertEquals(8, buffer.size());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)