//[okio](../../index.md)/[okio](index.md)/[inMemorySocketPair](in-memory-socket-pair.md)

# inMemorySocketPair

[jvm]\
fun [inMemorySocketPair](in-memory-socket-pair.md)(maxBufferSize: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Array](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-array/index.html)&lt;Socket&gt;

Returns an array of two symmetric sockets, *A* (element 0) and *B* (element 1) that are mutually connected:

- 
   Pipe AB connects *A*’s sink to *B*’s source.
- 
   Pipe BA connects *B*’s sink to *A*’s source.

Each pipe uses a buffer to decouple source and sink. This buffer has a user-specified maximum size. When a socket writer outruns its corresponding reader, the buffer fills up and eventually writes to the sink will block until the reader has caught up. Symmetrically, if a reader outruns its writer, reads block until there is data to be read.

There is a buffer for Pipe AB and another for Pipe BA. The maximum amount of memory that could be held by the two sockets together is `maxBufferSize * 2`.

Limit the amount of time spent waiting for the other party by configuring [timeouts](-timeout/index.md) on the source and the sink.

When the sink is closed, source reads will continue to complete normally until the buffer is exhausted. At that point reads will return -1, indicating the end of the stream. But if the source is closed first, writes to the sink will immediately fail with an [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html).

Canceling either socket immediately fails all reads and writes on both sockets.