//[okio](../../../index.md)/[okio](../index.md)/[Socket](index.md)

# Socket

[common]\
interface [Socket](index.md)

A pair of streams for interactive communication with another machine.

Send data to the peer by writing to [sink](sink.md), and read data from the peer by reading from [source](source.md).

This can be implemented by a plain TCP socket. It can also be layered to add features like security (as in a TLS socket) or connectivity (as in a proxy socket).

Closing the [source](source.md) does not impact the [sink](sink.md), and vice versa.

You must close the source and the sink to release the resources held by this socket. If you're using both from the same thread, you can do that with nested `use` blocks:

```kotlin
socket.source.use { source ->
  socket.sink.use { sink ->
    readAndWrite(source, sink)
  }
}
```

## Properties

| Name | Summary |
|---|---|
| [sink](sink.md) | [common]<br>abstract val [sink](sink.md): [Sink](../-sink/index.md) |
| [source](source.md) | [common]<br>abstract val [source](source.md): [Source](../-source/index.md) |

## Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | [common]<br>abstract fun [cancel](cancel.md)()<br>Fail any in-flight and future operations. After canceling: |