//[okio](../../../index.md)/[okio](../index.md)/[FileHandle](index.md)

# FileHandle

[common]\
abstract class [FileHandle](index.md)(val readWrite: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) : [Closeable](../-closeable/index.md)

An open file for reading and writing; using either streaming and random access.

Use [read](read.md) and [write](write.md) to perform one-off random-access reads and writes. Use [source](source.md), [sink](sink.md), and [appendingSink](appending-sink.md) for streaming reads and writes.

File handles must be closed when they are no longer needed. It is an error to read, write, or create streams after a file handle is closed. The operating system resources held by a file handle will be released once the file handle **and** all of its streams are closed.

Although this class offers both reading and writing APIs, file handle instances may be read-only or write-only. For example, a handle to a file on a read-only file system will throw an exception if a write is attempted.

File handles may be used by multiple threads concurrently. But the individual sources and sinks produced by a file handle are not safe for concurrent use.

## Constructors

| | |
|---|---|
| [FileHandle](-file-handle.md) | [common]<br>fun [FileHandle](-file-handle.md)(readWrite: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [common]<br>fun [appendingSink](appending-sink.md)(): [Sink](../-sink/index.md)<br>Returns a sink that writes to this starting at the end. The returned sink must be closed when it is no longer needed. |
| [close](close.md) | [common]<br>override fun [close](close.md)()<br>Closes this object and releases the resources it holds. It is an error to use an object after it has been closed. It is safe to close an object more than once. |
| [flush](flush.md) | [common]<br>fun [flush](flush.md)()<br>Pushes all buffered bytes to their final destination. |
| [position](position.md) | [common]<br>fun [position](position.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the position of [sink](position.md) in the file. The argument [sink](position.md) must be either a sink produced by this file handle, or a [BufferedSink](../-buffered-sink/index.md) that directly wraps such a sink. If the parameter is a [BufferedSink](../-buffered-sink/index.md), it adjusts for buffered bytes.<br>[common]<br>fun [position](position.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the position of [source](position.md) in the file. The argument [source](position.md) must be either a source produced by this file handle, or a [BufferedSource](../-buffered-source/index.md) that directly wraps such a source. If the parameter is a [BufferedSource](../-buffered-source/index.md), it adjusts for buffered bytes. |
| [read](read.md) | [common]<br>fun [read](read.md)(fileOffset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Reads at least 1, and up to [byteCount](read.md) bytes from this starting at [fileOffset](read.md) and appends them to [sink](read.md). Returns the number of bytes read, or -1 if [fileOffset](read.md) equals [size](size.md).<br>[common]<br>fun [read](read.md)(fileOffset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), array: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), arrayOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>Reads at least 1, and up to [byteCount](read.md) bytes from this starting at [fileOffset](read.md) and copies them to [array](read.md) at [arrayOffset](read.md). Returns the number of bytes read, or -1 if [fileOffset](read.md) equals [size](size.md). |
| [reposition](reposition.md) | [common]<br>fun [reposition](reposition.md)(sink: [Sink](../-sink/index.md), position: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Change the position of [sink](reposition.md) in the file to [position](reposition.md). The argument [sink](reposition.md) must be either a sink produced by this file handle, or a [BufferedSink](../-buffered-sink/index.md) that directly wraps such a sink. If the parameter is a [BufferedSink](../-buffered-sink/index.md), it emits for buffered bytes.<br>[common]<br>fun [reposition](reposition.md)(source: [Source](../-source/index.md), position: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Change the position of [source](reposition.md) in the file to [position](reposition.md). The argument [source](reposition.md) must be either a source produced by this file handle, or a [BufferedSource](../-buffered-source/index.md) that directly wraps such a source. If the parameter is a [BufferedSource](../-buffered-source/index.md), it will skip or clear buffered bytes. |
| [resize](resize.md) | [common]<br>fun [resize](resize.md)(size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Changes the number of bytes in this file to [size](resize.md). This will remove bytes from the end if the new size is smaller. It will add `0` bytes to the end if it is larger. |
| [sink](sink.md) | [common]<br>fun [sink](sink.md)(fileOffset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0): [Sink](../-sink/index.md)<br>Returns a sink that writes to this starting at [fileOffset](sink.md). The returned sink must be closed when it is no longer needed. |
| [size](size.md) | [common]<br>fun [size](size.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the total number of bytes in the file. This will change if the file size changes. |
| [source](source.md) | [common]<br>fun [source](source.md)(fileOffset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0): [Source](../-source/index.md)<br>Returns a source that reads from this starting at [fileOffset](source.md). The returned source must be closed when it is no longer needed. |
| [write](write.md) | [common]<br>fun [write](write.md)(fileOffset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes [byteCount](write.md) bytes from [source](write.md) and writes them to this at [fileOffset](write.md).<br>[common]<br>fun [write](write.md)(fileOffset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), array: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), arrayOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html))<br>Reads [byteCount](write.md) bytes from [array](write.md) and writes them to this at [fileOffset](write.md). |

## Properties

| Name | Summary |
|---|---|
| [lock](lock.md) | [common]<br>val [lock](lock.md): [Lock](../-lock/index.md) |
| [readWrite](read-write.md) | [common]<br>val [readWrite](read-write.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>True if this handle supports both reading and writing. If this is false all write operations including [write](write.md), [sink](sink.md), [resize](resize.md), and [flush](flush.md) will all throw [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html) if called. |
