//[okio](../../../index.md)/[okio](../index.md)/[BufferedSink](index.md)/[writeLong](write-long.md)

# writeLong

[common]\
expect abstract fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)

Writes a big-endian long to this sink using eight bytes.

```java
Buffer buffer = new Buffer();
buffer.writeLong(9223372036854775807L);
buffer.writeLong(15);

assertEquals(16, buffer.size());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [BufferedSink](index.md)
