//[okio](../../../index.md)/[okio](../index.md)/[ForwardingSink](index.md)

# ForwardingSink

abstract class [ForwardingSink](index.md)(val delegate: [Sink](../-sink/index.md)) : [Sink](../-sink/index.md)

A [Sink](../-sink/index.md) which forwards calls to another. Useful for subclassing.

#### Inheritors

| |
|---|
| [HashingSink](../-hashing-sink/index.md) |

## Constructors

| | |
|---|---|
| [ForwardingSink](-forwarding-sink.md) | [jvm]<br>constructor(delegate: [Sink](../-sink/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;delegate&quot;)<br>val [delegate](delegate.md): [Sink](../-sink/index.md)<br>[Sink](../-sink/index.md) to which this instance is delegating. |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Sink](../-sink/index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [close](close.md) | [jvm]<br>open override fun [close](close.md)() |
| [deflate](../deflate.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[deflate](../deflate.md)(deflater: [Deflater](../-deflater/index.md) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [flush](flush.md) | [jvm]<br>open override fun [flush](flush.md)() |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSink](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this. |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md) |
| [toString](to-string.md) | [jvm]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [write](write.md) | [jvm]<br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |
