//[okio](../../../index.md)/[okio](../index.md)/[FileMetadata](index.md)

# FileMetadata

[common]\
class [FileMetadata](index.md)(**isRegularFile**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **isDirectory**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **createdAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **lastModifiedAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **lastAccessedAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?)

Description of a file or another object referenced by a path.

In simple use a file system is a mechanism for organizing files and directories on a local storage device. In practice file systems are more capable and their contents more varied. For example, a path may refer to:

<ul><li>An operating system process that consumes data, produces data, or both. For example, reading     from the /dev/urandom file on Linux returns a unique sequence of pseudorandom bytes to each     reader.</li><li>A stream that connects a pair of programs together. A pipe is a special file that a producing     program writes to and a consuming program reads from. Both programs operate concurrently. The     size of a pipe is not well defined: the writer can write as much data as the reader is able to     read.</li><li>A file on a remote file system. The performance and availability of remote files may be quite     different from that of local files!</li><li>A symbolic link (symlink) to another path. When attempting to access this path the file system     will follow the link and return data from the target path.</li><li>The same content as another path without a symlink. On UNIX file systems an inode is an     anonymous handle to a file's content, and multiple paths may target the same inode without any     other relationship to one another. A consequence of this design is that a directory with three     1 GiB files may only need 1 GiB on the storage device.</li></ul>

This class does not attempt to model these rich file system features! It exposes a limited view useful for programs with only basic file system needs. Be cautious of the potential consequences of special files when writing programs that operate on a file system.

File metadata is subject to change, and code that operates on file systems should defend against changes to the file that occur between reading metadata and subsequent operations.

## Constructors

| | |
|---|---|
| [FileMetadata](-file-metadata.md) | [common]<br>fun [FileMetadata](-file-metadata.md)(isRegularFile: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), isDirectory: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), size: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, createdAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, lastModifiedAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, lastAccessedAtMillis: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?) |

## Functions

| Name | Summary |
|---|---|
| [equals](equals.md) | [common]<br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | [common]<br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [createdAtMillis](created-at-millis.md) | [common]<br>val [createdAtMillis](created-at-millis.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?<br>Returns the system time of the host computer when this file was created, if the host file system supports this feature. |
| [isDirectory](is-directory.md) | [common]<br>val [isDirectory](is-directory.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>True if the path refers to a directory that contains 0 or more child paths. |
| [isRegularFile](is-regular-file.md) | [common]<br>val [isRegularFile](is-regular-file.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>True if this file is a container of bytes. |
| [lastAccessedAtMillis](last-accessed-at-millis.md) | [common]<br>val [lastAccessedAtMillis](last-accessed-at-millis.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?<br>Returns the system time of the host computer when this file was most recently read or written. |
| [lastModifiedAtMillis](last-modified-at-millis.md) | [common]<br>val [lastModifiedAtMillis](last-modified-at-millis.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?<br>Returns the system time of the host computer when this file was most recently written. |
| [size](size.md) | [common]<br>val [size](size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?<br>Returns the number of bytes readable from this file. |
