//[okio-nodefilesystem](../../index.md)/[okio](../index.md)/[NodeJsFileSystem](index.md)



# NodeJsFileSystem  
 [js] object [NodeJsFileSystem](index.md) : FileSystem

Use [Node.js APIs](https://nodejs.org/dist/latest-v14.x/docs/api/fs.html) to implement the Okio file system interface.



This class needs to make calls to some fs APIs that have multiple competing overloads. To unambiguously select an overload this passes undefined as the target type to some functions.

   


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/NodeJsFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio/NodeJsFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [appendingSink](appending-sink.md)(file: Path): Sink  <br><br><br>
| <a name="okio/NodeJsFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio/NodeJsFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [atomicMove](atomic-move.md)(source: Path, target: Path)  <br><br><br>
| <a name="okio/NodeJsFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio/NodeJsFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [canonicalize](canonicalize.md)(path: Path): Path  <br><br><br>
| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open fun [copy](index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(source: Path, target: Path)  <br><br><br>
| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>fun [createDirectories](index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(dir: Path)  <br><br><br>
| <a name="okio/NodeJsFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio/NodeJsFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [createDirectory](create-directory.md)(dir: Path)  <br><br><br>
| <a name="okio/NodeJsFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio/NodeJsFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [delete](delete.md)(path: Path)  <br>More info  <br>We don't know if path is a file or a directory, but we don't (yet) have an API to delete either type.  <br><br><br>
| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open fun [deleteRecursively](index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(fileOrDirectory: Path)  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[js]  <br>Content  <br>open operator fun [equals](index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>fun [exists](index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(path: Path): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[js]  <br>Content  <br>open fun [hashCode](index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/NodeJsFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio/NodeJsFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [list](list.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<Path>  <br><br><br>
| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>fun [metadata](index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(path: Path): FileMetadata  <br><br><br>
| <a name="okio/NodeJsFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio/NodeJsFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [metadataOrNull](metadata-or-null.md)(path: Path): FileMetadata?  <br><br><br>
| <a name="okio/NodeJsFileSystem/open/#okio.Path/PointingToDeclaration/"></a>[open](open.md)| <a name="okio/NodeJsFileSystem/open/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [open](open.md)(file: Path): FileHandle  <br><br><br>
| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[read](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[js]  <br>Content  <br>inline fun <[T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)> [read](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(file: Path, readerAction: BufferedSource.() -> [T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)): [T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)  <br><br><br>
| <a name="okio/NodeJsFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/NodeJsFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [sink](sink.md)(file: Path): Sink  <br><br><br>
| <a name="okio/NodeJsFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/NodeJsFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [source](source.md)(file: Path): Source  <br><br><br>
| <a name="okio/NodeJsFileSystem/toString/#/PointingToDeclaration/"></a>[toString](to-string.md)| <a name="okio/NodeJsFileSystem/toString/#/PointingToDeclaration/"></a>[js]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[write](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[js]  <br>Content  <br>inline fun <[T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)> [write](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)(file: Path, writerAction: BufferedSink.() -> [T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)): [T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1638408678)  <br><br><br>

