//[okio](../../index.md)/[okio](../index.md)/[ForwardingTimeout](index.md)



# ForwardingTimeout  
 [jvm] open class [ForwardingTimeout](index.md)(**delegate**: [Timeout](../-timeout/index.md)) : [Timeout](../-timeout/index.md)

A [Timeout](../-timeout/index.md) which forwards calls to another. Useful for subclassing.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingTimeout/ForwardingTimeout/#okio.Timeout/PointingToDeclaration/"></a>[ForwardingTimeout](-forwarding-timeout.md)| <a name="okio/ForwardingTimeout/ForwardingTimeout/#okio.Timeout/PointingToDeclaration/"></a> [jvm] fun [ForwardingTimeout](-forwarding-timeout.md)(delegate: [Timeout](../-timeout/index.md))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingTimeout/clearDeadline/#/PointingToDeclaration/"></a>[clearDeadline](clear-deadline.md)| <a name="okio/ForwardingTimeout/clearDeadline/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [clearDeadline](clear-deadline.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Clears the deadline.  <br><br><br>
| <a name="okio/ForwardingTimeout/clearTimeout/#/PointingToDeclaration/"></a>[clearTimeout](clear-timeout.md)| <a name="okio/ForwardingTimeout/clearTimeout/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [clearTimeout](clear-timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Clears the timeout.  <br><br><br>
| <a name="okio/Timeout/deadline/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[deadline](../-timeout/deadline.md)| <a name="okio/Timeout/deadline/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [deadline](../-timeout/deadline.md)(duration: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)  <br>More info  <br>Set a deadline of now plus duration time.  <br><br><br>
| <a name="okio/ForwardingTimeout/deadlineNanoTime/#/PointingToDeclaration/"></a>[deadlineNanoTime](deadline-nano-time.md)| <a name="okio/ForwardingTimeout/deadlineNanoTime/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br><br><br>[jvm]  <br>Content  <br>open override fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Timeout](../-timeout/index.md)  <br>More info  <br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-153577437)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-153577437)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/ForwardingTimeout/hasDeadline/#/PointingToDeclaration/"></a>[hasDeadline](has-deadline.md)| <a name="okio/ForwardingTimeout/hasDeadline/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if a deadline is enabled.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-153577437)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-153577437)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Timeout/intersectWith/#okio.Timeout#kotlin.Function0[kotlin.Unit]/PointingToDeclaration/"></a>[intersectWith](../-timeout/intersect-with.md)| <a name="okio/Timeout/intersectWith/#okio.Timeout#kotlin.Function0[kotlin.Unit]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [intersectWith](../-timeout/intersect-with.md)(other: [Timeout](../-timeout/index.md), block: () -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>More info  <br>Applies the minimum intersection between this timeout and other, run block, then finally rollback this timeout's values.  <br><br><br>
| <a name="okio/ForwardingTimeout/setDelegate/#okio.Timeout/PointingToDeclaration/"></a>[setDelegate](set-delegate.md)| <a name="okio/ForwardingTimeout/setDelegate/#okio.Timeout/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [setDelegate](set-delegate.md)(delegate: [Timeout](../-timeout/index.md)): [ForwardingTimeout](index.md)  <br><br><br>
| <a name="okio/ForwardingTimeout/throwIfReached/#/PointingToDeclaration/"></a>[throwIfReached](throw-if-reached.md)| <a name="okio/ForwardingTimeout/throwIfReached/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [throwIfReached](throw-if-reached.md)()  <br>More info  <br>Throws an InterruptedIOException if the deadline has been reached or if the current thread has been interrupted.  <br><br><br>
| <a name="okio/ForwardingTimeout/timeout/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[timeout](timeout.md)| <a name="okio/ForwardingTimeout/timeout/#kotlin.Long#java.util.concurrent.TimeUnit/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)  <br>More info  <br>Wait at most timeout time before aborting an operation.  <br><br><br>
| <a name="okio/ForwardingTimeout/timeoutNanos/#/PointingToDeclaration/"></a>[timeoutNanos](timeout-nanos.md)| <a name="okio/ForwardingTimeout/timeoutNanos/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the timeout in nanoseconds, or 0 for no timeout.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-153577437)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-153577437)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/Timeout/waitUntilNotified/#kotlin.Any/PointingToDeclaration/"></a>[waitUntilNotified](../-timeout/wait-until-notified.md)| <a name="okio/Timeout/waitUntilNotified/#kotlin.Any/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [waitUntilNotified](../-timeout/wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>More info  <br>Waits on monitor until it is notified.  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingTimeout/delegate/#/PointingToDeclaration/"></a>[delegate](delegate.md)| <a name="okio/ForwardingTimeout/delegate/#/PointingToDeclaration/"></a> [jvm] var [delegate](delegate.md): [Timeout](../-timeout/index.md)   <br>

