//[okio](../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[readUtf8LineStrict](read-utf8-line-strict.md)



# readUtf8LineStrict  
[common]  
Content  
abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  
More info  


Removes and returns characters up to but not including the next line break. A line break is either "\n" or "\r\n"; these characters are not included in the result.



**On the end of the stream this method throws.** Every call must consume either '\r\n' or '\n'. If these characters are absent in the stream, an java.io.EOFException is thrown. Use this for machine-generated data where a missing line break implies truncated input.

  


[jvm]  
Content  
abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  
abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  
More info  
  


[common]  
Content  
abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  
More info  


Like [readUtf8LineStrict](read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. Use this to protect against streams that may not include "\n" or "\r\n".



The returned string will have at most limit UTF-8 bytes, and the maximum number of bytes scanned is limit + 2. If limit == 0 this will always throw an EOFException because no bytes will be scanned.



This method is safe. No bytes are discarded if the match fails, and the caller is free to try another match:

Buffer buffer = new Buffer();  
buffer.writeUtf8("12345\r\n");  
  
// This will throw! There must be \r\n or \n at the limit or before it.  
buffer.readUtf8LineStrict(4);  
  
// No bytes have been consumed so the caller can retry.  
assertEquals("12345", buffer.readUtf8LineStrict(5));  



