//[okio](../../index.md)/[okio](../index.md)/[GzipSink](index.md)



# GzipSink  
 [jvm] class [GzipSink](index.md)(**sink**: [Sink](../-sink/index.md)) : [Sink](../-sink/index.md)

A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.



###  Sync flush  


Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.



This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/GzipSink/GzipSink/#okio.Sink/PointingToDeclaration/"></a>[GzipSink](-gzip-sink.md)| <a name="okio/GzipSink/GzipSink/#okio.Sink/PointingToDeclaration/"></a> [jvm] fun [GzipSink](-gzip-sink.md)(sink: [Sink](../-sink/index.md))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/GzipSink/close/#/PointingToDeclaration/"></a>[close](close.md)| <a name="okio/GzipSink/close/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [close](close.md)()  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-782024278)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-782024278)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/GzipSink/flush/#/PointingToDeclaration/"></a>[flush](flush.md)| <a name="okio/GzipSink/flush/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [flush](flush.md)()  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-782024278)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-782024278)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/GzipSink/timeout/#/PointingToDeclaration/"></a>[timeout](timeout.md)| <a name="okio/GzipSink/timeout/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-782024278)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-782024278)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/GzipSink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[write](write.md)| <a name="okio/GzipSink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/GzipSink/deflater/#/PointingToDeclaration/"></a>[deflater](deflater.md)| <a name="okio/GzipSink/deflater/#/PointingToDeclaration/"></a> [jvm] val [deflater](deflater.md): [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)The deflater used to compress the body.   <br>

