//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)

# Buffer

[common]\
expect class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)

A collection of bytes in memory.

**Moving data from one buffer to another is fast.** Instead of copying bytes from one place in memory to another, this class just changes ownership of the underlying byte arrays.

**This buffer grows with your data.** Just like ArrayList, each buffer starts small. It consumes only the memory it needs to.

**This buffer pools its byte arrays.** When you allocate a byte array in Java, the runtime must zero-fill the requested array before returning it to you. Even if you're going to write over that space anyway. This class avoids zero-fill and GC churn by pooling byte arrays.

[jvm]\
actual class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)

[nonJvm]\
actual class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)

## Constructors

| | |
|---|---|
| [Buffer](-buffer.md) | [jvm, nonJvm]<br>constructor()<br>[common]<br>expect constructor() |

## Types

| Name | Summary |
|---|---|
| [UnsafeCursor](-unsafe-cursor/index.md) | [common]<br>expect class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](../-closeable/index.md)<br>A handle to the underlying data in a buffer. This handle is unsafe because it does not enforce its own invariants. Instead, it assumes a careful user who has studied Okio's implementation details and their consequences.<br>[jvm, nonJvm]<br>[jvm]<br>actual class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)<br>[nonJvm]<br>actual class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](../-closeable/index.md) |

## Properties

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [common]<br>expect open override val [buffer](buffer.md): [Buffer](index.md)<br>This source's internal buffer.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override val [buffer](buffer.md): [Buffer](index.md) |
| [size](size.md) | [common, jvm, nonJvm]<br>[common]<br>expect var [size](size.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;size&quot;)<br>actual var [size](size.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>actual var [size](size.md): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |

## Functions

| Name | Summary |
|---|---|
| [buffer](buffer.md) | [jvm]<br>open override fun [buffer](buffer.md)(): [Buffer](index.md)<br>Returns this source's internal buffer. |
| [buffer](../buffer.md) | [common]<br>fun [Sink](../-sink/index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data.<br>[common]<br>fun [Source](../-source/index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [cipherSource](../cipher-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)<br>Returns a source that uses [cipher](../cipher-source.md) to encrypt or decrypt this. |
| [clear](clear.md) | [common]<br>expect fun [clear](clear.md)()<br>Discards all bytes in this buffer. Calling this method when you're done with a buffer will return its segments to the pool.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [clear](clear.md)() |
| [clone](clone.md) | [jvm]<br>open override fun [clone](clone.md)(): [Buffer](index.md)<br>Returns a deep copy of this buffer. This is the same as [copy](copy.md) but allows [Buffer](index.md) to implement the [Cloneable](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-cloneable/index.html) interface on the JVM. |
| [close](close.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [close](close.md)()<br>[jvm, nonJvm]<br>actual open override fun [close](close.md)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [completeSegmentByteCount](complete-segment-byte-count.md) | [common]<br>expect fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the number of bytes in segments that are not writable. This is the number of bytes that can be flushed immediately to an underlying sink without harming throughput.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [copy](copy.md) | [common]<br>expect fun [copy](copy.md)(): [Buffer](index.md)<br>Returns a deep copy of this buffer. The returned [Buffer](index.md) initially shares the underlying [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)s. See [UnsafeCursor](-unsafe-cursor/index.md) for more details.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [copy](copy.md)(): [Buffer](index.md) |
| [copyTo](copy-to.md) | [common]<br>expect fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) = 0): [Buffer](index.md)<br>Overload of [copyTo](copy-to.md) with byteCount = size - offset, work around for https://youtrack.jetbrains.com/issue/KT-30847<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm, nonJvm]<br>actual fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm, common]<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [copyTo](copy-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) = 0, byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) = size - offset): [Buffer](index.md)<br>[common]<br>expect fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) = 0, byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Copy `byteCount` bytes from this, starting at `offset`, to `out`. |
| [deflate](../deflate.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[deflate](../deflate.md)(deflater: [Deflater](../-deflater/index.md) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [emit](emit.md) | [common]<br>expect open override fun [emit](emit.md)(): [Buffer](index.md)<br>Writes all buffered data to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Call this before this buffered sink goes out of scope so that its data can reach its destination.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [emit](emit.md)(): [Buffer](index.md) |
| [emitCompleteSegments](emit-complete-segments.md) | [common]<br>expect open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)<br>Writes complete segments to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md) |
| equals | [jvm, nonJvm]<br>[jvm]<br>open operator override fun [equals]([jvm]equals.md)(other: [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>[nonJvm]<br>open operator override fun [equals]([non-jvm]equals.md)(other: [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [exhausted](exhausted.md) | [common]<br>expect open override fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>Returns true if there are no more bytes in this source. This will block until there are bytes to read or the source is definitely exhausted.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [flush](flush.md) | [common]<br>expect open override fun [flush](flush.md)()<br>Writes all buffered data to the underlying sink, if one exists. Then that sink is recursively flushed which pushes data as far as possible towards its ultimate destination. Typically that destination is a network socket or file.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [flush](flush.md)() |
| [get](get.md) | [common]<br>expect operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)<br>Returns the byte at `pos`.<br>[jvm, nonJvm]<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;getByte&quot;)<br>actual operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)<br>[nonJvm]<br>actual operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html) |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSink](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing.<br>[zlib]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F-1717108311) while reading. |
| hashCode | [jvm, nonJvm]<br>[jvm]<br>open override fun [hashCode]([jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>open override fun [hashCode]([non-jvm]hash-code.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html) |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this. |
| [hashingSource](../hashing-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [digest](../hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [mac](../hashing-source.md) to hash this. |
| [hmacSha1](hmac-sha1.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [hmacSha1](hmac-sha1.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>actual fun [hmacSha1](hmac-sha1.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 HMAC of this buffer. |
| [hmacSha256](hmac-sha256.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [hmacSha256](hmac-sha256.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>actual fun [hmacSha256](hmac-sha256.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 HMAC of this buffer. |
| [hmacSha512](hmac-sha512.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [hmacSha512](hmac-sha512.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>actual fun [hmacSha512](hmac-sha512.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 HMAC of this buffer. |
| [indexOf](index-of.md) | [common]<br>expect open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(b, 0)](index-of.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>actual open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[common]<br>expect open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOf(bytes, 0)](index-of.md).<br>[common]<br>expect open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the index of the first `b` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `b` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found.<br>[jvm]<br>actual open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the index of `b` in this at or beyond `fromIndex`, or -1 if this buffer does not contain `b` in that range.<br>[common]<br>expect open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for `bytes` in the buffer at or after `fromIndex`. This expands the buffer as necessary until `bytes` is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested bytes are found.<br>[common]<br>expect open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the index of `b` if it is found in the range of `fromIndex` inclusive to `toIndex` exclusive. If `b` isn't found, or if `fromIndex == toIndex`, then -1 is returned.<br>[common]<br>expect open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the index of the first match for `bytes` in the buffer that is at or after `fromIndex`, and that is also less than `toIndex`. Returns -1 if `bytes` isn't found in that range. If `fromIndex == toIndex` then search range is empty and -1 is returned. |
| [indexOfElement](index-of-element.md) | [common]<br>expect open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Equivalent to [indexOfElement(targetBytes, 0)](index-of-element.md).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[common]<br>expect open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the first index in this buffer that is at or after `fromIndex` and that contains any of the bytes in `targetBytes`. This expands the buffer as necessary until a target byte is found. This reads an unbounded number of bytes into the buffer. Returns -1 if the stream is exhausted before the requested byte is found. |
| [inflate](../inflate.md) | [zlib]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F-1717108311).[inflate](../inflate.md)(inflater: [Inflater](../-inflater/index.md) = Inflater()): [InflaterSource](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F-1717108311) while reading. |
| [inputStream](input-stream.md) | [jvm]<br>open override fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)<br>Returns an input stream that reads from this source. |
| [isOpen](is-open.md) | [jvm]<br>open override fun [isOpen](is-open.md)(): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [md5](md5.md) | [common, nonJvm]<br>[common]<br>expect fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>actual fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>actual fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 128-bit MD5 hash of this buffer. |
| [outputStream](output-stream.md) | [jvm]<br>open override fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)<br>Returns an output stream that writes to this sink. |
| [peek](peek.md) | [common]<br>expect open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new `BufferedSource` that can read data from this `BufferedSource` without consuming it. The returned source becomes invalid once this source is next read or closed.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md) |
| [rangeEquals](range-equals.md) | [common]<br>expect open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>Returns true if the bytes at `offset` in this source equal `bytes`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>[jvm, nonJvm]<br>actual open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>[common]<br>expect open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>Returns true if `byteCount` bytes at `offset` in this source equal `bytes` at `bytesOffset`. This expands the buffer as necessary until a byte does not match, all bytes are matched, or if the stream is exhausted before enough bytes could determine a match. |
| [read](read.md) | [jvm, nonJvm]<br>[jvm]<br>open override fun [read](read.md)(sink: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>actual open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>actual open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[common]<br>expect open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Removes up to `sink.length` bytes from this and copies them into `sink`. Returns the number of bytes read, or -1 if this source is exhausted.<br>[common, jvm, nonJvm]<br>[common]<br>expect open override fun [read](read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[jvm, nonJvm]<br>actual open override fun [read](read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted.<br>[common]<br>expect open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Removes up to `byteCount` bytes from this and copies them into `sink` at `offset`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [readAll](read-all.md) | [common]<br>expect open override fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Removes all bytes from this and appends them to `sink`. Returns the total number of bytes written to `sink` which will be 0 if this is exhausted.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [readAndWriteUnsafe](read-and-write-unsafe.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>actual fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md)): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[nonJvm]<br>actual fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md)): [Buffer.UnsafeCursor](-unsafe-cursor/index.md) |
| [readByte](read-byte.md) | [common]<br>expect open override fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html)<br>Removes a byte from this source and returns it.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte/index.html) |
| [readByteArray](read-byte-array.md) | [common]<br>expect open override fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)<br>Removes all bytes from this and returns them as a byte array.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)<br>[jvm, nonJvm]<br>actual open override fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)<br>[common]<br>expect open override fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)<br>Removes `byteCount` bytes from this and returns them as a byte array. |
| [readByteString](read-byte-string.md) | [common]<br>expect open override fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>Removes all bytes from this and returns them as a byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>actual open override fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>expect open override fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)<br>Removes `byteCount` bytes from this and returns them as a byte string. |
| [readDecimalLong](read-decimal-long.md) | [common]<br>expect open override fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-'). This will iterate until a non-digit character is found.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [readFrom](read-from.md) | [jvm]<br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [Buffer](index.md)<br>Read and exhaust bytes from `input` into this.<br>[jvm]<br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Read `byteCount` bytes from `input` into this. |
| [readFully](read-fully.md) | [common]<br>expect open override fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html))<br>Removes exactly `sink.length` bytes from this and copies them into `sink`. Throws an java.io.EOFException if the requested number of bytes cannot be read.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html))<br>[jvm, nonJvm]<br>actual open override fun [readFully](read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>[common]<br>expect open override fun [readFully](read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>Removes exactly `byteCount` bytes from this and appends them to `sink`. Throws an java.io.EOFException if the requested number of bytes cannot be read. |
| [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md) | [common]<br>expect open override fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16). This will iterate until a non-hexadecimal character is found.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [readInt](read-int.md) | [common]<br>expect open override fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a big-endian int.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html) |
| [readIntLe](read-int-le.md) | [common]<br>expect open override fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Removes four bytes from this source and returns a little-endian int.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html) |
| [readLong](read-long.md) | [common]<br>expect open override fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a big-endian long.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [readLongLe](read-long-le.md) | [common]<br>expect open override fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Removes eight bytes from this source and returns a little-endian long.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [readShort](read-short.md) | [common]<br>expect open override fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a big-endian short.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-short/index.html) |
| [readShortLe](read-short-le.md) | [common]<br>expect open override fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-short/index.html)<br>Removes two bytes from this source and returns a little-endian short.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-short/index.html) |
| [readString](read-string.md) | [jvm]<br>open override fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as `charset`, and returns the string.<br>[jvm]<br>open override fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as `charset`, and returns the string. |
| [readUnsafe](read-unsafe.md) | [common, jvm, nonJvm]<br>[common]<br>expect fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = DEFAULT__new_UnsafeCursor): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>actual fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md)): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)<br>[nonJvm]<br>actual fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md)): [Buffer.UnsafeCursor](-unsafe-cursor/index.md) |
| [readUtf8](read-utf8.md) | [common]<br>expect open override fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Removes all bytes from this, decodes them as UTF-8, and returns the string. Returns the empty string if this source is empty.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>actual open override fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[common]<br>expect open override fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Removes `byteCount` bytes from this, decodes them as UTF-8, and returns the string. |
| [readUtf8CodePoint](read-utf8-code-point.md) | [common]<br>expect open override fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html) |
| [readUtf8Line](read-utf8-line.md) | [common]<br>expect open override fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)?<br>Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)? |
| [readUtf8LineStrict](read-utf8-line-strict.md) | [common]<br>expect open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Removes and returns characters up to but not including the next line break. A line break is either `"\n"` or `"\r\n"`; these characters are not included in the result.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[jvm, nonJvm]<br>actual open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[common]<br>expect open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Like [readUtf8LineStrict](read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match. Use this to protect against streams that may not include `"\n"` or `"\r\n"`. |
| [request](request.md) | [common]<br>expect open override fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>Returns true when the buffer contains at least `byteCount` bytes, expanding it as necessary. Returns false if the source is exhausted before the requested bytes can be read.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html) |
| [require](require.md) | [common]<br>expect open override fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>Returns when the buffer contains at least `byteCount` bytes. Throws an java.io.EOFException if the source is exhausted before the required bytes can be read.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)) |
| [select](select.md) | [common]<br>expect open override fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Finds the first byte string in `options` that is a prefix of this buffer, consumes it from this source, and returns its index. If no byte string in `options` is a prefix of this buffer this returns -1 and no bytes are consumed.<br>[jvm, nonJvm]<br>[jvm]<br>actual open override fun [select](select.md)(options: Options): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[nonJvm]<br>actual open override fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm]<br>actual open override fun &lt;[T](select.md) : [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; [select](select.md)(options: TypedOptions&lt;[T](select.md)&gt;): [T](select.md)?<br>[nonJvm]<br>actual open override fun &lt;[T](select.md) : [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; [select](select.md)(options: [TypedOptions](../-typed-options/index.md)&lt;[T](select.md)&gt;): [T](select.md)?<br>[common]<br>expect open override fun &lt;[T](select.md) : [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html)&gt; [select](select.md)(options: [TypedOptions](../-typed-options/index.md)&lt;[T](select.md)&gt;): [T](select.md)?<br>Finds the first item in [options](select.md) whose encoding is a prefix of this buffer, consumes it from this buffer, and returns it. If no item in [options](select.md) is a prefix of this source, this function returns null and no bytes are consumed. |
| [sha1](sha1.md) | [common, nonJvm]<br>[common]<br>expect fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>actual fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>actual fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 160-bit SHA-1 hash of this buffer. |
| [sha256](sha256.md) | [common, nonJvm]<br>[common]<br>expect fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>actual fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>actual fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 256-bit SHA-256 hash of this buffer. |
| [sha512](sha512.md) | [common, nonJvm]<br>[common]<br>expect fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>[nonJvm]<br>actual fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>[jvm]<br>actual fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)<br>Returns the 512-bit SHA-512 hash of this buffer. |
| [skip](skip.md) | [common]<br>expect open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>Discards `byteCount` bytes from the head of this buffer.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)) |
| [snapshot](snapshot.md) | [common]<br>expect fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)<br>Returns an immutable copy of this buffer as a byte string.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)<br>[jvm, nonJvm]<br>actual fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)<br>[common]<br>expect fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)<br>Returns an immutable copy of the first `byteCount` bytes of this buffer as a byte string. |
| [timeout](timeout.md) | [common, jvm, nonJvm]<br>[common]<br>expect open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>[jvm, nonJvm]<br>actual open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
| toString | [jvm, nonJvm]<br>[jvm]<br>open override fun [toString]([jvm]to-string.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>[nonJvm]<br>open override fun [toString]([non-jvm]to-string.md)(): [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)<br>Returns a human-readable string that describes the contents of this buffer. Typically this is a string like `[text=Hello]` or `[hex=0000ffff]`. |
| [write](write.md) | [jvm, nonJvm, common]<br>[jvm]<br>open override fun [write](write.md)(source: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>[jvm, nonJvm]<br>actual open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)<br>[common]<br>expect open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)<br>[jvm, nonJvm]<br>actual open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)<br>[jvm, nonJvm]<br>actual open override fun [write](write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>[jvm]<br>actual open override fun [write](write.md)(source: [Source](../-source/index.md#1331753033%2FMain%2F1033915053), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[nonJvm]<br>actual open override fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>[jvm, nonJvm]<br>actual open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>expect open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[jvm, nonJvm]<br>actual open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>expect open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)<br>Like OutputStream.write, this writes a complete byte array to this sink.<br>[common]<br>expect open override fun [write](write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>Removes `byteCount` bytes from `source` and appends them to this.<br>[common]<br>expect open override fun [write](write.md)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Removes `byteCount` bytes from `source` and appends them to this sink.<br>[common]<br>expect open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Like OutputStream.write, this writes `byteCount` bytes of `source`, starting at `offset`. |
| [writeAll](write-all.md) | [common]<br>expect open override fun [writeAll](write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Removes all bytes from `source` and appends them to this sink. Returns the number of bytes read which will be 0 if `source` is exhausted.<br>[jvm, nonJvm]<br>[jvm]<br>actual open override fun [writeAll](write-all.md)(source: [Source](../-source/index.md#1331753033%2FMain%2F1033915053)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>actual open override fun [writeAll](write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |
| [writeByte](write-byte.md) | [common]<br>expect open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a byte to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeDecimalLong](write-decimal-long.md) | [common]<br>expect open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md) | [common]<br>expect open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeInt](write-int.md) | [common]<br>expect open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a big-endian int to this sink using four bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeIntLe](write-int-le.md) | [common]<br>expect open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a little-endian int to this sink using four bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeLong](write-long.md) | [common]<br>expect open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a big-endian long to this sink using eight bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeLongLe](write-long-le.md) | [common]<br>expect open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md)<br>Writes a little-endian long to this sink using eight bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Buffer](index.md) |
| [writeShort](write-short.md) | [common]<br>expect open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a big-endian short to this sink using two bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeShortLe](write-short-le.md) | [common]<br>expect open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Writes a little-endian short to this sink using two bytes.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md) |
| [writeString](write-string.md) | [jvm]<br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)<br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md) |
| [writeTo](write-to.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>fun [writeTo](write-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) = size): [Buffer](index.md)<br>Write `byteCount` bytes from this to `out`. |
| [writeUtf8](write-utf8.md) | [common]<br>expect open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [Buffer](index.md)<br>Encodes `string` in UTF-8 and writes it to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html)): [Buffer](index.md)<br>[jvm, nonJvm]<br>actual open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>[common]<br>expect open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Encodes the characters at `beginIndex` up to `endIndex` from `string` in UTF-8 and writes it to this sink. |
| [writeUtf8CodePoint](write-utf8-code-point.md) | [common]<br>expect open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)<br>Encodes `codePoint` in UTF-8 and writes it to this sink.<br>[jvm, nonJvm]<br>[jvm, nonJvm]<br>actual open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md) |