//[okio](../../../index.md)/[okio](../index.md)/[HashingSink](index.md)

# HashingSink

[common]\
expect class [HashingSink](index.md) : [Sink](../-sink/index.md)

A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](hash.md) to compute the final hash value.

In this example we use `HashingSink` with a [BufferedSink](../-buffered-sink/index.md) to make writing to the sink easier.

```kotlin
HashingSink hashingSink = HashingSink.sha256(s);
BufferedSink bufferedSink = Okio.buffer(hashingSink);

... // Write to bufferedSink and either flush or close it.

ByteString hash = hashingSink.hash();
```

[jvm]\
actual class [HashingSink](index.md) : [ForwardingSink](../-forwarding-sink/index.md), [Sink](../-sink/index.md)

A sink that computes a hash of the full stream of bytes it has accepted. To use, create an instance with your preferred hash algorithm. Write all of the data to the sink and then call [hash](hash.md) to compute the final hash value.

In this example we use `HashingSink` with a [BufferedSink](../-buffered-sink/index.md) to make writing to the sink easier.

```kotlin
HashingSink hashingSink = HashingSink.sha256(s);
BufferedSink bufferedSink = Okio.buffer(hashingSink);

... // Write to bufferedSink and either flush or close it.

ByteString hash = hashingSink.hash();
```

[nonJvm]\
actual class [HashingSink](index.md) : [Sink](../-sink/index.md)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| close | [jvm, nonJvm]<br>[jvm]<br>open override fun [close](../-forwarding-sink/close.md)()<br>[nonJvm]<br>open override fun [close](close.md)()<br>[common]<br>expect abstract override fun [close](../-sink/close.md)()<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once. |
| flush | [jvm, nonJvm]<br>[jvm]<br>open override fun [flush](../-forwarding-sink/flush.md)()<br>[nonJvm]<br>open override fun [flush](flush.md)()<br>[common]<br>expect abstract fun [flush](../-sink/flush.md)()<br>Pushes all buffered bytes to their final destination. |
| timeout | [jvm, nonJvm]<br>[jvm]<br>open override fun [timeout](../-forwarding-sink/timeout.md)(): [Timeout](../-timeout/index.md)<br>[nonJvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>[common]<br>expect abstract fun [timeout](../-sink/timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this sink. |
| [toString](../-forwarding-sink/to-string.md) | [jvm]<br>open override fun [toString](../-forwarding-sink/to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| write | [jvm, nonJvm]<br>[jvm]<br>open override fun [write]([jvm]write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[nonJvm]<br>open override fun [write]([non-jvm]write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>[common]<br>expect abstract fun [write](../-sink/write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes `byteCount` bytes from `source` and appends them to this. |

## Properties

| Name | Summary |
|---|---|
| [delegate](../-forwarding-sink/delegate.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;delegate&quot;)<br>val [delegate](../-forwarding-sink/delegate.md): [Sink](../-sink/index.md)<br>[Sink](../-sink/index.md) to which this instance is delegating. |
| [hash](hash.md) | [common]<br>expect val [hash](hash.md): [ByteString](../-byte-string/index.md)<br>Returns the hash of the bytes accepted thus far and resets the internal state of this sink.<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;hash&quot;)<br>actual val [hash](hash.md): [ByteString](../-byte-string/index.md)<br>Returns the hash of the bytes accepted thus far and resets the internal state of this sink.<br>[nonJvm]<br>actual val [hash](hash.md): ByteString<br>Returns the hash of the bytes accepted thus far and resets the internal state of this sink. |
