//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[select](select.md)

# select

[common]\
expect abstract fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

Finds the first byte string in `options` that is a prefix of this buffer, consumes it from this source, and returns its index. If no byte string in `options` is a prefix of this buffer this returns -1 and no bytes are consumed.

This can be used as an alternative to [readByteString](read-byte-string.md) or even [readUtf8](read-utf8.md) if the set of expected values is known in advance.

```kotlin
Options FIELDS = Options.of(
    ByteString.encodeUtf8("depth="),
    ByteString.encodeUtf8("height="),
    ByteString.encodeUtf8("width="));

Buffer buffer = new Buffer()
    .writeUtf8("width=640\n")
    .writeUtf8("height=480\n");

assertEquals(2, buffer.select(FIELDS));
assertEquals(640, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
assertEquals(1, buffer.select(FIELDS));
assertEquals(480, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
```

[jvm, nonJvm]\
[jvm]\
actual abstract fun [select](select.md)(options: Options): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

[nonJvm]\
actual abstract fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

[jvm]\
actual abstract fun &lt;[T](select.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [select](select.md)(options: TypedOptions&lt;[T](select.md)&gt;): [T](select.md)?

[nonJvm]\
actual abstract fun &lt;[T](select.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [select](select.md)(options: [TypedOptions](../-typed-options/index.md)&lt;[T](select.md)&gt;): [T](select.md)?

[common]\
expect abstract fun &lt;[T](select.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; [select](select.md)(options: [TypedOptions](../-typed-options/index.md)&lt;[T](select.md)&gt;): [T](select.md)?

Finds the first item in [options](select.md) whose encoding is a prefix of this buffer, consumes it from this buffer, and returns it. If no item in [options](select.md) is a prefix of this source, this function returns null and no bytes are consumed.

This can be used as an alternative to [readByteString](read-byte-string.md) or even [readUtf8](read-utf8.md) if the set of expected values is known in advance.

```kotlin
TypedOptions<Direction> options = TypedOptions.of(
    Arrays.asList(Direction.values()),
    (direction) -> ByteString.encodeUtf8(direction.name().toLowerCase(Locale.ROOT))
);

Buffer buffer = new Buffer()
    .writeUtf8("north:100\n")
    .writeUtf8("east:50\n");

assertEquals(Direction.NORTH, buffer.select(options));
assertEquals(':', buffer.readByte());
assertEquals(100L, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());

assertEquals(Direction.EAST, buffer.select(options));
assertEquals(':', buffer.readByte());
assertEquals(50L, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
```
