//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)/[writeLongLe](write-long-le.md)

# writeLongLe

[common]\
expect open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)

Writes a little-endian long to this sink using eight bytes.

```java
Buffer buffer = new Buffer();
buffer.writeLongLe(9223372036854775807L);
buffer.writeLongLe(15);

assertEquals(16, buffer.size());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)
