//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)/[writeShort](write-short.md)

# writeShort

[common]\
expect open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)

Writes a big-endian short to this sink using two bytes.

```java
Buffer buffer = new Buffer();
buffer.writeShort(32767);
buffer.writeShort(15);

assertEquals(4, buffer.size());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)
