//[okio](../../../index.md)/[okio](../index.md)/[DeflaterSink](index.md)

# DeflaterSink

[zlib]\
expect class [DeflaterSink](index.md) : [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311)

A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.

### Sync flush

Aggressive flushing of this stream may result in reduced compression. Each call to flush immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.

This is equivalent to using [Deflater](../-deflater/index.md) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call flush when application behavior requires it.

## Constructors

| | |
|---|---|
| [DeflaterSink](-deflater-sink.md) | [zlib]<br>expect constructor(sink: [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311), deflater: [Deflater](../-deflater/index.md)) |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Sink](../-sink/index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [close](index.md#-928392172%2FFunctions%2F-1717108311) | [zlib]<br>expect abstract override fun [close](index.md#-928392172%2FFunctions%2F-1717108311)()<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once. |
| [deflate](../deflate.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[deflate](../deflate.md)(deflater: [Deflater](../-deflater/index.md) = Deflater()): [DeflaterSink](index.md)<br>Returns an [DeflaterSink](index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [flush](index.md#1965163656%2FFunctions%2F-1717108311) | [zlib]<br>expect abstract fun [flush](index.md#1965163656%2FFunctions%2F-1717108311)()<br>Pushes all buffered bytes to their final destination. |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSink](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this. |
| [timeout](index.md#1450167563%2FFunctions%2F-1717108311) | [zlib]<br>expect abstract fun [timeout](index.md#1450167563%2FFunctions%2F-1717108311)(): Timeout<br>Returns the timeout for this sink. |
| [write](index.md#143355683%2FFunctions%2F-1717108311) | [zlib]<br>expect abstract fun [write](index.md#143355683%2FFunctions%2F-1717108311)(source: [Buffer](../-buffer/index.md#-987215932%2FMain%2F-1717108311), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes `byteCount` bytes from `source` and appends them to this. |
