//[okio](../index.md)/[crypto](index.md)



# Package crypto  


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="crypto/BasePrivateKeyEncodingOptions///PointingToDeclaration/"></a>[BasePrivateKeyEncodingOptions](-base-private-key-encoding-options/index.md)| <a name="crypto/BasePrivateKeyEncodingOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [BasePrivateKeyEncodingOptions](-base-private-key-encoding-options/index.md)<[T](-base-private-key-encoding-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/Certificate///PointingToDeclaration/"></a>[Certificate](-certificate/index.md)| <a name="crypto/Certificate///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [Certificate](-certificate/index.md)  <br><br><br>
| <a name="crypto/Cipher///PointingToDeclaration/"></a>[Cipher](-cipher/index.md)| <a name="crypto/Cipher///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [Cipher](-cipher/index.md) : [internal.Transform](../stream/internal/-transform/index.md)  <br><br><br>
| <a name="crypto/CipherCCM///PointingToDeclaration/"></a>[CipherCCM](-cipher-c-c-m/index.md)| <a name="crypto/CipherCCM///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [CipherCCM](-cipher-c-c-m/index.md) : [Cipher](-cipher/index.md)  <br><br><br>
| <a name="crypto/CipherCCMOptions///PointingToDeclaration/"></a>[CipherCCMOptions](-cipher-c-c-m-options/index.md)| <a name="crypto/CipherCCMOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [CipherCCMOptions](-cipher-c-c-m-options/index.md) : [internal.TransformOptions](../stream/internal/-transform-options/index.md)  <br><br><br>
| <a name="crypto/CipherGCM///PointingToDeclaration/"></a>[CipherGCM](-cipher-g-c-m/index.md)| <a name="crypto/CipherGCM///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [CipherGCM](-cipher-g-c-m/index.md) : [Cipher](-cipher/index.md)  <br><br><br>
| <a name="crypto/CipherGCMOptions///PointingToDeclaration/"></a>[CipherGCMOptions](-cipher-g-c-m-options/index.md)| <a name="crypto/CipherGCMOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [CipherGCMOptions](-cipher-g-c-m-options/index.md) : [internal.TransformOptions](../stream/internal/-transform-options/index.md)  <br><br><br>
| <a name="crypto/Decipher///PointingToDeclaration/"></a>[Decipher](-decipher/index.md)| <a name="crypto/Decipher///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [Decipher](-decipher/index.md) : [internal.Transform](../stream/internal/-transform/index.md)  <br><br><br>
| <a name="crypto/DecipherCCM///PointingToDeclaration/"></a>[DecipherCCM](-decipher-c-c-m/index.md)| <a name="crypto/DecipherCCM///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [DecipherCCM](-decipher-c-c-m/index.md) : [Decipher](-decipher/index.md)  <br><br><br>
| <a name="crypto/DecipherGCM///PointingToDeclaration/"></a>[DecipherGCM](-decipher-g-c-m/index.md)| <a name="crypto/DecipherGCM///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [DecipherGCM](-decipher-g-c-m/index.md) : [Decipher](-decipher/index.md)  <br><br><br>
| <a name="crypto/DiffieHellman///PointingToDeclaration/"></a>[DiffieHellman](-diffie-hellman/index.md)| <a name="crypto/DiffieHellman///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [DiffieHellman](-diffie-hellman/index.md)  <br><br><br>
| <a name="crypto/DSAKeyPairKeyObjectOptions///PointingToDeclaration/"></a>[DSAKeyPairKeyObjectOptions](-d-s-a-key-pair-key-object-options/index.md)| <a name="crypto/DSAKeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [DSAKeyPairKeyObjectOptions](-d-s-a-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/DSAKeyPairOptions///PointingToDeclaration/"></a>[DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)| <a name="crypto/DSAKeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)<[PubF](-d-s-a-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-d-s-a-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/ECDH///PointingToDeclaration/"></a>[ECDH](-e-c-d-h/index.md)| <a name="crypto/ECDH///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [ECDH](-e-c-d-h/index.md)  <br><br><br>
| <a name="crypto/ECKeyPairKeyObjectOptions///PointingToDeclaration/"></a>[ECKeyPairKeyObjectOptions](-e-c-key-pair-key-object-options/index.md)| <a name="crypto/ECKeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ECKeyPairKeyObjectOptions](-e-c-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/ECKeyPairOptions///PointingToDeclaration/"></a>[ECKeyPairOptions](-e-c-key-pair-options/index.md)| <a name="crypto/ECKeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ECKeyPairOptions](-e-c-key-pair-options/index.md)<[PubF](-e-c-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-e-c-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/ED25519KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[ED25519KeyPairKeyObjectOptions](-e-d25519-key-pair-key-object-options/index.md)| <a name="crypto/ED25519KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ED25519KeyPairKeyObjectOptions](-e-d25519-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/ED25519KeyPairOptions///PointingToDeclaration/"></a>[ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)| <a name="crypto/ED25519KeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)<[PubF](-e-d25519-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-e-d25519-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/ED448KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[ED448KeyPairKeyObjectOptions](-e-d448-key-pair-key-object-options/index.md)| <a name="crypto/ED448KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ED448KeyPairKeyObjectOptions](-e-d448-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/ED448KeyPairOptions///PointingToDeclaration/"></a>[ED448KeyPairOptions](-e-d448-key-pair-options/index.md)| <a name="crypto/ED448KeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ED448KeyPairOptions](-e-d448-key-pair-options/index.md)<[PubF](-e-d448-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-e-d448-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/Hash///PointingToDeclaration/"></a>[Hash](-hash/index.md)| <a name="crypto/Hash///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [Hash](-hash/index.md) : [internal.Transform](../stream/internal/-transform/index.md)  <br><br><br>
| <a name="crypto/HashOptions///PointingToDeclaration/"></a>[HashOptions](-hash-options/index.md)| <a name="crypto/HashOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [HashOptions](-hash-options/index.md) : [internal.TransformOptions](../stream/internal/-transform-options/index.md)  <br><br><br>
| <a name="crypto/Hmac///PointingToDeclaration/"></a>[Hmac](-hmac/index.md)| <a name="crypto/Hmac///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [Hmac](-hmac/index.md) : [internal.Transform](../stream/internal/-transform/index.md)  <br><br><br>
| <a name="crypto/KeyExportOptions///PointingToDeclaration/"></a>[KeyExportOptions](-key-export-options/index.md)| <a name="crypto/KeyExportOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [KeyExportOptions](-key-export-options/index.md)<[T](-key-export-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/KeyObject///PointingToDeclaration/"></a>[KeyObject](-key-object/index.md)| <a name="crypto/KeyObject///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [KeyObject](-key-object/index.md)  <br><br><br>
| <a name="crypto/KeyPairKeyObjectResult///PointingToDeclaration/"></a>[KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)| <a name="crypto/KeyPairKeyObjectResult///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br><br><br>
| <a name="crypto/KeyPairSyncResult///PointingToDeclaration/"></a>[KeyPairSyncResult](-key-pair-sync-result/index.md)| <a name="crypto/KeyPairSyncResult///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [KeyPairSyncResult](-key-pair-sync-result/index.md)<[T1](-key-pair-sync-result/index.md), [T2](-key-pair-sync-result/index.md)>  <br><br><br>
| <a name="crypto/PrivateKeyInput///PointingToDeclaration/"></a>[PrivateKeyInput](-private-key-input/index.md)| <a name="crypto/PrivateKeyInput///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [PrivateKeyInput](-private-key-input/index.md)  <br><br><br>
| <a name="crypto/PublicKeyInput///PointingToDeclaration/"></a>[PublicKeyInput](-public-key-input/index.md)| <a name="crypto/PublicKeyInput///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [PublicKeyInput](-public-key-input/index.md)  <br><br><br>
| <a name="crypto/RSAKeyPairKeyObjectOptions///PointingToDeclaration/"></a>[RSAKeyPairKeyObjectOptions](-r-s-a-key-pair-key-object-options/index.md)| <a name="crypto/RSAKeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [RSAKeyPairKeyObjectOptions](-r-s-a-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/RSAKeyPairOptions///PointingToDeclaration/"></a>[RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)| <a name="crypto/RSAKeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)<[PubF](-r-s-a-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-r-s-a-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/RsaPrivateKey///PointingToDeclaration/"></a>[RsaPrivateKey](-rsa-private-key/index.md)| <a name="crypto/RsaPrivateKey///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [RsaPrivateKey](-rsa-private-key/index.md)  <br><br><br>
| <a name="crypto/RsaPublicKey///PointingToDeclaration/"></a>[RsaPublicKey](-rsa-public-key/index.md)| <a name="crypto/RsaPublicKey///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [RsaPublicKey](-rsa-public-key/index.md)  <br><br><br>
| <a name="crypto/ScryptOptions///PointingToDeclaration/"></a>[ScryptOptions](-scrypt-options/index.md)| <a name="crypto/ScryptOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [ScryptOptions](-scrypt-options/index.md)  <br><br><br>
| <a name="crypto/Signer///PointingToDeclaration/"></a>[Signer](-signer/index.md)| <a name="crypto/Signer///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [Signer](-signer/index.md) : [internal.Writable](../stream/internal/-writable/index.md)  <br><br><br>
| <a name="crypto/SigningOptions///PointingToDeclaration/"></a>[SigningOptions](-signing-options/index.md)| <a name="crypto/SigningOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [SigningOptions](-signing-options/index.md)  <br><br><br>
| <a name="crypto/SignKeyObjectInput///PointingToDeclaration/"></a>[SignKeyObjectInput](-sign-key-object-input/index.md)| <a name="crypto/SignKeyObjectInput///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [SignKeyObjectInput](-sign-key-object-input/index.md) : [SigningOptions](-signing-options/index.md)  <br><br><br>
| <a name="crypto/SignPrivateKeyInput///PointingToDeclaration/"></a>[SignPrivateKeyInput](-sign-private-key-input/index.md)| <a name="crypto/SignPrivateKeyInput///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [SignPrivateKeyInput](-sign-private-key-input/index.md) : [PrivateKeyInput](-private-key-input/index.md), [SigningOptions](-signing-options/index.md)  <br><br><br>
| <a name="crypto/T$47///PointingToDeclaration/"></a>[T$47](-t$47/index.md)| <a name="crypto/T$47///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$47](-t$47/index.md)  <br><br><br>
| <a name="crypto/T$48///PointingToDeclaration/"></a>[T$48](-t$48/index.md)| <a name="crypto/T$48///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$48](-t$48/index.md)<[PubF](-t$48/index.md)>  <br><br><br>
| <a name="crypto/T$49///PointingToDeclaration/"></a>[T$49](-t$49/index.md)| <a name="crypto/T$49///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$49](-t$49/index.md)  <br><br><br>
| <a name="crypto/T$50///PointingToDeclaration/"></a>[T$50](-t$50/index.md)| <a name="crypto/T$50///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$50](-t$50/index.md)<[PubF](-t$50/index.md)>  <br><br><br>
| <a name="crypto/T$51///PointingToDeclaration/"></a>[T$51](-t$51/index.md)| <a name="crypto/T$51///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$51](-t$51/index.md)  <br><br><br>
| <a name="crypto/T$52///PointingToDeclaration/"></a>[T$52](-t$52/index.md)| <a name="crypto/T$52///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$52](-t$52/index.md)  <br><br><br>
| <a name="crypto/T$57///PointingToDeclaration/"></a>[T$57](-t$57/index.md)| <a name="crypto/T$57///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [T$57](-t$57/index.md)  <br><br><br>
| <a name="crypto/Verify///PointingToDeclaration/"></a>[Verify](-verify/index.md)| <a name="crypto/Verify///PointingToDeclaration/"></a>[js]  <br>Content  <br>open external class [Verify](-verify/index.md) : [internal.Writable](../stream/internal/-writable/index.md)  <br><br><br>
| <a name="crypto/VerifyKeyObjectInput///PointingToDeclaration/"></a>[VerifyKeyObjectInput](-verify-key-object-input/index.md)| <a name="crypto/VerifyKeyObjectInput///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [VerifyKeyObjectInput](-verify-key-object-input/index.md) : [SigningOptions](-signing-options/index.md)  <br><br><br>
| <a name="crypto/VerifyPublicKeyInput///PointingToDeclaration/"></a>[VerifyPublicKeyInput](-verify-public-key-input/index.md)| <a name="crypto/VerifyPublicKeyInput///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [VerifyPublicKeyInput](-verify-public-key-input/index.md) : [PublicKeyInput](-public-key-input/index.md), [SigningOptions](-signing-options/index.md)  <br><br><br>
| <a name="crypto/X25519KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[X25519KeyPairKeyObjectOptions](-x25519-key-pair-key-object-options/index.md)| <a name="crypto/X25519KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [X25519KeyPairKeyObjectOptions](-x25519-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/X25519KeyPairOptions///PointingToDeclaration/"></a>[X25519KeyPairOptions](-x25519-key-pair-options/index.md)| <a name="crypto/X25519KeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [X25519KeyPairOptions](-x25519-key-pair-options/index.md)<[PubF](-x25519-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-x25519-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto/X448KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[X448KeyPairKeyObjectOptions](-x448-key-pair-key-object-options/index.md)| <a name="crypto/X448KeyPairKeyObjectOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [X448KeyPairKeyObjectOptions](-x448-key-pair-key-object-options/index.md)  <br><br><br>
| <a name="crypto/X448KeyPairOptions///PointingToDeclaration/"></a>[X448KeyPairOptions](-x448-key-pair-options/index.md)| <a name="crypto/X448KeyPairOptions///PointingToDeclaration/"></a>[js]  <br>Content  <br>external interface [X448KeyPairOptions](-x448-key-pair-options/index.md)<[PubF](-x448-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [PrivF](-x448-key-pair-options/index.md) : [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="crypto//createCipher/#kotlin.String#BigInt64Array/PointingToDeclaration/"></a>[createCipher](create-cipher.md)| <a name="crypto//createCipher/#kotlin.String#BigInt64Array/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html)): dynamic  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipher](create-cipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br><br><br>
| <a name="crypto//createCipheriv/#kotlin.String#BigInt64Array#kotlin.Any?/PointingToDeclaration/"></a>[createCipheriv](create-cipheriv.md)| <a name="crypto//createCipheriv/#kotlin.String#BigInt64Array#kotlin.Any?/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [CipherCCM](-cipher-c-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [CipherGCM](-cipher-g-c-m/index.md)  <br>external fun [createCipheriv](create-cipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Cipher](-cipher/index.md)  <br><br><br>
| <a name="crypto//createDecipher/#kotlin.String#BigInt64Array/PointingToDeclaration/"></a>[createDecipher](create-decipher.md)| <a name="crypto//createDecipher/#kotlin.String#BigInt64Array/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html)): dynamic  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipher](create-decipher.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br><br><br>
| <a name="crypto//createDecipheriv/#kotlin.String#BigInt64Array#kotlin.Any?/PointingToDeclaration/"></a>[createDecipheriv](create-decipheriv.md)| <a name="crypto//createDecipheriv/#kotlin.String#BigInt64Array#kotlin.Any?/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): dynamic  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherCCMOptions](-cipher-c-c-m-options/index.md)): [DecipherCCM](-decipher-c-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [CipherGCMOptions](-cipher-g-c-m-options/index.md) = definedExternally): [DecipherGCM](-decipher-g-c-m/index.md)  <br>external fun [createDecipheriv](create-decipheriv.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), iv: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?, options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Decipher](-decipher/index.md)  <br><br><br>
| <a name="crypto//createDiffieHellman/#BigInt64Array/PointingToDeclaration/"></a>[createDiffieHellman](create-diffie-hellman.md)| <a name="crypto//createDiffieHellman/#BigInt64Array/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [BigInt64Array](../[root]/-big-int64-array/index.md)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [BigUint64Array](../[root]/-big-uint64-array/index.md)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [BigInt64Array](../[root]/-big-int64-array/index.md) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [BigUint64Array](../[root]/-big-uint64-array/index.md) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime_length: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), generator: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html) = definedExternally): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [BigInt64Array](../[root]/-big-int64-array/index.md)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [BigUint64Array](../[root]/-big-uint64-array/index.md)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br>external fun [createDiffieHellman](create-diffie-hellman.md)(prime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), prime_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), generator_encoding: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br><br><br>
| <a name="crypto//createECDH/#kotlin.String/PointingToDeclaration/"></a>[createECDH](create-e-c-d-h.md)| <a name="crypto//createECDH/#kotlin.String/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createECDH](create-e-c-d-h.md)(curve_name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [ECDH](-e-c-d-h/index.md)  <br><br><br>
| <a name="crypto//createHash/#kotlin.String#crypto.HashOptions/PointingToDeclaration/"></a>[createHash](create-hash.md)| <a name="crypto//createHash/#kotlin.String#crypto.HashOptions/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createHash](create-hash.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [HashOptions](-hash-options/index.md) = definedExternally): [Hash](-hash/index.md)  <br><br><br>
| <a name="crypto//createHmac/#kotlin.String#BigInt64Array/PointingToDeclaration/"></a>[createHmac](create-hmac.md)| <a name="crypto//createHmac/#kotlin.String#BigInt64Array/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html)): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigInt64Array](../[root]/-big-int64-array/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [BigUint64Array](../[root]/-big-uint64-array/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [KeyObject](-key-object/index.md), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br>external fun [createHmac](create-hmac.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), options: [internal.TransformOptions](../stream/internal/-transform-options/index.md) = definedExternally): [Hmac](-hmac/index.md)  <br><br><br>
| <a name="crypto//createPrivateKey/#Buffer/PointingToDeclaration/"></a>[createPrivateKey](create-private-key.md)| <a name="crypto//createPrivateKey/#Buffer/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createPrivateKey](create-private-key.md)(key: [Buffer](../[root]/-buffer/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createPrivateKey](create-private-key.md)(key: [PrivateKeyInput](-private-key-input/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createPrivateKey](create-private-key.md)(key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [KeyObject](-key-object/index.md)  <br><br><br>
| <a name="crypto//createPublicKey/#Buffer/PointingToDeclaration/"></a>[createPublicKey](create-public-key.md)| <a name="crypto//createPublicKey/#Buffer/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createPublicKey](create-public-key.md)(key: [Buffer](../[root]/-buffer/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createPublicKey](create-public-key.md)(key: [KeyObject](-key-object/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createPublicKey](create-public-key.md)(key: [PublicKeyInput](-public-key-input/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createPublicKey](create-public-key.md)(key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [KeyObject](-key-object/index.md)  <br><br><br>
| <a name="crypto//createSecretKey/#BigInt64Array/PointingToDeclaration/"></a>[createSecretKey](create-secret-key.md)| <a name="crypto//createSecretKey/#BigInt64Array/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createSecretKey](create-secret-key.md)(key: [BigInt64Array](../[root]/-big-int64-array/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [BigUint64Array](../[root]/-big-uint64-array/index.md)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html)): [KeyObject](-key-object/index.md)  <br>external fun [createSecretKey](create-secret-key.md)(key: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html)): [KeyObject](-key-object/index.md)  <br><br><br>
| <a name="crypto//createSign/#kotlin.String#stream.internal.WritableOptions/PointingToDeclaration/"></a>[createSign](create-sign.md)| <a name="crypto//createSign/#kotlin.String#stream.internal.WritableOptions/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createSign](create-sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [internal.WritableOptions](../stream/internal/-writable-options/index.md) = definedExternally): [Signer](-signer/index.md)  <br><br><br>
| <a name="crypto//createVerify/#kotlin.String#stream.internal.WritableOptions/PointingToDeclaration/"></a>[createVerify](create-verify.md)| <a name="crypto//createVerify/#kotlin.String#stream.internal.WritableOptions/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [createVerify](create-verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [internal.WritableOptions](../stream/internal/-writable-options/index.md) = definedExternally): [Verify](-verify/index.md)  <br><br><br>
| <a name="crypto//diffieHellman/#crypto.T$57/PointingToDeclaration/"></a>[diffieHellman](diffie-hellman.md)| <a name="crypto//diffieHellman/#crypto.T$57/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [diffieHellman](diffie-hellman.md)(options: [T$57](-t$57/index.md)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//generateKeyPair/#kotlin.String#crypto.DSAKeyPairKeyObjectOptions#kotlin.Function3[kotlin.Error?,crypto.KeyObject,crypto.KeyObject,kotlin.Unit]/PointingToDeclaration/"></a>[generateKeyPair](generate-key-pair.md)| <a name="crypto//generateKeyPair/#kotlin.String#crypto.DSAKeyPairKeyObjectOptions#kotlin.Function3[kotlin.Error?,crypto.KeyObject,crypto.KeyObject,kotlin.Unit]/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairKeyObjectOptions](-d-s-a-key-pair-key-object-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairKeyObjectOptions](-e-c-key-pair-key-object-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairOptions](-e-c-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairOptions](-e-c-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairOptions](-e-c-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairOptions](-e-c-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairKeyObjectOptions](-e-d25519-key-pair-key-object-options/index.md)?, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairKeyObjectOptions](-e-d448-key-pair-key-object-options/index.md)?, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairOptions](-e-d448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairOptions](-e-d448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairOptions](-e-d448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairOptions](-e-d448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairKeyObjectOptions](-r-s-a-key-pair-key-object-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairKeyObjectOptions](-x25519-key-pair-key-object-options/index.md)?, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairOptions](-x25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairOptions](-x25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairOptions](-x25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairOptions](-x25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairKeyObjectOptions](-x448-key-pair-key-object-options/index.md)?, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [KeyObject](-key-object/index.md), privateKey: [KeyObject](-key-object/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairOptions](-x448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairOptions](-x448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [Buffer](../[root]/-buffer/index.md), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairOptions](-x448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [generateKeyPair](generate-key-pair.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairOptions](-x448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>, callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, publicKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), privateKey: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| <a name="crypto//generateKeyPairSync/#kotlin.String/PointingToDeclaration/"></a>[generateKeyPairSync](generate-key-pair-sync.md)| <a name="crypto//generateKeyPairSync/#kotlin.String/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairKeyObjectOptions](-d-s-a-key-pair-key-object-options/index.md)): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [DSAKeyPairOptions](-d-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairKeyObjectOptions](-e-c-key-pair-key-object-options/index.md)): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ECKeyPairOptions](-e-c-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairKeyObjectOptions](-e-d25519-key-pair-key-object-options/index.md) = definedExternally): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED25519KeyPairOptions](-e-d25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairKeyObjectOptions](-e-d448-key-pair-key-object-options/index.md) = definedExternally): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [ED448KeyPairOptions](-e-d448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairKeyObjectOptions](-r-s-a-key-pair-key-object-options/index.md)): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [RSAKeyPairOptions](-r-s-a-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairKeyObjectOptions](-x25519-key-pair-key-object-options/index.md) = definedExternally): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X25519KeyPairOptions](-x25519-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairKeyObjectOptions](-x448-key-pair-key-object-options/index.md) = definedExternally): [KeyPairKeyObjectResult](-key-pair-key-object-result/index.md)  <br>external fun [generateKeyPairSync](generate-key-pair-sync.md)(type: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), options: [X448KeyPairOptions](-x448-key-pair-options/index.md)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>): dynamic  <br><br><br>
| <a name="crypto//getCiphers/#/PointingToDeclaration/"></a>[getCiphers](get-ciphers.md)| <a name="crypto//getCiphers/#/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [getCiphers](get-ciphers.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto//getCurves/#/PointingToDeclaration/"></a>[getCurves](get-curves.md)| <a name="crypto//getCurves/#/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [getCurves](get-curves.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto//getDiffieHellman/#kotlin.String/PointingToDeclaration/"></a>[getDiffieHellman](get-diffie-hellman.md)| <a name="crypto//getDiffieHellman/#kotlin.String/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [getDiffieHellman](get-diffie-hellman.md)(group_name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [DiffieHellman](-diffie-hellman/index.md)  <br><br><br>
| <a name="crypto//getFips/#/PointingToDeclaration/"></a>[getFips](get-fips.md)| <a name="crypto//getFips/#/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [getFips](get-fips.md)(): [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)  <br><br><br>
| <a name="crypto//getHashes/#/PointingToDeclaration/"></a>[getHashes](get-hashes.md)| <a name="crypto//getHashes/#/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [getHashes](get-hashes.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)<[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)>  <br><br><br>
| <a name="crypto//pbkdf2/#BigInt64Array#kotlin.Any#kotlin.Number#kotlin.Number#kotlin.String#kotlin.Function2[kotlin.Error?,Buffer,kotlin.Any]/PointingToDeclaration/"></a>[pbkdf2](pbkdf2.md)| <a name="crypto//pbkdf2/#BigInt64Array#kotlin.Any#kotlin.Number#kotlin.Number#kotlin.String#kotlin.Function2[kotlin.Error?,Buffer,kotlin.Any]/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [pbkdf2](pbkdf2.md)(password: [BigInt64Array](../[root]/-big-int64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [BigUint64Array](../[root]/-big-uint64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br>external fun [pbkdf2](pbkdf2.md)(password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html))  <br><br><br>
| <a name="crypto//pbkdf2Sync/#BigInt64Array#kotlin.Any#kotlin.Number#kotlin.Number#kotlin.String/PointingToDeclaration/"></a>[pbkdf2Sync](pbkdf2-sync.md)| <a name="crypto//pbkdf2Sync/#BigInt64Array#kotlin.Any#kotlin.Number#kotlin.Number#kotlin.String/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [BigInt64Array](../[root]/-big-int64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [BigUint64Array](../[root]/-big-uint64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pbkdf2Sync](pbkdf2-sync.md)(password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), iterations: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), digest: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//privateDecrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[privateDecrypt](private-decrypt.md)| <a name="crypto//privateDecrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [privateDecrypt](private-decrypt.md)(private_key: [Buffer](../[root]/-buffer/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [privateDecrypt](private-decrypt.md)(private_key: [KeyObject](-key-object/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [privateDecrypt](private-decrypt.md)(private_key: [RsaPrivateKey](-rsa-private-key/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [privateDecrypt](private-decrypt.md)(private_key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//privateEncrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[privateEncrypt](private-encrypt.md)| <a name="crypto//privateEncrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [privateEncrypt](private-encrypt.md)(private_key: [Buffer](../[root]/-buffer/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [privateEncrypt](private-encrypt.md)(private_key: [KeyObject](-key-object/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [privateEncrypt](private-encrypt.md)(private_key: [RsaPrivateKey](-rsa-private-key/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [privateEncrypt](private-encrypt.md)(private_key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//pseudoRandomBytes/#kotlin.Number/PointingToDeclaration/"></a>[pseudoRandomBytes](pseudo-random-bytes.md)| <a name="crypto//pseudoRandomBytes/#kotlin.Number/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [pseudoRandomBytes](pseudo-random-bytes.md)(size: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [pseudoRandomBytes](pseudo-random-bytes.md)(size: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, buf: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| <a name="crypto//publicDecrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[publicDecrypt](public-decrypt.md)| <a name="crypto//publicDecrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [publicDecrypt](public-decrypt.md)(key: [Buffer](../[root]/-buffer/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicDecrypt](public-decrypt.md)(key: [KeyObject](-key-object/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicDecrypt](public-decrypt.md)(key: [RsaPrivateKey](-rsa-private-key/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicDecrypt](public-decrypt.md)(key: [RsaPublicKey](-rsa-public-key/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicDecrypt](public-decrypt.md)(key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//publicEncrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[publicEncrypt](public-encrypt.md)| <a name="crypto//publicEncrypt/#Buffer#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [publicEncrypt](public-encrypt.md)(key: [Buffer](../[root]/-buffer/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicEncrypt](public-encrypt.md)(key: [KeyObject](-key-object/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicEncrypt](public-encrypt.md)(key: [RsaPrivateKey](-rsa-private-key/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicEncrypt](public-encrypt.md)(key: [RsaPublicKey](-rsa-public-key/index.md), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [publicEncrypt](public-encrypt.md)(key: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), buffer: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//randomBytes/#kotlin.Number/PointingToDeclaration/"></a>[randomBytes](random-bytes.md)| <a name="crypto//randomBytes/#kotlin.Number/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [randomBytes](random-bytes.md)(size: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [randomBytes](random-bytes.md)(size: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, buf: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| <a name="crypto//randomFill/#TypeParam(bounds=[kotlin.Any?])#kotlin.Function2[kotlin.Error?,TypeParam(bounds=[kotlin.Any?]),kotlin.Unit]/PointingToDeclaration/"></a>[randomFill](random-fill.md)| <a name="crypto//randomFill/#TypeParam(bounds=[kotlin.Any?])#kotlin.Function2[kotlin.Error?,TypeParam(bounds=[kotlin.Any?]),kotlin.Unit]/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun <[T](random-fill.md)> [randomFill](random-fill.md)(buffer: [T](random-fill.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, [T](random-fill.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun <[T](random-fill.md)> [randomFill](random-fill.md)(buffer: [T](random-fill.md), offset: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, [T](random-fill.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun <[T](random-fill.md)> [randomFill](random-fill.md)(buffer: [T](random-fill.md), offset: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), size: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, [T](random-fill.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| <a name="crypto//randomFillSync/#TypeParam(bounds=[kotlin.Any?])#kotlin.Number#kotlin.Number/PointingToDeclaration/"></a>[randomFillSync](random-fill-sync.md)| <a name="crypto//randomFillSync/#TypeParam(bounds=[kotlin.Any?])#kotlin.Number#kotlin.Number/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun <[T](random-fill-sync.md)> [randomFillSync](random-fill-sync.md)(buffer: [T](random-fill-sync.md), offset: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html) = definedExternally, size: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html) = definedExternally): [T](random-fill-sync.md)  <br><br><br>
| <a name="crypto//randomInt/#kotlin.Number/PointingToDeclaration/"></a>[randomInt](random-int.md)| <a name="crypto//randomInt/#kotlin.Number/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [randomInt](random-int.md)(max: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)  <br>external fun [randomInt](random-int.md)(max: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, value: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [randomInt](random-int.md)(min: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), max: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)  <br>external fun [randomInt](random-int.md)(min: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), max: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, value: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| <a name="crypto//scrypt/#BigInt64Array#kotlin.Any#kotlin.Number#kotlin.Function2[kotlin.Error?,Buffer,kotlin.Unit]/PointingToDeclaration/"></a>[scrypt](scrypt.md)| <a name="crypto//scrypt/#BigInt64Array#kotlin.Any#kotlin.Number#kotlin.Function2[kotlin.Error?,Buffer,kotlin.Unit]/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [scrypt](scrypt.md)(password: [BigInt64Array](../[root]/-big-int64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [BigUint64Array](../[root]/-big-uint64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [BigInt64Array](../[root]/-big-int64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [BigUint64Array](../[root]/-big-uint64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br>external fun [scrypt](scrypt.md)(password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md), callback: (err: [Error](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-error/index.html)?, derivedKey: [Buffer](../[root]/-buffer/index.md)) -> [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))  <br><br><br>
| <a name="crypto//scryptSync/#BigInt64Array#kotlin.Any#kotlin.Number/PointingToDeclaration/"></a>[scryptSync](scrypt-sync.md)| <a name="crypto//scryptSync/#BigInt64Array#kotlin.Any#kotlin.Number/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [scryptSync](scrypt-sync.md)(password: [BigInt64Array](../[root]/-big-int64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [BigUint64Array](../[root]/-big-uint64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [BigInt64Array](../[root]/-big-int64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [BigUint64Array](../[root]/-big-uint64-array/index.md), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br>external fun [scryptSync](scrypt-sync.md)(password: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), salt: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), keylen: [Number](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-number/index.html), options: [ScryptOptions](-scrypt-options/index.md) = definedExternally): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//sign/#kotlin.String?#BigInt64Array#kotlin.Any/PointingToDeclaration/"></a>[sign](sign.md)| <a name="crypto//sign/#kotlin.String?#BigInt64Array#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [BigInt64Array](../[root]/-big-int64-array/index.md), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [BigUint64Array](../[root]/-big-uint64-array/index.md), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br>external fun [sign](sign.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Buffer](../[root]/-buffer/index.md)  <br><br><br>
| <a name="crypto//timingSafeEqual/#BigInt64Array#kotlin.Any/PointingToDeclaration/"></a>[timingSafeEqual](timing-safe-equal.md)| <a name="crypto//timingSafeEqual/#BigInt64Array#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [BigInt64Array](../[root]/-big-int64-array/index.md), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [BigUint64Array](../[root]/-big-uint64-array/index.md), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [timingSafeEqual](timing-safe-equal.md)(a: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), b: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="crypto//verify/#kotlin.String?#BigInt64Array#kotlin.Any#kotlin.Any/PointingToDeclaration/"></a>[verify](verify.md)| <a name="crypto//verify/#kotlin.String?#BigInt64Array#kotlin.Any#kotlin.Any/PointingToDeclaration/"></a>[js]  <br>Content  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [BigInt64Array](../[root]/-big-int64-array/index.md), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [BigUint64Array](../[root]/-big-uint64-array/index.md), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [DataView](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-data-view/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Float32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float32-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Float64Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-float64-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Int16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int16-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Int32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int32-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Int8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-int8-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint16Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint16-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint32Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint32-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint8Array](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>external fun [verify](verify.md)(algorithm: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, data: [Uint8ClampedArray](https://kotlinlang.org/api/latest/jvm/stdlib/org.khronos.webgl/-uint8-clamped-array/index.html), key: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html), signature: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="crypto//DEFAULT_ENCODING/#/PointingToDeclaration/"></a>[DEFAULT_ENCODING](-d-e-f-a-u-l-t_-e-n-c-o-d-i-n-g.md)| <a name="crypto//DEFAULT_ENCODING/#/PointingToDeclaration/"></a> [js] external var [DEFAULT_ENCODING](-d-e-f-a-u-l-t_-e-n-c-o-d-i-n-g.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)   <br>
| <a name="crypto//fips/#/PointingToDeclaration/"></a>[fips](fips.md)| <a name="crypto//fips/#/PointingToDeclaration/"></a> [js] external var [fips](fips.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)   <br>

