//[okio](../../../index.md)/[okio](../../index.md)/[Buffer](../index.md)/[UnsafeCursor](index.md)/[expandBuffer](expand-buffer.md)



# expandBuffer  
[common]  
Content  
fun [expandBuffer](expand-buffer.md)(minByteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  
More info  


Grow the buffer by adding a **contiguous range** of capacity in a single segment. This adds at least minByteCount bytes but may add up to a full segment of additional capacity.



As a side-effect this cursor will [seek](seek.md). It will move [offset](offset.md) to the first byte of newly-added capacity. This is the size of the buffer prior to the expandBuffer() call.



If minByteCount bytes are available in the buffer's current tail segment that will be used; otherwise another segment will be allocated and appended. In either case this returns the number of bytes of capacity added to this buffer.



Warning: it is the caller’s responsibility to either write new data to every byte of the newly-allocated capacity, or to [shrink](resize-buffer.md) the buffer to the data written. Failure to do so may cause serious security problems as the data in the returned buffers is not zero filled. Buffers may contain dirty pooled segments that hold very sensitive data from other parts of the current process.



#### Return  


the number of bytes expanded by. Not less than minByteCount.



## Parameters  
  
common  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a>minByteCount| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a><br><br>the size of the contiguous capacity. Must be positive and not greater     than the capacity size of a single segment (8 KiB).<br><br>
  
jvm  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a>minByteCount| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a><br><br>the size of the contiguous capacity. Must be positive and not greater     than the capacity size of a single segment (8 KiB).<br><br>
  
  


[jvm]  
Content  
fun [expandBuffer](expand-buffer.md)(minByteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  
More info  


## Parameters  
  
common  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a>minByteCount| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a><br><br>the size of the contiguous capacity. Must be positive and not greater     than the capacity size of a single segment (8 KiB).<br><br>
  
jvm  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a>minByteCount| <a name="okio/Buffer.UnsafeCursor/expandBuffer/#kotlin.Int/PointingToDeclaration/"></a><br><br>the size of the contiguous capacity. Must be positive and not greater     than the capacity size of a single segment (8 KiB).<br><br>
  
  



