//[okio](../../index.md)/[okio](../index.md)/[FileSystem](index.md)



# FileSystem  
 [common] abstract class [FileSystem](index.md)

Read and write access to a hierarchical collection of files, addressed by [paths](../-path/index.md). This is a natural interface to the [current computer's local file system](-companion/-s-y-s-t-e-m.md).





Not Just the Local File System

 ------------------------------



Other implementations are possible:

<ul><li>FakeFileSystem is an in-memory file system suitable for testing. Note that this class is     included in the okio-fakefilesystem artifact.</li><li>A ZIP file system could provide access to the contents of a .zip file.</li><li>A remote file system could access files over the network.</li><li>A [decorating file system](../-forwarding-file-system/index.md) could apply monitoring, encryption,     compression, or filtering to another file system implementation.</li></ul>

For improved capability and testability, consider structuring your classes to dependency inject a FileSystem rather than using [SYSTEM](-companion/-s-y-s-t-e-m.md) directly.





Limited API

 -----------



This interface is limited in which file system features it supports. Applications that need rich file system features should use another API, possibly alongside this API.



This class cannot create special file types like hard links, symlinks, pipes, or mounts. Reading or writing these files works as if they were regular files.



It cannot read or write file access control features like the UNIX chmod and Windows access control lists. It does honor these controls and will fail with an [IOException](../-i-o-exception/index.md) if privileges are insufficient!



It cannot lock files, or query which files are locked.



It cannot watch the file system for changes.





Multiplatform

 -------------



This class supports a matrix of Kotlin platforms (JVM, Kotlin/Native, Kotlin/JS) and operating systems (Linux, macOS, and Windows). It attempts to balance working similarly across platforms with being consistent with the local operating system.



This is a blocking API which limits its applicability on concurrent Node.js services. File operations will block the event loop (and all JavaScript execution!) until they complete.



It supports the path schemes of both Windows (like C:\Users) and UNIX (like /home). Note that path resolution rules differ by platform.





Differences vs. Java IO APIs

 ----------------------------



The java.io.File class is Java's original file system API. The delete and renameTo methods return false if the operation failed. The list method returns null if the file isn't a directory or could not be listed. This class always throws IOExceptions when operations don't succeed.



The java.nio.Path and java.nio.Files classes are the entry points of Java's new file system API. Each Path instance is scoped to a particular file system, though that is often implicit because the Paths.get() function automatically uses the default (ie. system) file system. In Okio's API paths are just identifiers; you must use a specific FileSystem object to do I/O with.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem/FileSystem/#/PointingToDeclaration/"></a>[FileSystem](-file-system.md)| <a name="okio/FileSystem/FileSystem/#/PointingToDeclaration/"></a> [common] fun [FileSystem](-file-system.md)()   <br>


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/FileSystem.Companion///PointingToDeclaration/"></a>[common]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio/FileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that appends bytes to the end of file, creating it if it doesn't already exist.  <br><br><br>
| <a name="okio/FileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio/FileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br>More info  <br>Moves source to target in-place if the underlying file system supports it.  <br><br><br>
| <a name="okio/FileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio/FileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)  <br>More info  <br>Resolves path against the current working directory and symlinks in this file system.  <br><br><br>
| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](copy.md)| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  <br>More info  <br>Copies all of the bytes from the file at source to the file at target.  <br><br><br>
| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](create-directories.md)| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md))  <br>More info  <br>Creates a directory at the path identified by dir, and any enclosing parent path directories, recursively.  <br><br><br>
| <a name="okio/FileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio/FileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))  <br>More info  <br>Creates a directory at the path identified by dir.  <br><br><br>
| <a name="okio/FileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio/FileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [delete](delete.md)(path: [Path](../-path/index.md))  <br>More info  <br>Deletes the file or directory at path.  <br><br><br>
| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](delete-recursively.md)| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md))  <br>More info  <br>Recursively deletes all children of fileOrDirectory if it is a directory, then deletes fileOrDirectory itself.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1399290810)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1399290810)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](exists.md)| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [exists](exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if path identifies an object on this file system.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1399290810)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1399290810)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/FileSystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio/FileSystem/list/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)>  <br>More info  <br>Returns the children of the directory identified by dir.  <br><br><br>
| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](metadata.md)| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [metadata](metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)  <br>More info  <br>Returns metadata of the file, directory, or object identified by path.  <br><br><br>
| <a name="okio/FileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio/FileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)?  <br>More info  <br>Returns metadata of the file, directory, or object identified by path.  <br><br><br>
| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[read](read.md)| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](read.md)> [read](read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -> [T](read.md)): [T](read.md)  <br>More info  <br>Creates a source to read file, executes readerAction to read it, and then closes the source.  <br><br><br>
| <a name="okio/FileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/FileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that writes bytes to file from beginning to end.  <br><br><br>
| <a name="okio/FileSystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/FileSystem/source/#okio.Path/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md)  <br>More info  <br>Returns a source that reads the bytes of file from beginning to end.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1399290810)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1399290810)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[write](write.md)| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[common]  <br>Content  <br>inline fun <[T](write.md)> [write](write.md)(file: [Path](../-path/index.md), writerAction: [BufferedSink](../-buffered-sink/index.md).() -> [T](write.md)): [T](write.md)  <br>More info  <br>Creates a sink to write file, executes writerAction to write it, and then closes the sink.  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/ForwardingFileSystem///PointingToDeclaration/"></a>[ForwardingFileSystem](../-forwarding-file-system/index.md)

