//[okio](../../index.md)/[okio](../index.md)/[HashingSource](index.md)



# HashingSource  
 [common] class [HashingSource](index.md) : [Source](../-source/index.md)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](hash.md) to compute the final hash value.



In this example we use HashingSource with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.

HashingSource hashingSource = HashingSource.sha256(rawSource);  
BufferedSource bufferedSource = Okio.buffer(hashingSource);  
  
... // Read all of bufferedSource.  
  
ByteString hash = hashingSource.hash();   
 [jvm] class [HashingSource](index.md) : [ForwardingSource](../-forwarding-source/index.md), [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F185589259)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](hash.md) to compute the final hash value.



In this example we use HashingSource with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.

HashingSource hashingSource = HashingSource.sha256(rawSource);  
BufferedSource bufferedSource = Okio.buffer(hashingSource);  
  
... // Read all of bufferedSource.  
  
ByteString hash = hashingSource.hash();   


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/HashingSource.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/HashingSource.Companion///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/ForwardingSource/close/#/PointingToDeclaration/"></a>close| <a name="okio/ForwardingSource/close/#/PointingToDeclaration/"></a>[jvm, common]  <br>Content  <br>[jvm]  <br>open override fun [close](../-forwarding-source/close.md)()  <br>[common]  <br>abstract override fun [close](../-source/close.md)()  <br>More info  <br>Closes this source and releases the resources held by this source.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1312522814)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F185589259)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1312522814)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F185589259)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/HashingSource/read/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>read| <a name="okio/HashingSource/read/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[jvm, common]  <br>Content  <br>[jvm]  <br>open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[common]  <br>abstract fun [read](../-source/read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes at least 1, and up to byteCount bytes from this and appends them to sink.  <br><br><br>
| <a name="okio/ForwardingSource/timeout/#/PointingToDeclaration/"></a>timeout| <a name="okio/ForwardingSource/timeout/#/PointingToDeclaration/"></a>[jvm, common]  <br>Content  <br>[jvm]  <br>open override fun [timeout](../-forwarding-source/timeout.md)(): [Timeout](../-timeout/index.md)  <br>[common]  <br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this source.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-1312522814)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[jvm]  <br>open override fun [toString](../-forwarding-source/to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/HashingSource/delegate/#/PointingToDeclaration/"></a>[delegate](index.md#%5Bokio%2FHashingSource%2Fdelegate%2F%23%2FPointingToDeclaration%2F%5D%2FProperties%2F185589259)| <a name="okio/HashingSource/delegate/#/PointingToDeclaration/"></a> [jvm] val [delegate](index.md#%5Bokio%2FHashingSource%2Fdelegate%2F%23%2FPointingToDeclaration%2F%5D%2FProperties%2F185589259): [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F185589259)[Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F185589259) to which this instance is delegating.   <br>
| <a name="okio/HashingSource/hash/#/PointingToDeclaration/"></a>[hash](hash.md)| <a name="okio/HashingSource/hash/#/PointingToDeclaration/"></a> [common, jvm] val [hash](hash.md): [ByteString](../-byte-string/index.md)Returns the hash of the bytes supplied thus far and resets the internal state of this source.   <br>

