//[okio](../../index.md)/[okio](../index.md)/[Throttler](index.md)



# Throttler  
 [jvm] class [Throttler](index.md)

Enables limiting of Source and Sink throughput. Attach to this throttler via [source](source.md) and [sink](sink.md) and set the desired throughput via [bytesPerSecond](bytes-per-second.md). Multiple Sources and Sinks can be attached to a single Throttler and they will be throttled as a group, where their combined throughput will not exceed the desired throughput. The same Source or Sink can be attached to multiple Throttlers and its throughput will not exceed the desired throughput of any of the Throttlers.



This class has these tuning parameters:

<ul><li>bytesPerSecond: Maximum sustained throughput. Use 0 for no limit.</li><li>waitByteCount: When the requested byte count is greater than this many bytes and isn't     immediately available, only wait until we can allocate at least this many bytes. Use this to     set the ideal byte count during sustained throughput.</li><li>maxByteCount: Maximum number of bytes to allocate on any call. This is also the number of     bytes that will be returned before any waiting.</li></ul>   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Throttler/Throttler/#/PointingToDeclaration/"></a>[Throttler](-throttler.md)| <a name="okio/Throttler/Throttler/#/PointingToDeclaration/"></a> [jvm] fun [Throttler](-throttler.md)()   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Throttler/bytesPerSecond/#kotlin.Long#kotlin.Long#kotlin.Long/PointingToDeclaration/"></a>[bytesPerSecond](bytes-per-second.md)| <a name="okio/Throttler/bytesPerSecond/#kotlin.Long#kotlin.Long#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [bytesPerSecond](bytes-per-second.md)(bytesPerSecond: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), waitByteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = this.waitByteCount, maxByteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = this.maxByteCount)  <br>More info  <br>Sets the rate at which bytes will be allocated.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-288106371)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-288106371)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-288106371)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-288106371)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Throttler/sink/#okio.Sink/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/Throttler/sink/#okio.Sink/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [sink](sink.md)(sink: [Sink](../-sink/index.md)): [Sink](../-sink/index.md)  <br>More info  <br>Create a Sink which honors this Throttler.  <br><br><br>
| <a name="okio/Throttler/source/#okio.Source/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/Throttler/source/#okio.Source/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [source](source.md)(source: [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-288106371)): [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-288106371)  <br>More info  <br>Create a Source which honors this Throttler.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-288106371)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-288106371)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>

