//[okio](../../../index.md)/[okio](../index.md)/[HashingSource](index.md)

# HashingSource

[common]\
class [HashingSource](index.md) : [Source](../-source/index.md)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](hash.md) to compute the final hash value.

In this example we use HashingSource with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.

HashingSource hashingSource = HashingSource.sha256(rawSource);\
BufferedSource bufferedSource = Okio.buffer(hashingSource);\
\
... // Read all of bufferedSource.\
\
ByteString hash = hashingSource.hash();

[jvm]\
class [HashingSource](index.md) : [ForwardingSource](../-forwarding-source/index.md), [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](hash.md) to compute the final hash value.

In this example we use HashingSource with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.

HashingSource hashingSource = HashingSource.sha256(rawSource);\
BufferedSource bufferedSource = Okio.buffer(hashingSource);\
\
... // Read all of bufferedSource.\
\
ByteString hash = hashingSource.hash();

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm]<br>[common, jvm]<br>object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| close | [jvm, common]<br>[jvm]<br>open override fun [close](../-forwarding-source/close.md)()<br>[common]<br>abstract override fun [close](../-source/close.md)()<br>Closes this source and releases the resources held by this source. |
| read | [jvm, common]<br>[jvm]<br>open override fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [read](../-source/read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to byteCount bytes from this and appends them to sink. |
| timeout | [jvm, common]<br>[jvm]<br>open override fun [timeout](../-forwarding-source/timeout.md)(): [Timeout](../-timeout/index.md)<br>[common]<br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
| [toString](../-forwarding-source/to-string.md) | [jvm]<br>open override fun [toString](../-forwarding-source/to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |

## Properties

| Name | Summary |
|---|---|
| [delegate](index.md#-1276689173%2FProperties%2F1033915053) | [jvm]<br>val [delegate](index.md#-1276689173%2FProperties%2F1033915053): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053)<br>[Source](../-source/index.md#1331753033%2FExtensions%2F1033915053) to which this instance is delegating. |
| [hash](hash.md) | [common, jvm]<br>val [hash](hash.md): [ByteString](../-byte-string/index.md)<br>Returns the hash of the bytes supplied thus far and resets the internal state of this source. |
