//[okio](../../../index.md)/[okio](../index.md)/[ZipFileSystem](index.md)

# ZipFileSystem

[jvm]\
class [ZipFileSystem](index.md) : [FileSystem](../-file-system/index.md)

Read only access to a [zip file](https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE_6.2.0.txt) and common [extra fields](https://opensource.apple.com/source/zip/zip-6/unzip/unzip/proginfo/extra.fld).

Zip Timestamps

 --------------

The base zip format tracks the [last modified timestamp](../-file-metadata/last-modified-at-millis.md). It does not track [created timestamps](../-file-metadata/created-at-millis.md) or [last accessed timestamps](../-file-metadata/last-accessed-at-millis.md). This format has limitations:

<ul><li>Timestamps are 16-bit values stored with 2-second precision. Some zip encoders (WinZip, PKZIP)     round up to the nearest 2 seconds; other encoders (Java) round down.</li><li>Timestamps before 1980-01-01 cannot be represented. They cannot represent dates after     2107-12-31.</li><li>Timestamps are stored in local time with no time zone offset. If the time zone offset changes     – due to daylight savings time or the zip file being sent to another time zone – file times     will be incorrect. The file time will be shifted by the difference in time zone offsets     between the encoder and decoder.</li></ul>

The zip format has optional extensions for timestamps.

<ul><li>UNIX timestamps (0x000d) support both last-access time and last modification time. These     timestamps are stored with 1-second precision using UTC.</li><li>NTFS timestamps (0x000a) support creation time, last access time, and last modified time.     These timestamps are stored with 100-millisecond precision using UTC.</li><li>Extended timestamps (0x5455) are stored as signed 32-bit timestamps with 1-second precision.     These cannot express dates beyond 2038-01-19.</li></ul>

This class currently supports base timestamps and extended timestamps.

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [jvm]<br>open override fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md) |
| [atomicMove](atomic-move.md) | [jvm]<br>open override fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [canonicalize](canonicalize.md) | [jvm]<br>open override fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md) |
| [copy](../-file-system/copy.md) | [jvm]<br>open fun [copy](../-file-system/copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [createDirectories](../-file-system/create-directories.md) | [jvm]<br>fun [createDirectories](../-file-system/create-directories.md)(dir: [Path](../-path/index.md)) |
| [createDirectory](create-directory.md) | [jvm]<br>open override fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md)) |
| [delete](delete.md) | [jvm]<br>open override fun [delete](delete.md)(path: [Path](../-path/index.md)) |
| [deleteRecursively](../-file-system/delete-recursively.md) | [jvm]<br>open fun [deleteRecursively](../-file-system/delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md)) |
| [exists](../-file-system/exists.md) | [jvm]<br>fun [exists](../-file-system/exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [list](list.md) | [jvm]<br>open override fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<[Path](../-path/index.md)> |
| [metadata](../-file-system/metadata.md) | [jvm]<br>fun [metadata](../-file-system/metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md) |
| [metadataOrNull](metadata-or-null.md) | [jvm]<br>open override fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)? |
| [openReadOnly](open-read-only.md) | [jvm]<br>open override fun [openReadOnly](open-read-only.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md) |
| [openReadWrite](open-read-write.md) | [jvm]<br>open override fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md) |
| [read](../-file-system/read.md) | [jvm]<br>inline fun <[T](../-file-system/read.md)> [read](../-file-system/read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -> [T](../-file-system/read.md)): [T](../-file-system/read.md) |
| [sink](sink.md) | [jvm]<br>open override fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md) |
| [source](source.md) | [jvm]<br>open override fun [source](source.md)(path: [Path](../-path/index.md)): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053) |
| [write](../-file-system/write.md) | [jvm]<br>inline fun <[T](../-file-system/write.md)> [write](../-file-system/write.md)(file: [Path](../-path/index.md), writerAction: [BufferedSink](../-buffered-sink/index.md).() -> [T](../-file-system/write.md)): [T](../-file-system/write.md) |
