//[okio](../../../index.md)/[okio](../index.md)/[Sink](index.md)

# Sink

[common]\
interface [Sink](index.md) : [Closeable](../-closeable/index.md)

Receives a stream of bytes. Use this interface to write data wherever it's needed: to the network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as to compress, encrypt, throttle, or add protocol framing.

Most application code shouldn't operate on a sink directly, but rather on a [BufferedSink](../-buffered-sink/index.md) which is both more efficient and more convenient. Use [buffer](../buffer.md) to wrap any sink with a buffer.

Sinks are easy to test: just use a [Buffer](../-buffer/index.md) in your tests, and read from it to confirm it received the data that was expected.

###  Comparison with OutputStream

This interface is functionally equivalent to java.io.OutputStream.

OutputStream requires multiple layers when emitted data is heterogeneous: a DataOutputStream for primitive values, a BufferedOutputStream for buffering, and OutputStreamWriter for charset encoding. This library uses BufferedSink for all of the above.

Sink is also easier to layer: there is no java.io.OutputStream.write method that is awkward to implement efficiently.

###  Interop with OutputStream

Use sink to adapt an OutputStream to a sink. Use BufferedSink.outputStream to adapt a sink to an OutputStream.

[jvm]\
interface [Sink](index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [common]<br>abstract override fun [close](close.md)()<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink.<br>[jvm]<br>abstract override fun [close](close.md)() |
| [flush](flush.md) | [common]<br>abstract fun [flush](flush.md)()<br>Pushes all buffered bytes to their final destination.<br>[jvm]<br>abstract override fun [flush](flush.md)() |
| [timeout](timeout.md) | [common]<br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this sink.<br>[jvm]<br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md) |
| [write](write.md) | [common]<br>abstract fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>Removes byteCount bytes from source and appends them to this.<br>[jvm]<br>abstract fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |

## Inheritors

| Name |
|---|
| [BufferedSink](../-buffered-sink/index.md) |
| [HashingSink](../-hashing-sink/index.md) |
| [CipherSink](../-cipher-sink/index.md) |
| [DeflaterSink](../-deflater-sink/index.md) |
| [ForwardingSink](../-forwarding-sink/index.md) |
| [GzipSink](../-gzip-sink/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Sink](index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to sink. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [deflate](../deflate.md) | [jvm]<br>inline fun [Sink](index.md).[deflate](../deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](index.md) while writing. |
| [gzip](../gzip.md) | [jvm]<br>inline fun [Sink](index.md).[gzip](../gzip.md)(): [GzipSink](../-gzip-sink/index.md)<br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](index.md) while writing. |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this. |
