//[okio](../../index.md)/[okio](index.md)

# Package okio

## Types

| Name | Summary |
|---|---|
| [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md) | [common, jvm]<br>[common]<br>class [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IndexOutOfBoundsException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-index-out-of-bounds-exception/index.html)<br>[jvm]<br>typealias [ArrayIndexOutOfBoundsException](-array-index-out-of-bounds-exception/index.md) = [ArrayIndexOutOfBoundsException](https://docs.oracle.com/javase/8/docs/api/java/lang/ArrayIndexOutOfBoundsException.html) |
| [AsyncTimeout](-async-timeout/index.md) | [jvm]<br>open class [AsyncTimeout](-async-timeout/index.md) : [Timeout](-timeout/index.md)<br>This timeout uses a background thread to take action exactly when the timeout occurs. |
| [Buffer](-buffer/index.md) | [common]<br>class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md)<br>A collection of bytes in memory.<br>[jvm]<br>class [Buffer](-buffer/index.md) : [BufferedSource](-buffered-source/index.md), [BufferedSink](-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html) |
| [BufferedSink](-buffered-sink/index.md) | [common]<br>interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md)<br>A sink that keeps a buffer internally so that callers can do small writes without a performance penalty.<br>[jvm]<br>interface [BufferedSink](-buffered-sink/index.md) : [Sink](-sink/index.md), [WritableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/WritableByteChannel.html) |
| [BufferedSource](-buffered-source/index.md) | [common]<br>interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md)<br>A source that keeps a buffer internally so that callers can do small reads without a performance penalty.<br>[jvm]<br>interface [BufferedSource](-buffered-source/index.md) : [Source](-source/index.md#1331753033%2FExtensions%2F1033915053), [ReadableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ReadableByteChannel.html) |
| [ByteString](-byte-string/index.md) | [common]<br>open class [ByteString](-byte-string/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[ByteString](-byte-string/index.md)> <br>An immutable sequence of bytes.<br>[jvm]<br>open class [ByteString](-byte-string/index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html), [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[ByteString](-byte-string/index.md)> |
| [CipherSink](-cipher-sink/index.md) | [jvm]<br>class [CipherSink](-cipher-sink/index.md)(**sink**: [BufferedSink](-buffered-sink/index.md), **cipher**: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Sink](-sink/index.md) |
| [CipherSource](-cipher-source/index.md) | [jvm]<br>class [CipherSource](-cipher-source/index.md)(**source**: [BufferedSource](-buffered-source/index.md), **cipher**: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)) : [Source](-source/index.md#1331753033%2FExtensions%2F1033915053) |
| [Closeable](-closeable/index.md) | [common, jvm]<br>[common]<br>interface [Closeable](-closeable/index.md)<br>[jvm]<br>typealias [Closeable](-closeable/index.md) = [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html) |
| [DeflaterSink](-deflater-sink/index.md) | [jvm]<br>class [DeflaterSink](-deflater-sink/index.md) : [Sink](-sink/index.md)<br>A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source. |
| [EOFException](-e-o-f-exception/index.md) | [common, jvm]<br>[common]<br>open class [EOFException](-e-o-f-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)<br>[jvm]<br>typealias [EOFException](-e-o-f-exception/index.md) = [EOFException](https://docs.oracle.com/javase/8/docs/api/java/io/EOFException.html) |
| [ExperimentalFileSystem](-experimental-file-system/index.md) | [common]<br>@[Target](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-target/index.html)(allowedTargets = [[AnnotationTarget.CLASS](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-c-l-a-s-s/index.html), [AnnotationTarget.FUNCTION](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-f-u-n-c-t-i-o-n/index.html), [AnnotationTarget.PROPERTY](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.annotation/-annotation-target/-p-r-o-p-e-r-t-y/index.html)])<br>annotation class [ExperimentalFileSystem](-experimental-file-system/index.md) |
| [FileHandle](-file-handle/index.md) | [common]<br>abstract class [FileHandle](-file-handle/index.md)(**readWrite**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) : [Closeable](-closeable/index.md)<br>An open file for reading and writing; using either streaming and random access. |
| [FileMetadata](-file-metadata/index.md) | [common]<br>class [FileMetadata](-file-metadata/index.md)(**isRegularFile**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **isDirectory**: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), **symlinkTarget**: [Path](-path/index.md)?, **size**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **createdAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **lastModifiedAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **lastAccessedAtMillis**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)?, **extras**: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)<[KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)<*>, [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)>)<br>Description of a file or another object referenced by a path. |
| [FileNotFoundException](-file-not-found-exception/index.md) | [common, jvm]<br>[common]<br>class [FileNotFoundException](-file-not-found-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [IOException](-i-o-exception/index.md)<br>[jvm]<br>typealias [FileNotFoundException](-file-not-found-exception/index.md) = [FileNotFoundException](https://docs.oracle.com/javase/8/docs/api/java/io/FileNotFoundException.html) |
| [FileSystem](-file-system/index.md) | [common]<br>abstract class [FileSystem](-file-system/index.md)<br>Read and write access to a hierarchical collection of files, addressed by [paths](-path/index.md).<br>[js, jvm]<br>[js, jvm]<br>abstract class [FileSystem](-file-system/index.md) |
| [ForwardingFileSystem](-forwarding-file-system/index.md) | [common]<br>abstract class [ForwardingFileSystem](-forwarding-file-system/index.md)(**delegate**: [FileSystem](-file-system/index.md)) : [FileSystem](-file-system/index.md)<br>A [FileSystem](-file-system/index.md) that forwards calls to another, intended for subclassing. |
| [ForwardingSink](-forwarding-sink/index.md) | [jvm]<br>abstract class [ForwardingSink](-forwarding-sink/index.md)(**delegate**: [Sink](-sink/index.md)) : [Sink](-sink/index.md)<br>A [Sink](-sink/index.md) which forwards calls to another. |
| [ForwardingSource](-forwarding-source/index.md) | [jvm]<br>abstract class [ForwardingSource](-forwarding-source/index.md)(**delegate**: [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)) : [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>A [Source](-source/index.md#1331753033%2FExtensions%2F1033915053) which forwards calls to another. |
| [ForwardingTimeout](-forwarding-timeout/index.md) | [jvm]<br>open class [ForwardingTimeout](-forwarding-timeout/index.md)(**delegate**: [Timeout](-timeout/index.md)) : [Timeout](-timeout/index.md)<br>A [Timeout](-timeout/index.md) which forwards calls to another. |
| [GzipSink](-gzip-sink/index.md) | [jvm]<br>class [GzipSink](-gzip-sink/index.md)(**sink**: [Sink](-sink/index.md)) : [Sink](-sink/index.md)<br>A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink. |
| [GzipSource](-gzip-source/index.md) | [jvm]<br>class [GzipSource](-gzip-source/index.md)(**source**: [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)) : [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>A source that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to decompress data read from another source. |
| [HashingSink](-hashing-sink/index.md) | [common, jvm]<br>[common]<br>class [HashingSink](-hashing-sink/index.md) : [Sink](-sink/index.md)<br>[jvm]<br>class [HashingSink](-hashing-sink/index.md) : [ForwardingSink](-forwarding-sink/index.md), [Sink](-sink/index.md)<br>A sink that computes a hash of the full stream of bytes it has accepted. |
| [HashingSource](-hashing-source/index.md) | [common, jvm]<br>[common]<br>class [HashingSource](-hashing-source/index.md) : [Source](-source/index.md)<br>[jvm]<br>class [HashingSource](-hashing-source/index.md) : [ForwardingSource](-forwarding-source/index.md), [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>A source that computes a hash of the full stream of bytes it has supplied. |
| [InflaterSource](-inflater-source/index.md) | [jvm]<br>class [InflaterSource](-inflater-source/index.md) : [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>A source that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to decompress data read from another source. |
| [IOException](-i-o-exception/index.md) | [common, jvm]<br>[common]<br>open class [IOException](-i-o-exception/index.md)(**message**: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, **cause**: [Throwable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-throwable/index.html)?) : [Exception](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-exception/index.html)<br>[jvm]<br>typealias [IOException](-i-o-exception/index.md) = [IOException](https://docs.oracle.com/javase/8/docs/api/java/io/IOException.html) |
| [Options](-options/index.md) | [common]<br>class [Options](-options/index.md) : [AbstractList](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-abstract-list/index.html)<[ByteString](-byte-string/index.md)> , [RandomAccess](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-random-access/index.html)<br>An indexed set of values that may be read with [BufferedSource.select](-buffered-source/select.md). |
| [Path](-path/index.md) | [common]<br>class [Path](-path/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[Path](-path/index.md)> <br>A hierarchical address on a file system.<br>[jvm]<br>class [Path](-path/index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[Path](-path/index.md)> |
| [Pipe](-pipe/index.md) | [jvm]<br>class [Pipe](-pipe/index.md)(**maxBufferSize**: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))<br>A source and a sink that are attached. |
| [Sink](-sink/index.md) | [common]<br>interface [Sink](-sink/index.md) : [Closeable](-closeable/index.md)<br>Receives a stream of bytes.<br>[jvm]<br>interface [Sink](-sink/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html) |
| [Source](-source/index.md) | [common]<br>interface [Source](-source/index.md) : [Closeable](-closeable/index.md)<br>Supplies a stream of bytes. |
| [Throttler](-throttler/index.md) | [jvm]<br>class [Throttler](-throttler/index.md)<br>Enables limiting of Source and Sink throughput. |
| [Timeout](-timeout/index.md) | [common]<br>open class [Timeout](-timeout/index.md)<br>A policy on how much time to spend on a task before giving up.<br>[jvm]<br>open class [Timeout](-timeout/index.md) |
| [ZipFileSystem](-zip-file-system/index.md) | [jvm]<br>class [ZipFileSystem](-zip-file-system/index.md) : [FileSystem](-file-system/index.md)<br>Read only access to a [zip file](https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE_6.2.0.txt) and common [extra fields](https://opensource.apple.com/source/zip/zip-6/unzip/unzip/proginfo/extra.fld). |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [jvm]<br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[appendingSink](appending-sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes to file. |
| [asResourceFileSystem](as-resource-file-system.md) | [jvm]<br>fun [ClassLoader](https://docs.oracle.com/javase/8/docs/api/java/lang/ClassLoader.html).[asResourceFileSystem](as-resource-file-system.md)(): [FileSystem](-file-system/index.md) |
| [blackholeSink](blackhole-sink.md) | [common]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = blackhole)<br>fun [blackholeSink](blackhole-sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes nowhere. |
| [buffer](buffer.md) | [common]<br>fun [Sink](-sink/index.md).[buffer](buffer.md)(): [BufferedSink](-buffered-sink/index.md)<br>Returns a new sink that buffers writes to sink.<br>[common]<br>fun [Source](-source/index.md).[buffer](buffer.md)(): [BufferedSource](-buffered-source/index.md)<br>Returns a new source that buffers reads from source. |
| [cipherSink](cipher-sink.md) | [jvm]<br>fun [Sink](-sink/index.md).[cipherSink](cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](-cipher-sink/index.md)<br>Returns a sink that uses [cipher](cipher-sink.md) to encrypt or decrypt this. |
| [cipherSource](cipher-source.md) | [jvm]<br>fun [Source](-source/index.md#1331753033%2FExtensions%2F1033915053).[cipherSource](cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](-cipher-source/index.md)<br>Returns a source that uses [cipher](cipher-source.md) to encrypt or decrypt this. |
| [deflate](deflate.md) | [jvm]<br>inline fun [Sink](-sink/index.md).[deflate](deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) = Deflater()): [DeflaterSink](-deflater-sink/index.md)<br>Returns an [DeflaterSink](-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](-sink/index.md) while writing. |
| [gzip](gzip.md) | [jvm]<br>inline fun [Sink](-sink/index.md).[gzip](gzip.md)(): [GzipSink](-gzip-sink/index.md)<br>Returns a [GzipSink](-gzip-sink/index.md) that gzip-compresses to this [Sink](-sink/index.md) while writing.<br>[jvm]<br>inline fun [Source](-source/index.md#1331753033%2FExtensions%2F1033915053).[gzip](gzip.md)(): [GzipSource](-gzip-source/index.md)<br>Returns a [GzipSource](-gzip-source/index.md) that gzip-decompresses this [Source](-source/index.md#1331753033%2FExtensions%2F1033915053) while reading. |
| [hashingSink](hashing-sink.md) | [jvm]<br>fun [Sink](-sink/index.md).[hashingSink](hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](-hashing-sink/index.md)<br>Returns a sink that uses [digest](hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](-sink/index.md).[hashingSink](hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](-hashing-sink/index.md)<br>Returns a sink that uses [mac](hashing-sink.md) to hash this. |
| [hashingSource](hashing-source.md) | [jvm]<br>fun [Source](-source/index.md#1331753033%2FExtensions%2F1033915053).[hashingSource](hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](-hashing-source/index.md)<br>Returns a source that uses [digest](hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](-source/index.md#1331753033%2FExtensions%2F1033915053).[hashingSource](hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](-hashing-source/index.md)<br>Returns a source that uses [mac](hashing-source.md) to hash this. |
| [inflate](inflate.md) | [jvm]<br>inline fun [Source](-source/index.md#1331753033%2FExtensions%2F1033915053).[inflate](inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](-inflater-source/index.md)<br>Returns an [InflaterSource](-inflater-source/index.md) that DEFLATE-decompresses this [Source](-source/index.md#1331753033%2FExtensions%2F1033915053) while reading. |
| [openZip](open-zip.md) | [jvm]<br>fun [FileSystem](-file-system/index.md).[openZip](open-zip.md)(zipPath: [Path](-path/index.md)): [FileSystem](-file-system/index.md) |
| [sink](sink.md) | [jvm]<br>fun [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html).[sink](sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes to out.<br>[jvm]<br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[sink](sink.md)(): [Sink](-sink/index.md)<br>Returns a sink that writes to socket.<br>[jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[sink](sink.md)(append: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sink](-sink/index.md)<br>Returns a sink that writes to file.<br>[jvm]<br>@IgnoreJRERequirement()<br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[sink](sink.md)(vararg options: [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)): [Sink](-sink/index.md)<br>Returns a source that reads from path. |
| [source](source.md) | [jvm]<br>fun [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html).[source](source.md)(): [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>Returns a source that reads from file.<br>[jvm]<br>fun [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html).[source](source.md)(): [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>Returns a source that reads from in.<br>[jvm]<br>fun [Socket](https://docs.oracle.com/javase/8/docs/api/java/net/Socket.html).[source](source.md)(): [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>Returns a source that reads from socket.<br>[jvm]<br>@IgnoreJRERequirement()<br>fun [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html).[source](source.md)(vararg options: [OpenOption](https://docs.oracle.com/javase/8/docs/api/java/nio/file/OpenOption.html)): [Source](-source/index.md#1331753033%2FExtensions%2F1033915053)<br>Returns a sink that writes to path. |
| [toByteString](to-byte-string.md) | [apple]<br>fun <ERROR CLASS>.[toByteString](to-byte-string.md)(): <ERROR CLASS> |
| [use](use.md) | [common]<br>inline fun <[T](use.md) : [Closeable](-closeable/index.md)?, [R](use.md)> [T](use.md).[use](use.md)(block: ([T](use.md)) -> [R](use.md)): [R](use.md)<br>Execute [block](use.md) then close this. |
| [utf8Size](utf8-size.md) | [common]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = size)<br>fun [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html).[utf8Size](utf8-size.md)(beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 0, endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = length): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Returns the number of bytes used to encode the slice of string as UTF-8 when using [BufferedSink.writeUtf8](-buffered-sink/write-utf8.md). |

## Properties

| Name | Summary |
|---|---|
| [Okio](-okio.md) | [jvm]<br>val [Okio](-okio.md): -DeprecatedOkio |
| [Utf8](-utf8.md) | [jvm]<br>val [Utf8](-utf8.md): -DeprecatedUtf8 |
