//[okio-fakefilesystem](../../index.md)/[okio.fakefilesystem](../index.md)/[FakeFileSystem](index.md)/[checkNoOpenFiles](check-no-open-files.md)



# checkNoOpenFiles  
[common]  
Content  
fun [checkNoOpenFiles](check-no-open-files.md)()  
More info  


Confirm that all files that have been opened on this file system (with [source](source.md), [sink](sink.md), and [appendingSink](appending-sink.md)) have since been closed. Call this in your test's tearDown() function to confirm that your program hasn't leaked any open files.



Forgetting to close a file on a real file system is a severe error that may lead to a program crash. The operating system enforces a limit on how many files may be open simultaneously. On Linux this is [getrlimit](https://man7.org/linux/man-pages/man2/getrlimit.2.html) and is commonly adjusted with the ulimit command.



#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio.fakefilesystem/FakeFileSystem/checkNoOpenFiles/#/PointingToDeclaration/"></a>[kotlin.IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html)| <a name="okio.fakefilesystem/FakeFileSystem/checkNoOpenFiles/#/PointingToDeclaration/"></a><br><br>if any files are open when this function is called.<br><br>
  



