//[okio](../../index.md)/[okio](../index.md)/[Buffer](index.md)



# Buffer  
 [common] class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md)

A collection of bytes in memory.



**Moving data from one buffer to another is fast.** Instead of copying bytes from one place in memory to another, this class just changes ownership of the underlying byte arrays.



**This buffer grows with your data.** Just like ArrayList, each buffer starts small. It consumes only the memory it needs to.



**This buffer pools its byte arrays.** When you allocate a byte array in Java, the runtime must zero-fill the requested array before returning it to you. Even if you're going to write over that space anyway. This class avoids zero-fill and GC churn by pooling byte arrays.

   
 [jvm] class [Buffer](index.md) : [BufferedSource](../-buffered-source/index.md), [BufferedSink](../-buffered-sink/index.md), [Cloneable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-cloneable/index.html), [ByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ByteChannel.html)   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer/Buffer/#/PointingToDeclaration/"></a>[Buffer](index.md#%5Bokio%2FBuffer%2FBuffer%2F%23%2FPointingToDeclaration%2F%5D%2FConstructors%2F113773673)| <a name="okio/Buffer/Buffer/#/PointingToDeclaration/"></a> [common] fun [Buffer](index.md#%5Bokio%2FBuffer%2FBuffer%2F%23%2FPointingToDeclaration%2F%5D%2FConstructors%2F113773673)()   <br>


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer.UnsafeCursor///PointingToDeclaration/"></a>[UnsafeCursor](-unsafe-cursor/index.md)| <a name="okio/Buffer.UnsafeCursor///PointingToDeclaration/"></a>[common]  <br>Content  <br>class [UnsafeCursor](-unsafe-cursor/index.md)  <br>More info  <br>A handle to the underlying data in a buffer.  <br><br><br>[jvm]  <br>Content  <br>class [UnsafeCursor](-unsafe-cursor/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html)  <br>More info  <br>  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer/buffer/#/PointingToDeclaration/"></a>[buffer](buffer.md)| <a name="okio/Buffer/buffer/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [buffer](buffer.md)(): [Buffer](index.md)  <br>More info  <br>Returns this source's internal buffer.  <br><br><br>
| <a name="okio/Buffer/clear/#/PointingToDeclaration/"></a>[clear](clear.md)| <a name="okio/Buffer/clear/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [clear](clear.md)()  <br>More info  <br>Discards all bytes in this buffer.  <br><br><br>[jvm]  <br>Content  <br>fun [clear](clear.md)()  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/clone/#/PointingToDeclaration/"></a>[clone](clone.md)| <a name="okio/Buffer/clone/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [clone](clone.md)(): [Buffer](index.md)  <br>More info  <br>Returns a deep copy of this buffer.  <br><br><br>
| <a name="okio/Buffer/close/#/PointingToDeclaration/"></a>close| <a name="okio/Buffer/close/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [close](close.md)()  <br><br><br>[common]  <br>Content  <br>abstract override fun [close](../-source/close.md)()  <br>More info  <br>Closes this source and releases the resources held by this source.  <br><br><br>
| <a name="okio/Buffer/completeSegmentByteCount/#/PointingToDeclaration/"></a>[completeSegmentByteCount](complete-segment-byte-count.md)| <a name="okio/Buffer/completeSegmentByteCount/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the number of bytes in segments that are not writable.  <br><br><br>[jvm]  <br>Content  <br>fun [completeSegmentByteCount](complete-segment-byte-count.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/copy/#/PointingToDeclaration/"></a>[copy](copy.md)| <a name="okio/Buffer/copy/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [copy](copy.md)(): [Buffer](index.md)  <br>More info  <br>Returns a deep copy of this buffer.  <br><br><br>[jvm]  <br>Content  <br>fun [copy](copy.md)(): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/copyTo/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>copyTo| <a name="okio/Buffer/copyTo/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [copyTo](index.md#%5Bokio%2FBuffer%2FcopyTo%2F%23okio.Buffer%23kotlin.Long%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Buffer](index.md)  <br>More info  <br>Overload of [copyTo](index.md#%5Bokio%2FBuffer%2FcopyTo%2F%23okio.Buffer%23kotlin.Long%23kotlin.Long%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673) with byteCount = size - offset, work around for https://youtrack.jetbrains.  <br><br><br>[jvm]  <br>Content  <br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Buffer](index.md)  <br>fun [copyTo](copy-to.md)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>[jvm, common]  <br>Content  <br>[jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [copyTo](copy-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = size - offset): [Buffer](index.md)  <br>[common]  <br>fun [copyTo](index.md#%5Bokio%2FBuffer%2FcopyTo%2F%23okio.Buffer%23kotlin.Long%23kotlin.Long%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(out: [Buffer](index.md), offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L, byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Copy byteCount bytes from this, starting at offset, to out.  <br><br><br>
| <a name="okio/Source/cursor/#/PointingToDeclaration/"></a>cursor| <a name="okio/Source/cursor/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [cursor](../-source/cursor.md)(): [Cursor](../-cursor/index.md)?  <br>[jvm]  <br>open fun [cursor](../-hashing-source/index.md#%5Bokio%2FSource%2Fcursor%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Cursor](../-cursor/index.md)?  <br>More info  <br>Returns a cursor to access the position and size of this source if it supports random access.  <br><br><br>
| <a name="okio/Buffer/emit/#/PointingToDeclaration/"></a>[emit](emit.md)| <a name="okio/Buffer/emit/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [emit](emit.md)(): [Buffer](index.md)  <br>More info  <br>Writes all buffered data to the underlying sink, if one exists.  <br><br><br>[jvm]  <br>Content  <br>open override fun [emit](emit.md)(): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/emitCompleteSegments/#/PointingToDeclaration/"></a>[emitCompleteSegments](emit-complete-segments.md)| <a name="okio/Buffer/emitCompleteSegments/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)  <br>More info  <br>Writes complete segments to the underlying sink, if one exists.  <br><br><br>[jvm]  <br>Content  <br>open override fun [emitCompleteSegments](emit-complete-segments.md)(): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Buffer/exhausted/#/PointingToDeclaration/"></a>exhausted| <a name="okio/Buffer/exhausted/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [exhausted](../-buffered-source/exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if there are no more bytes in this source.  <br><br><br>
| <a name="okio/Buffer/flush/#/PointingToDeclaration/"></a>flush| <a name="okio/Buffer/flush/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [flush](flush.md)()  <br><br><br>[common]  <br>Content  <br>abstract override fun [flush](../-buffered-sink/flush.md)()  <br>More info  <br>Writes all buffered data to the underlying sink, if one exists.  <br><br><br>
| <a name="okio/Buffer/get/#kotlin.Long/PointingToDeclaration/"></a>[get](get.md)| <a name="okio/Buffer/get/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>Returns the byte at pos.  <br><br><br>[jvm]  <br>Content  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "getByte")  <br>  <br>operator fun [get](get.md)(pos: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Buffer/hmacSha1/#okio.ByteString/PointingToDeclaration/"></a>[hmacSha1](hmac-sha1.md)| <a name="okio/Buffer/hmacSha1/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>fun [hmacSha1](hmac-sha1.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 160-bit SHA-1 HMAC of this buffer.  <br><br><br>
| <a name="okio/Buffer/hmacSha256/#okio.ByteString/PointingToDeclaration/"></a>[hmacSha256](hmac-sha256.md)| <a name="okio/Buffer/hmacSha256/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>fun [hmacSha256](hmac-sha256.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 256-bit SHA-256 HMAC of this buffer.  <br><br><br>
| <a name="okio/Buffer/hmacSha512/#okio.ByteString/PointingToDeclaration/"></a>[hmacSha512](hmac-sha512.md)| <a name="okio/Buffer/hmacSha512/#okio.ByteString/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>fun [hmacSha512](hmac-sha512.md)(key: [ByteString](../-byte-string/index.md)): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 512-bit SHA-512 HMAC of this buffer.  <br><br><br>
| <a name="okio/Buffer/indexOf/#kotlin.Byte/PointingToDeclaration/"></a>indexOf| <a name="okio/Buffer/indexOf/#kotlin.Byte/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>open override fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Equivalent to [indexOf(b, 0)](../-buffered-source/index-of.md).  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](../-buffered-source/index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Equivalent to [indexOf(bytes, 0)](../-buffered-source/index-of.md).  <br><br><br>[jvm]  <br>Content  <br>open override fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of b in this at or beyond fromIndex, or -1 if this buffer does not contain b in that range.  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of the first b in the buffer at or after fromIndex.  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](../-buffered-source/index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of the first match for bytes in the buffer at or after fromIndex.  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](../-buffered-source/index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of b if it is found in the range of fromIndex inclusive to toIndex exclusive.  <br><br><br>
| <a name="okio/Buffer/indexOfElement/#okio.ByteString/PointingToDeclaration/"></a>indexOfElement| <a name="okio/Buffer/indexOfElement/#okio.ByteString/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>open override fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOfElement](../-buffered-source/index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Equivalent to [indexOfElement(targetBytes, 0)](../-buffered-source/index-of-element.md).  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOfElement](../-buffered-source/index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the first index in this buffer that is at or after fromIndex and that contains any of the bytes in targetBytes.  <br><br><br>
| <a name="okio/Buffer/inputStream/#/PointingToDeclaration/"></a>[inputStream](input-stream.md)| <a name="okio/Buffer/inputStream/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)  <br>More info  <br>Returns an input stream that reads from this source.  <br><br><br>
| <a name="okio/Buffer/isOpen/#/PointingToDeclaration/"></a>[isOpen](is-open.md)| <a name="okio/Buffer/isOpen/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [isOpen](is-open.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Buffer/md5/#/PointingToDeclaration/"></a>[md5](md5.md)| <a name="okio/Buffer/md5/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>  <br><br><br>[jvm]  <br>Content  <br>fun [md5](md5.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 128-bit MD5 hash of this buffer.  <br><br><br>
| <a name="okio/Buffer/outputStream/#/PointingToDeclaration/"></a>[outputStream](output-stream.md)| <a name="okio/Buffer/outputStream/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [outputStream](output-stream.md)(): [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html)  <br>More info  <br>Returns an output stream that writes to this sink.  <br><br><br>
| <a name="okio/Buffer/peek/#/PointingToDeclaration/"></a>peek| <a name="okio/Buffer/peek/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [peek](peek.md)(): [BufferedSource](../-buffered-source/index.md)  <br><br><br>[common]  <br>Content  <br>abstract fun [peek](../-buffered-source/peek.md)(): [BufferedSource](../-buffered-source/index.md)  <br>More info  <br>Returns a new BufferedSource that can read data from this BufferedSource without consuming it.  <br><br><br>
| <a name="okio/Buffer/rangeEquals/#kotlin.Long#okio.ByteString/PointingToDeclaration/"></a>rangeEquals| <a name="okio/Buffer/rangeEquals/#kotlin.Long#okio.ByteString/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>open override fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [rangeEquals](../-buffered-source/range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if the bytes at offset in this source equal bytes.  <br><br><br>[common]  <br>Content  <br>abstract fun [rangeEquals](../-buffered-source/range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if byteCount bytes at offset in this source equal bytes at bytesOffset.  <br><br><br>
| <a name="okio/Buffer/read/#java.nio.ByteBuffer/PointingToDeclaration/"></a>read| <a name="okio/Buffer/read/#java.nio.ByteBuffer/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [read](read.md)(sink: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>open override fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [read](../-buffered-source/read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes up to sink.length bytes from this and copies them into sink.  <br><br><br>[jvm, common]  <br>Content  <br>[jvm]  <br>open override fun [read](read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[common]  <br>abstract fun [read](../-source/read.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes at least 1, and up to byteCount bytes from this and appends them to sink.  <br><br><br>[common]  <br>Content  <br>abstract fun [read](../-buffered-source/read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes up to byteCount bytes from this and copies them into sink at offset.  <br><br><br>
| <a name="okio/Buffer/readAll/#okio.Sink/PointingToDeclaration/"></a>readAll| <a name="okio/Buffer/readAll/#okio.Sink/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readAll](../-buffered-source/read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes all bytes from this and appends them to sink.  <br><br><br>
| <a name="okio/Buffer/readAndWriteUnsafe/#okio.Buffer.UnsafeCursor/PointingToDeclaration/"></a>[readAndWriteUnsafe](read-and-write-unsafe.md)| <a name="okio/Buffer/readAndWriteUnsafe/#okio.Buffer.UnsafeCursor/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = UnsafeCursor()): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)  <br>[jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [readAndWriteUnsafe](read-and-write-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = UnsafeCursor()): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)  <br><br><br>
| <a name="okio/Buffer/readByte/#/PointingToDeclaration/"></a>readByte| <a name="okio/Buffer/readByte/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readByte](../-buffered-source/read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>Removes a byte from this source and returns it.  <br><br><br>
| <a name="okio/Buffer/readByteArray/#/PointingToDeclaration/"></a>readByteArray| <a name="okio/Buffer/readByteArray/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>open override fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readByteArray](../-buffered-source/read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>Removes all bytes from this and returns them as a byte array.  <br><br><br>[common]  <br>Content  <br>abstract fun [readByteArray](../-buffered-source/read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>Removes byteCount bytes from this and returns them as a byte array.  <br><br><br>
| <a name="okio/Buffer/readByteString/#/PointingToDeclaration/"></a>readByteString| <a name="okio/Buffer/readByteString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)  <br>open override fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)  <br><br><br>[common]  <br>Content  <br>abstract fun [readByteString](../-buffered-source/read-byte-string.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Removes all bytes from this and returns them as a byte string.  <br><br><br>[common]  <br>Content  <br>abstract fun [readByteString](../-buffered-source/read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)  <br>More info  <br>Removes byteCount bytes from this and returns them as a byte string.  <br><br><br>
| <a name="okio/Buffer/readDecimalLong/#/PointingToDeclaration/"></a>readDecimalLong| <a name="okio/Buffer/readDecimalLong/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readDecimalLong](../-buffered-source/read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-').  <br><br><br>
| <a name="okio/Buffer/readFrom/#java.io.InputStream/PointingToDeclaration/"></a>[readFrom](read-from.md)| <a name="okio/Buffer/readFrom/#java.io.InputStream/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)): [Buffer](index.md)  <br>More info  <br>Read and exhaust bytes from input into this.  <br><br><br>[jvm]  <br>Content  <br>fun [readFrom](read-from.md)(input: [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Read byteCount bytes from input into this.  <br><br><br>
| <a name="okio/Buffer/readFully/#kotlin.ByteArray/PointingToDeclaration/"></a>readFully| <a name="okio/Buffer/readFully/#kotlin.ByteArray/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))  <br>open override fun [readFully](read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>[common]  <br>Content  <br>abstract fun [readFully](../-buffered-source/read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))  <br>More info  <br>Removes exactly sink.length bytes from this and copies them into sink.  <br><br><br>[common]  <br>Content  <br>abstract fun [readFully](../-buffered-source/read-fully.md)(sink: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes exactly byteCount bytes from this and appends them to sink.  <br><br><br>
| <a name="okio/Buffer/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a>readHexadecimalUnsignedLong| <a name="okio/Buffer/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readHexadecimalUnsignedLong](../-buffered-source/read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16).  <br><br><br>
| <a name="okio/Buffer/readInt/#/PointingToDeclaration/"></a>readInt| <a name="okio/Buffer/readInt/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readInt](../-buffered-source/read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes four bytes from this source and returns a big-endian int.  <br><br><br>
| <a name="okio/Buffer/readIntLe/#/PointingToDeclaration/"></a>readIntLe| <a name="okio/Buffer/readIntLe/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readIntLe](../-buffered-source/read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes four bytes from this source and returns a little-endian int.  <br><br><br>
| <a name="okio/Buffer/readLong/#/PointingToDeclaration/"></a>readLong| <a name="okio/Buffer/readLong/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readLong](../-buffered-source/read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes eight bytes from this source and returns a big-endian long.  <br><br><br>
| <a name="okio/Buffer/readLongLe/#/PointingToDeclaration/"></a>readLongLe| <a name="okio/Buffer/readLongLe/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readLongLe](../-buffered-source/read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes eight bytes from this source and returns a little-endian long.  <br><br><br>
| <a name="okio/Buffer/readShort/#/PointingToDeclaration/"></a>readShort| <a name="okio/Buffer/readShort/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readShort](../-buffered-source/read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br>More info  <br>Removes two bytes from this source and returns a big-endian short.  <br><br><br>
| <a name="okio/Buffer/readShortLe/#/PointingToDeclaration/"></a>readShortLe| <a name="okio/Buffer/readShortLe/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readShortLe](../-buffered-source/read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br>More info  <br>Removes two bytes from this source and returns a little-endian short.  <br><br><br>
| <a name="okio/Buffer/readString/#java.nio.charset.Charset/PointingToDeclaration/"></a>[readString](read-string.md)| <a name="okio/Buffer/readString/#java.nio.charset.Charset/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes all bytes from this, decodes them as charset, and returns the string.  <br><br><br>[jvm]  <br>Content  <br>open override fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes byteCount bytes from this, decodes them as charset, and returns the string.  <br><br><br>
| <a name="okio/Buffer/readUnsafe/#okio.Buffer.UnsafeCursor/PointingToDeclaration/"></a>[readUnsafe](read-unsafe.md)| <a name="okio/Buffer/readUnsafe/#okio.Buffer.UnsafeCursor/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = UnsafeCursor()): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)  <br>[jvm]  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [readUnsafe](read-unsafe.md)(unsafeCursor: [Buffer.UnsafeCursor](-unsafe-cursor/index.md) = UnsafeCursor()): [Buffer.UnsafeCursor](-unsafe-cursor/index.md)  <br><br><br>
| <a name="okio/Buffer/readUtf8/#/PointingToDeclaration/"></a>readUtf8| <a name="okio/Buffer/readUtf8/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>open override fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8](../-buffered-source/read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes all bytes from this, decodes them as UTF-8, and returns the string.  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8](../-buffered-source/read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes byteCount bytes from this, decodes them as UTF-8, and returns the string.  <br><br><br>
| <a name="okio/Buffer/readUtf8CodePoint/#/PointingToDeclaration/"></a>readUtf8CodePoint| <a name="okio/Buffer/readUtf8CodePoint/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8CodePoint](../-buffered-source/read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary.  <br><br><br>
| <a name="okio/Buffer/readUtf8Line/#/PointingToDeclaration/"></a>readUtf8Line| <a name="okio/Buffer/readUtf8Line/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8Line](../-buffered-source/read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?  <br>More info  <br>Removes and returns characters up to but not including the next line break.  <br><br><br>
| <a name="okio/Buffer/readUtf8LineStrict/#/PointingToDeclaration/"></a>readUtf8LineStrict| <a name="okio/Buffer/readUtf8LineStrict/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>open override fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes and returns characters up to but not including the next line break.  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Like [readUtf8LineStrict](../-buffered-source/read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match.  <br><br><br>
| <a name="okio/Buffer/request/#kotlin.Long/PointingToDeclaration/"></a>request| <a name="okio/Buffer/request/#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [request](../-buffered-source/request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true when the buffer contains at least byteCount bytes, expanding it as necessary.  <br><br><br>
| <a name="okio/Buffer/require/#kotlin.Long/PointingToDeclaration/"></a>require| <a name="okio/Buffer/require/#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>[common]  <br>Content  <br>abstract fun [require](../-buffered-source/require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Returns when the buffer contains at least byteCount bytes.  <br><br><br>
| <a name="okio/Buffer/select/#okio.Options/PointingToDeclaration/"></a>select| <a name="okio/Buffer/select/#okio.Options/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [select](../-buffered-source/select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Finds the first string in options that is a prefix of this buffer, consumes it from this buffer, and returns its index.  <br><br><br>
| <a name="okio/Buffer/sha1/#/PointingToDeclaration/"></a>[sha1](sha1.md)| <a name="okio/Buffer/sha1/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>  <br><br><br>[jvm]  <br>Content  <br>fun [sha1](sha1.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 160-bit SHA-1 hash of this buffer.  <br><br><br>
| <a name="okio/Buffer/sha256/#/PointingToDeclaration/"></a>[sha256](sha256.md)| <a name="okio/Buffer/sha256/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>  <br><br><br>[jvm]  <br>Content  <br>fun [sha256](sha256.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 256-bit SHA-256 hash of this buffer.  <br><br><br>
| <a name="okio/Buffer/sha512/#/PointingToDeclaration/"></a>[sha512](sha512.md)| <a name="okio/Buffer/sha512/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>  <br><br><br>[jvm]  <br>Content  <br>fun [sha512](sha512.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns the 512-bit SHA-512 hash of this buffer.  <br><br><br>
| <a name="okio/Buffer/skip/#kotlin.Long/PointingToDeclaration/"></a>[skip](skip.md)| <a name="okio/Buffer/skip/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Discards byteCount bytes from the head of this buffer.  <br><br><br>[jvm]  <br>Content  <br>open override fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/snapshot/#/PointingToDeclaration/"></a>[snapshot](snapshot.md)| <a name="okio/Buffer/snapshot/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns an immutable copy of this buffer as a byte string.  <br><br><br>[jvm]  <br>Content  <br>fun [snapshot](snapshot.md)(): [ByteString](../-byte-string/index.md)  <br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>fun [snapshot](snapshot.md)(byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [ByteString](../-byte-string/index.md)  <br>More info  <br>Returns an immutable copy of the first byteCount bytes of this buffer as a byte string.  <br><br><br>
| <a name="okio/Buffer/timeout/#/PointingToDeclaration/"></a>timeout| <a name="okio/Buffer/timeout/#/PointingToDeclaration/"></a>[jvm, common]  <br>Content  <br>[jvm]  <br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br>[common]  <br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this source.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>[jvm]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Returns a human-readable string that describes the contents of this buffer.  <br><br><br>
| <a name="okio/Buffer/write/#java.nio.ByteBuffer/PointingToDeclaration/"></a>write| <a name="okio/Buffer/write/#java.nio.ByteBuffer/PointingToDeclaration/"></a>[jvm, common]  <br>Content  <br>[jvm]  <br>open override fun [write](write.md)(source: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)  <br>[common]  <br>open override fun [write](index.md#%5Bokio%2FBuffer%2Fwrite%2F%23okio.ByteString%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)  <br>[jvm]  <br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md)): [Buffer](index.md)  <br>[jvm]  <br>open override fun [write](write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>[jvm]  <br>open override fun [write](write.md)(source: [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-43762623), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>[jvm]  <br>open override fun [write](write.md)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>[common]  <br>open override fun [write](index.md#%5Bokio%2FBuffer%2Fwrite%2F%23okio.ByteString%23kotlin.Int%23kotlin.Int%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>[jvm]  <br>open override fun [write](write.md)(byteString: [ByteString](../-byte-string/index.md), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br><br><br>[common]  <br>Content  <br>open override fun [write](index.md#%5Bokio%2FBuffer%2Fwrite%2F%23kotlin.ByteArray%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Buffer](index.md)  <br>open override fun [write](index.md#%5Bokio%2FBuffer%2Fwrite%2F%23kotlin.ByteArray%23kotlin.Int%23kotlin.Int%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(source: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Like OutputStream.  <br><br><br>[common]  <br>Content  <br>open override fun [write](index.md#%5Bokio%2FBuffer%2Fwrite%2F%23okio.Source%23kotlin.Long%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(source: [Source](../-source/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Removes byteCount bytes from source and appends them to this sink.  <br><br><br>[common]  <br>Content  <br>abstract fun [write](../-sink/write.md)(source: [Buffer](index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes byteCount bytes from source and appends them to this.  <br><br><br>
| <a name="okio/Buffer/writeAll/#okio.Source/PointingToDeclaration/"></a>writeAll| <a name="okio/Buffer/writeAll/#okio.Source/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [writeAll](write-all.md)(source: [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-43762623)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [writeAll](../-buffered-sink/write-all.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes all bytes from source and appends them to this sink.  <br><br><br>
| <a name="okio/Buffer/writeByte/#kotlin.Int/PointingToDeclaration/"></a>[writeByte](write-byte.md)| <a name="okio/Buffer/writeByte/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a byte to this sink.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeByte](write-byte.md)(b: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeDecimalLong/#kotlin.Long/PointingToDeclaration/"></a>[writeDecimalLong](write-decimal-long.md)| <a name="okio/Buffer/writeDecimalLong/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a long to this sink in signed decimal form (i.e., as a string in base 10).  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeDecimalLong](write-decimal-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeHexadecimalUnsignedLong/#kotlin.Long/PointingToDeclaration/"></a>[writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)| <a name="okio/Buffer/writeHexadecimalUnsignedLong/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a long to this sink in hexadecimal form (i.e., as a string in base 16).  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeHexadecimalUnsignedLong](write-hexadecimal-unsigned-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeInt/#kotlin.Int/PointingToDeclaration/"></a>[writeInt](write-int.md)| <a name="okio/Buffer/writeInt/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a big-endian int to this sink using four bytes.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeInt](write-int.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeIntLe/#kotlin.Int/PointingToDeclaration/"></a>[writeIntLe](write-int-le.md)| <a name="okio/Buffer/writeIntLe/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a little-endian int to this sink using four bytes.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeIntLe](write-int-le.md)(i: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeLong/#kotlin.Long/PointingToDeclaration/"></a>[writeLong](write-long.md)| <a name="okio/Buffer/writeLong/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a big-endian long to this sink using eight bytes.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeLong](write-long.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeLongLe/#kotlin.Long/PointingToDeclaration/"></a>[writeLongLe](write-long-le.md)| <a name="okio/Buffer/writeLongLe/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a little-endian long to this sink using eight bytes.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeLongLe](write-long-le.md)(v: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeShort/#kotlin.Int/PointingToDeclaration/"></a>[writeShort](write-short.md)| <a name="okio/Buffer/writeShort/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a big-endian short to this sink using two bytes.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeShort](write-short.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeShortLe/#kotlin.Int/PointingToDeclaration/"></a>[writeShortLe](write-short-le.md)| <a name="okio/Buffer/writeShortLe/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Writes a little-endian short to this sink using two bytes.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Buffer/writeString/#kotlin.String#java.nio.charset.Charset/PointingToDeclaration/"></a>[writeString](write-string.md)| <a name="okio/Buffer/writeString/#kotlin.String#java.nio.charset.Charset/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)  <br>open override fun [writeString](write-string.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [Buffer](index.md)  <br><br><br>
| <a name="okio/Buffer/writeTo/#java.io.OutputStream#kotlin.Long/PointingToDeclaration/"></a>[writeTo](write-to.md)| <a name="okio/Buffer/writeTo/#java.io.OutputStream#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)()  <br>  <br>fun [writeTo](write-to.md)(out: [OutputStream](https://docs.oracle.com/javase/8/docs/api/java/io/OutputStream.html), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = size): [Buffer](index.md)  <br>More info  <br>Write byteCount bytes from this to out.  <br><br><br>
| <a name="okio/Buffer/writeUtf8/#kotlin.String/PointingToDeclaration/"></a>[writeUtf8](write-utf8.md)| <a name="okio/Buffer/writeUtf8/#kotlin.String/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)  <br>More info  <br>Encodes string in UTF-8 and writes it to this sink.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Buffer](index.md)  <br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>open override fun [writeUtf8](write-utf8.md)(string: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), beginIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), endIndex: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Encodes the characters at beginIndex up to endIndex from string in UTF-8 and writes it to this sink.  <br><br><br>
| <a name="okio/Buffer/writeUtf8CodePoint/#kotlin.Int/PointingToDeclaration/"></a>[writeUtf8CodePoint](write-utf8-code-point.md)| <a name="okio/Buffer/writeUtf8CodePoint/#kotlin.Int/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>Encodes codePoint in UTF-8 and writes it to this sink.  <br><br><br>[jvm]  <br>Content  <br>open override fun [writeUtf8CodePoint](write-utf8-code-point.md)(codePoint: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Buffer](index.md)  <br>More info  <br>  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Buffer/buffer/#/PointingToDeclaration/"></a>buffer| <a name="okio/Buffer/buffer/#/PointingToDeclaration/"></a> [common] open override val [buffer](index.md#%5Bokio%2FBuffer%2Fbuffer%2F%23%2FPointingToDeclaration%2F%5D%2FProperties%2F113773673): [Buffer](index.md)This source's internal buffer.   <br> [jvm] open override val [buffer](buffer.md): [Buffer](index.md)   <br>
| <a name="okio/Buffer/size/#/PointingToDeclaration/"></a>[size](size.md)| <a name="okio/Buffer/size/#/PointingToDeclaration/"></a> [common, jvm] var [size](size.md): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L   <br>

