//[okio](../../index.md)/[okio](../index.md)/[BufferedSource](index.md)



# BufferedSource  
 [common] interface [BufferedSource](index.md) : [Source](../-source/index.md)

A source that keeps a buffer internally so that callers can do small reads without a performance penalty. It also allows clients to read ahead, buffering as much as necessary before consuming input.

   
 [jvm] interface [BufferedSource](index.md) : [Source](../-source/index.md#%5Bokio%2FSource%2F%2F%2FPointingToDeclaration%2F%5D%2FExtensions%2F-43762623), [ReadableByteChannel](https://docs.oracle.com/javase/8/docs/api/java/nio/channels/ReadableByteChannel.html)   


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Source/close/#/PointingToDeclaration/"></a>close| <a name="okio/Source/close/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>abstract override fun [close](../-source/close.md)()  <br>[jvm]  <br>abstract override fun [close](../-hashing-source/index.md#%5Bokio%2FSource%2Fclose%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)()  <br>More info  <br>Closes this source and releases the resources held by this source.  <br><br><br>
| <a name="okio/Source/cursor/#/PointingToDeclaration/"></a>cursor| <a name="okio/Source/cursor/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [cursor](../-source/cursor.md)(): [Cursor](../-cursor/index.md)?  <br>[jvm]  <br>open fun [cursor](../-hashing-source/index.md#%5Bokio%2FSource%2Fcursor%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Cursor](../-cursor/index.md)?  <br>More info  <br>Returns a cursor to access the position and size of this source if it supports random access.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/BufferedSource/exhausted/#/PointingToDeclaration/"></a>[exhausted](exhausted.md)| <a name="okio/BufferedSource/exhausted/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if there are no more bytes in this source.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [exhausted](exhausted.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/BufferedSource/indexOf/#kotlin.Byte/PointingToDeclaration/"></a>[indexOf](index-of.md)| <a name="okio/BufferedSource/indexOf/#kotlin.Byte/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Equivalent to [indexOf(b, 0)](index-of.md).  <br><br><br>[jvm]  <br>Content  <br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Equivalent to [indexOf(bytes, 0)](index-of.md).  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of the first b in the buffer at or after fromIndex.  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](index-of.md)(bytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of the first match for bytes in the buffer at or after fromIndex.  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOf](index-of.md)(b: [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), toIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the index of b if it is found in the range of fromIndex inclusive to toIndex exclusive.  <br><br><br>
| <a name="okio/BufferedSource/indexOfElement/#okio.ByteString/PointingToDeclaration/"></a>[indexOfElement](index-of-element.md)| <a name="okio/BufferedSource/indexOfElement/#okio.ByteString/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Equivalent to [indexOfElement(targetBytes, 0)](index-of-element.md).  <br><br><br>[jvm]  <br>Content  <br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [indexOfElement](index-of-element.md)(targetBytes: [ByteString](../-byte-string/index.md), fromIndex: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the first index in this buffer that is at or after fromIndex and that contains any of the bytes in targetBytes.  <br><br><br>
| <a name="okio/BufferedSource/inputStream/#/PointingToDeclaration/"></a>[inputStream](input-stream.md)| <a name="okio/BufferedSource/inputStream/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [inputStream](input-stream.md)(): [InputStream](https://docs.oracle.com/javase/8/docs/api/java/io/InputStream.html)  <br>More info  <br>Returns an input stream that reads from this source.  <br><br><br>
| <a name="java.nio.channels/Channel/isOpen/#/PointingToDeclaration/"></a>[isOpen](index.md#%5Bjava.nio.channels%2FChannel%2FisOpen%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)| <a name="java.nio.channels/Channel/isOpen/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [isOpen](index.md#%5Bjava.nio.channels%2FChannel%2FisOpen%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/BufferedSource/peek/#/PointingToDeclaration/"></a>[peek](peek.md)| <a name="okio/BufferedSource/peek/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [peek](peek.md)(): [BufferedSource](index.md)  <br>More info  <br>Returns a new BufferedSource that can read data from this BufferedSource without consuming it.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [peek](peek.md)(): [BufferedSource](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/rangeEquals/#kotlin.Long#okio.ByteString/PointingToDeclaration/"></a>[rangeEquals](range-equals.md)| <a name="okio/BufferedSource/rangeEquals/#kotlin.Long#okio.ByteString/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if the bytes at offset in this source equal bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [rangeEquals](range-equals.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), bytes: [ByteString](../-byte-string/index.md), bytesOffset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true if byteCount bytes at offset in this source equal bytes at bytesOffset.  <br><br><br>
| <a name="java.nio.channels/ReadableByteChannel/read/#java.nio.ByteBuffer/PointingToDeclaration/"></a>read| <a name="java.nio.channels/ReadableByteChannel/read/#java.nio.ByteBuffer/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [read](index.md#%5Bjava.nio.channels%2FReadableByteChannel%2Fread%2F%23java.nio.ByteBuffer%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(p0: [ByteBuffer](https://docs.oracle.com/javase/8/docs/api/java/nio/ByteBuffer.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>[common]  <br>Content  <br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes up to sink.length bytes from this and copies them into sink.  <br><br><br>[common, jvm]  <br>Content  <br>[common]  <br>abstract fun [read](../-source/read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>[jvm]  <br>abstract fun [read](../-hashing-source/index.md#%5Bokio%2FSource%2Fread%2F%23okio.Buffer%23kotlin.Long%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes at least 1, and up to byteCount bytes from this and appends them to sink.  <br><br><br>[common]  <br>Content  <br>abstract fun [read](read.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html), offset: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), byteCount: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes up to byteCount bytes from this and copies them into sink at offset.  <br><br><br>
| <a name="okio/BufferedSource/readAll/#okio.Sink/PointingToDeclaration/"></a>[readAll](read-all.md)| <a name="okio/BufferedSource/readAll/#okio.Sink/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes all bytes from this and appends them to sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readAll](read-all.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readByte/#/PointingToDeclaration/"></a>[readByte](read-byte.md)| <a name="okio/BufferedSource/readByte/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>Removes a byte from this source and returns it.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readByte](read-byte.md)(): [Byte](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readByteArray/#/PointingToDeclaration/"></a>[readByteArray](read-byte-array.md)| <a name="okio/BufferedSource/readByteArray/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>Removes all bytes from this and returns them as a byte array.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readByteArray](read-byte-array.md)(): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>abstract fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [readByteArray](read-byte-array.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)  <br>More info  <br>Removes byteCount bytes from this and returns them as a byte array.  <br><br><br>
| <a name="okio/BufferedSource/readByteString/#/PointingToDeclaration/"></a>[readByteString](read-byte-string.md)| <a name="okio/BufferedSource/readByteString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)  <br>More info  <br>Removes all bytes from this and returns them as a byte string.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readByteString](read-byte-string.md)(): [ByteString](../-byte-string/index.md)  <br>abstract fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [readByteString](read-byte-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [ByteString](../-byte-string/index.md)  <br>More info  <br>Removes byteCount bytes from this and returns them as a byte string.  <br><br><br>
| <a name="okio/BufferedSource/readDecimalLong/#/PointingToDeclaration/"></a>[readDecimalLong](read-decimal-long.md)| <a name="okio/BufferedSource/readDecimalLong/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Reads a long from this source in signed decimal form (i.e., as a string in base 10 with optional leading '-').  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readDecimalLong](read-decimal-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readFully/#kotlin.ByteArray/PointingToDeclaration/"></a>[readFully](read-fully.md)| <a name="okio/BufferedSource/readFully/#kotlin.ByteArray/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))  <br>More info  <br>Removes exactly sink.length bytes from this and copies them into sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readFully](read-fully.md)(sink: [ByteArray](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html))  <br>abstract fun [readFully](read-fully.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [readFully](read-fully.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes exactly byteCount bytes from this and appends them to sink.  <br><br><br>
| <a name="okio/BufferedSource/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a>[readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)| <a name="okio/BufferedSource/readHexadecimalUnsignedLong/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Reads a long form this source in hexadecimal form (i.e., as a string in base 16).  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readHexadecimalUnsignedLong](read-hexadecimal-unsigned-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readInt/#/PointingToDeclaration/"></a>[readInt](read-int.md)| <a name="okio/BufferedSource/readInt/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes four bytes from this source and returns a big-endian int.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readInt](read-int.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readIntLe/#/PointingToDeclaration/"></a>[readIntLe](read-int-le.md)| <a name="okio/BufferedSource/readIntLe/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes four bytes from this source and returns a little-endian int.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readIntLe](read-int-le.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readLong/#/PointingToDeclaration/"></a>[readLong](read-long.md)| <a name="okio/BufferedSource/readLong/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes eight bytes from this source and returns a big-endian long.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readLong](read-long.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readLongLe/#/PointingToDeclaration/"></a>[readLongLe](read-long-le.md)| <a name="okio/BufferedSource/readLongLe/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes eight bytes from this source and returns a little-endian long.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readLongLe](read-long-le.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readShort/#/PointingToDeclaration/"></a>[readShort](read-short.md)| <a name="okio/BufferedSource/readShort/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br>More info  <br>Removes two bytes from this source and returns a big-endian short.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readShort](read-short.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readShortLe/#/PointingToDeclaration/"></a>[readShortLe](read-short-le.md)| <a name="okio/BufferedSource/readShortLe/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br>More info  <br>Removes two bytes from this source and returns a little-endian short.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readShortLe](read-short-le.md)(): [Short](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-short/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readString/#java.nio.charset.Charset/PointingToDeclaration/"></a>[readString](read-string.md)| <a name="okio/BufferedSource/readString/#java.nio.charset.Charset/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>abstract fun [readString](read-string.md)(charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes all bytes from this, decodes them as charset, and returns the string.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readString](read-string.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), charset: [Charset](https://docs.oracle.com/javase/8/docs/api/java/nio/charset/Charset.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes byteCount bytes from this, decodes them as charset, and returns the string.  <br><br><br>
| <a name="okio/BufferedSource/readUtf8/#/PointingToDeclaration/"></a>[readUtf8](read-utf8.md)| <a name="okio/BufferedSource/readUtf8/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes all bytes from this, decodes them as UTF-8, and returns the string.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readUtf8](read-utf8.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>abstract fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8](read-utf8.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes byteCount bytes from this, decodes them as UTF-8, and returns the string.  <br><br><br>
| <a name="okio/BufferedSource/readUtf8CodePoint/#/PointingToDeclaration/"></a>[readUtf8CodePoint](read-utf8-code-point.md)| <a name="okio/BufferedSource/readUtf8CodePoint/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Removes and returns a single UTF-8 code point, reading between 1 and 4 bytes as necessary.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readUtf8CodePoint](read-utf8-code-point.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readUtf8Line/#/PointingToDeclaration/"></a>[readUtf8Line](read-utf8-line.md)| <a name="okio/BufferedSource/readUtf8Line/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?  <br>More info  <br>Removes and returns characters up to but not including the next line break.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readUtf8Line](read-utf8-line.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/readUtf8LineStrict/#/PointingToDeclaration/"></a>[readUtf8LineStrict](read-utf8-line-strict.md)| <a name="okio/BufferedSource/readUtf8LineStrict/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Removes and returns characters up to but not including the next line break.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>  <br><br><br>[common]  <br>Content  <br>abstract fun [readUtf8LineStrict](read-utf8-line-strict.md)(limit: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>More info  <br>Like [readUtf8LineStrict](read-utf8-line-strict.md), except this allows the caller to specify the longest allowed match.  <br><br><br>
| <a name="okio/BufferedSource/request/#kotlin.Long/PointingToDeclaration/"></a>[request](request.md)| <a name="okio/BufferedSource/request/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>Returns true when the buffer contains at least byteCount bytes, expanding it as necessary.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [request](request.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/require/#kotlin.Long/PointingToDeclaration/"></a>[require](require.md)| <a name="okio/BufferedSource/require/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Returns when the buffer contains at least byteCount bytes.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [require](require.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/select/#okio.Options/PointingToDeclaration/"></a>[select](select.md)| <a name="okio/BufferedSource/select/#okio.Options/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>Finds the first string in options that is a prefix of this buffer, consumes it from this buffer, and returns its index.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>More info  <br>  <br><br><br>
| <a name="okio/BufferedSource/skip/#kotlin.Long/PointingToDeclaration/"></a>[skip](skip.md)| <a name="okio/BufferedSource/skip/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Reads and discards byteCount bytes from this source.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [skip](skip.md)(byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>  <br><br><br>
| <a name="okio/Source/timeout/#/PointingToDeclaration/"></a>timeout| <a name="okio/Source/timeout/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)  <br>[jvm]  <br>abstract fun [timeout](../-hashing-source/index.md#%5Bokio%2FSource%2Ftimeout%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this source.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[jvm]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/BufferedSource/buffer/#/PointingToDeclaration/"></a>[buffer](buffer.md)| <a name="okio/BufferedSource/buffer/#/PointingToDeclaration/"></a> [common] abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md)This source's internal buffer.   <br> [jvm] abstract val [buffer](buffer.md): [Buffer](../-buffer/index.md)   <br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/Buffer///PointingToDeclaration/"></a>[Buffer](../-buffer/index.md)

