//[okio](../../index.md)/[okio](../index.md)/[Sink](index.md)



# Sink  
 [common] interface [Sink](index.md) : [Closeable](../-closeable/index.md)

Receives a stream of bytes. Use this interface to write data wherever it's needed: to the network, storage, or a buffer in memory. Sinks may be layered to transform received data, such as to compress, encrypt, throttle, or add protocol framing.



Most application code shouldn't operate on a sink directly, but rather on a [BufferedSink](../-buffered-sink/index.md) which is both more efficient and more convenient. Use [buffer](../buffer.md) to wrap any sink with a buffer.



Sinks are easy to test: just use a [Buffer](../-buffer/index.md) in your tests, and read from it to confirm it received the data that was expected.



###  Comparison with OutputStream  


This interface is functionally equivalent to java.io.OutputStream.



OutputStream requires multiple layers when emitted data is heterogeneous: a DataOutputStream for primitive values, a BufferedOutputStream for buffering, and OutputStreamWriter for charset encoding. This library uses BufferedSink for all of the above.



Sink is also easier to layer: there is no java.io.OutputStream.write method that is awkward to implement efficiently.



###  Interop with OutputStream  


Use sink to adapt an OutputStream to a sink. Use BufferedSink.outputStream to adapt a sink to an OutputStream.

   
 [jvm] interface [Sink](index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), [Flushable](https://docs.oracle.com/javase/8/docs/api/java/io/Flushable.html)   


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Sink/close/#/PointingToDeclaration/"></a>[close](close.md)| <a name="okio/Sink/close/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract override fun [close](close.md)()  <br>More info  <br>Pushes all buffered bytes to their final destination and releases the resources held by this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract override fun [close](close.md)()  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>equals| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br>[jvm]  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Sink/flush/#/PointingToDeclaration/"></a>[flush](flush.md)| <a name="okio/Sink/flush/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [flush](flush.md)()  <br>More info  <br>Pushes all buffered bytes to their final destination.  <br><br><br>[jvm]  <br>Content  <br>abstract override fun [flush](flush.md)()  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>hashCode| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br>[jvm]  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Sink/timeout/#/PointingToDeclaration/"></a>[timeout](timeout.md)| <a name="okio/Sink/timeout/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>Returns the timeout for this sink.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br>More info  <br>  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>toString| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F113773673)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br>[jvm]  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-43762623)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/Sink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[write](write.md)| <a name="okio/Sink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes byteCount bytes from source and appends them to this.  <br><br><br>[jvm]  <br>Content  <br>abstract fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>  <br><br><br>


## Inheritors  
  
|  Name| 
|---|
| <a name="okio/BufferedSink///PointingToDeclaration/"></a>[BufferedSink](../-buffered-sink/index.md)
| <a name="okio/HashingSink///PointingToDeclaration/"></a>[HashingSink](../-hashing-sink/index.md)
| <a name="okio/CipherSink///PointingToDeclaration/"></a>[CipherSink](../-cipher-sink/index.md)
| <a name="okio/DeflaterSink///PointingToDeclaration/"></a>[DeflaterSink](../-deflater-sink/index.md)
| <a name="okio/ForwardingSink///PointingToDeclaration/"></a>[ForwardingSink](../-forwarding-sink/index.md)
| <a name="okio/GzipSink///PointingToDeclaration/"></a>[GzipSink](../-gzip-sink/index.md)


## Extensions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio//buffer/okio.Sink#/PointingToDeclaration/"></a>[buffer](../buffer.md)| <a name="okio//buffer/okio.Sink#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [Sink](index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)  <br>More info  <br>Returns a new sink that buffers writes to sink.  <br><br><br>
| <a name="okio//cipherSink/okio.Sink#javax.crypto.Cipher/PointingToDeclaration/"></a>[cipherSink](../cipher-sink.md)| <a name="okio//cipherSink/okio.Sink#javax.crypto.Cipher/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Sink](index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)  <br>More info  <br>Returns a sink that uses cipher to encrypt or decrypt this.  <br><br><br>
| <a name="okio//deflate/okio.Sink#java.util.zip.Deflater/PointingToDeclaration/"></a>[deflate](../deflate.md)| <a name="okio//deflate/okio.Sink#java.util.zip.Deflater/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Sink](index.md).[deflate](../deflate.md)(deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)  <br>More info  <br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](index.md) while writing.  <br><br><br>
| <a name="okio//gzip/okio.Sink#/PointingToDeclaration/"></a>[gzip](../gzip.md)| <a name="okio//gzip/okio.Sink#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun [Sink](index.md).[gzip](../gzip.md)(): [GzipSink](../-gzip-sink/index.md)  <br>More info  <br>Returns a [GzipSink](../-gzip-sink/index.md) that gzip-compresses to this [Sink](index.md) while writing.  <br><br><br>
| <a name="okio//hashingSink/okio.Sink#javax.crypto.Mac/PointingToDeclaration/"></a>[hashingSink](../hashing-sink.md)| <a name="okio//hashingSink/okio.Sink#javax.crypto.Mac/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [Sink](index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)  <br>More info  <br>Returns a sink that uses mac to hash this.  <br><br><br>[jvm]  <br>Content  <br>fun [Sink](index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)  <br>More info  <br>Returns a sink that uses digest to hash this.  <br><br><br>

