//[okio](../../index.md)/[okio](../index.md)/[FileHandle](index.md)



# FileHandle  
 [common] abstract class [FileHandle](index.md) : [Closeable](../-closeable/index.md)

An open file for reading and writing; using either streaming and random access.



Use [read](read.md) and [write](write.md) to perform one-off random-access reads and writes. Use [source](source.md), [sink](sink.md), and [appendingSink](appending-sink.md) for streaming reads and writes.



File handles must be closed when they are no longer needed. It is an error to read, write, or create streams after a file handle is closed. The operating system resources held by a file handle will be released once the file handle **and** all of its streams are closed.



Although this class offers both reading and writing APIs, file handle instances may be read-only or write-only. For example, a handle to a file on a read-only file system will throw an exception if a write is attempted.



File handles may be used by multiple threads concurrently. But the individual sources and sinks produced by a file handle are not safe for concurrent use.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileHandle/FileHandle/#/PointingToDeclaration/"></a>[FileHandle](-file-handle.md)| <a name="okio/FileHandle/FileHandle/#/PointingToDeclaration/"></a> [common] fun [FileHandle](-file-handle.md)()   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileHandle/appendingSink/#/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio/FileHandle/appendingSink/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [appendingSink](appending-sink.md)(): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that writes to this starting at the end.  <br><br><br>
| <a name="okio/FileHandle/close/#/PointingToDeclaration/"></a>[close](close.md)| <a name="okio/FileHandle/close/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open override fun [close](close.md)()  <br>More info  <br>Closes this object and releases the resources it holds.  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-299369573)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F-299369573)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileHandle/flush/#/PointingToDeclaration/"></a>[flush](flush.md)| <a name="okio/FileHandle/flush/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [flush](flush.md)()  <br>More info  <br>Pushes all buffered bytes to their final destination.  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-299369573)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-299369573)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/FileHandle/position/#okio.Sink/PointingToDeclaration/"></a>[position](position.md)| <a name="okio/FileHandle/position/#okio.Sink/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [position](position.md)(sink: [Sink](../-sink/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the position of sink in the file.  <br><br><br>[common]  <br>Content  <br>fun [position](position.md)(source: [Source](../-source/index.md)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the position of source in the file.  <br><br><br>
| <a name="okio/FileHandle/read/#kotlin.Long#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[read](read.md)| <a name="okio/FileHandle/read/#kotlin.Long#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [read](read.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Removes at least 1, and up to byteCount bytes from this and appends them to sink.  <br><br><br>
| <a name="okio/FileHandle/sink/#kotlin.Long/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio/FileHandle/sink/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [sink](sink.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Sink](../-sink/index.md)  <br>More info  <br>Returns a sink that writes to this starting at offset.  <br><br><br>
| <a name="okio/FileHandle/size/#/PointingToDeclaration/"></a>[size](size.md)| <a name="okio/FileHandle/size/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [size](size.md)(): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)  <br>More info  <br>Returns the total number of bytes in the file.  <br><br><br>
| <a name="okio/FileHandle/source/#kotlin.Long/PointingToDeclaration/"></a>[source](source.md)| <a name="okio/FileHandle/source/#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>fun [source](source.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) = 0L): [Source](../-source/index.md)  <br>More info  <br>Returns a source that reads from this starting at offset.  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-299369573)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[common]  <br>Content  <br>open fun [toString](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F-299369573)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileHandle/write/#kotlin.Long#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[write](write.md)| <a name="okio/FileHandle/write/#kotlin.Long#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[common]  <br>Content  <br>abstract fun [write](write.md)(offset: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html), source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br>More info  <br>Removes byteCount bytes from source and writes them to this at offset.  <br><br><br>

