//[okio](../../index.md)/[okio](../index.md)/[Path](index.md)



# Path  
 [common] class [Path](index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[Path](index.md)> 

A hierarchical address on a file system. A path is an identifier only; a [FileSystem](../-file-system/index.md) is required to access the file that a path refers to, if any.





UNIX and Windows Paths

 ----------------------



Paths follow different rules on UNIX vs. Windows operating systems. On UNIX operating systems (including Linux, Android, macOS, and iOS), the / slash character separates path segments. On Windows, the \ backslash character separates path segments. The two platforms each have their own rules for path resolution. This class implements all rules on all platforms; for example you can model a Linux path in a native Windows application.





Absolute and Relative Paths

 ---------------------------

<ul><li>**Absolute paths** identify a location independent of any working directory. On UNIX, absolute paths are prefixed with a slash, /. On Windows, absolute paths are one of two forms. The first is a volume letter, a colon, and a backslash, like C:\. The second is called a Universal Naming Convention (UNC) path, and it is prefixed by two backslashes \\. The term ‘fully-qualified path’ is a synonym of ‘absolute path’.</li><li>**Relative paths** are everything else. On their own, relative paths do not identify a location on a file system; they are relative to the system's current working directory. Use [FileSystem.canonicalize](../-file-system/canonicalize.md) to convert a relative path to its absolute path on a particular file system.</li></ul>

There are some special cases when working with relative paths.



On Windows, each volume (like A:\ and C:\) has its own current working directory. A path prefixed with a volume letter and colon but no slash (like A:letter.doc) is relative to the working directory on the named volume. For example, if the working directory on A:\ is A:\jesse, then the path A:letter.doc resolves to A:\jesse\letter.doc.



The path string C:\Windows is an absolute path when following Windows rules and a relative path when following UNIX rules. For example, if the current working directory is /Users/jesse, then C:\Windows resolves to /Users/jesse/C:/Windows.



This class decides which rules to follow by inspecting the first slash character in the path string. If the path contains no slash characters, it uses the host platform's rules. Or you may explicitly specify which rules to use by specifying the directorySeparator parameter in [toPath](-companion/to-path.md). Pass "/" to get UNIX rules and "\" to get Windows rules.





Path Traversal

 --------------



After the optional path root (like / on UNIX, like X:\ or \\ on Windows), the remainder of the path is a sequence of segments separated by / or \ characters. Segments satisfy these rules:

<ul><li>Segments are always non-empty.</li><li>If the segment is ., then the full path must be ..</li><li>If the segment is .., then the the path must be relative. All .. segments precede all     other segments.</li></ul>

The only path that ends with / is the file system root, /. The dot path . is a relative path that resolves to whichever path it is resolved against.



The [name](name.md) is the last segment in a path. It is typically a file or directory name, like README.md or Desktop. The name may be another special value:

<ul><li>The empty string is the name of the file system root path (full path /).</li><li>. is the name of the identity relative path (full path .).</li><li>.. is the name of a path consisting of only .. segments (such as ../../..).</li></ul>



Comparing Paths

 ---------------



Path implements [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html), [equals](equals.md), and [hashCode](hash-code.md). If two paths are equal then they operate on the same file on the file system.



Note that the converse is not true: **if two paths are non-equal, they may still resolve to the same file on the file system.** Here are some of the ways non-equal paths resolve to the same file:

<ul><li>**Case differences.** The default file system on macOS is case-insensitive. The paths     /Users/jesse/notes.txt and /USERS/JESSE/NOTES.TXT are non-equal but these paths resolve to     the same file.</li><li>**Mounting differences.** Volumes may be mounted at multiple paths. On macOS,     /Users/jesse/notes.txt  and /Volumes/Macintosh HD/Users/jesse/notes.txt typically resolve     to the same file. On Windows, C:\project\notes.txt and \\localhost\c$\project\notes.txt     typically resolve to the same file.</li><li>**Hard links.** UNIX file systems permit multiple paths to refer for same file. The paths may     be wildly different, like /Users/jesse/bruce_wayne.vcard and     /Users/jesse/batman.vcard, but changes via either path are reflected in both.</li><li>**Symlinks.** Symlinks permit multiple paths and directories to refer to the same file. On     macOS /tmp is symlinked to /private/tmp, so /tmp/notes.txt and /private/tmp/notes.txt     resolve to the same file.</li></ul>

To test whether two paths refer to the same file, try [FileSystem.canonicalize](../-file-system/canonicalize.md) first. This follows symlinks and looks up the preserved casing for case-insensitive case-preserved paths. **This method does not guarantee a unique result, however.** For example, each hard link to a file may return its own canonical path.



Paths are sorted in case-sensitive order.





Sample Paths

 ------------



<table> <tr><th> Path                         <th> Parent             <th> Name          <th> Notes                          </tr> <tr><td> `/`                          <td> null               <td> (empty)       <td> root                           </tr> <tr><td> `/home/jesse/notes.txt`      <td> `/home/jesse`      <td> `notes.txt`   <td> absolute path                  </tr> <tr><td> `project/notes.txt`          <td> `project`          <td> `notes.txt`   <td> relative path                  </tr> <tr><td> `../../project/notes.txt`    <td> `../../project`    <td> `notes.txt`   <td> relative path with traversal   </tr> <tr><td> `../../..`                   <td> null               <td> `..`          <td> relative path with traversal   </tr> <tr><td> `.`                          <td> null               <td> `.`           <td> current working directory      </tr> <tr><td> `C:\`                        <td> null               <td> (empty)       <td> volume root (Windows)          </tr> <tr><td> `C:\Windows\notepad.exe`     <td> `C:\Windows`       <td> `notepad.exe` <td> volume absolute path (Windows) </tr> <tr><td> `\`                          <td> null               <td> (empty)       <td> absolute path (Windows)        </tr> <tr><td> `\Windows\notepad.exe`       <td> `\Windows`         <td> `notepad.exe` <td> absolute path (Windows)        </tr> <tr><td> `C:`                         <td> null               <td> (empty)       <td> volume-relative path (Windows) </tr> <tr><td> `C:project\notes.txt`        <td> `C:project`        <td> `notes.txt`   <td> volume-relative path (Windows) </tr> <tr><td> `\\server`                   <td> null               <td> `server`      <td> UNC server (Windows)           </tr> <tr><td> `\\server\project\notes.txt` <td> `\\server\project` <td> `notes.txt`   <td> UNC absolute path (Windows)    </tr> </table>

   
 [jvm] class [Path](index.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)<[Path](index.md)>    


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Path.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio/Path.Companion///PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Path/compareTo/#okio.Path/PointingToDeclaration/"></a>[compareTo](compare-to.md)| <a name="okio/Path/compareTo/#okio.Path/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open operator override fun [compareTo](compare-to.md)(other: [Path](index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Path/div/#kotlin.String/PointingToDeclaration/"></a>[div](div.md)| <a name="okio/Path/div/#kotlin.String/PointingToDeclaration/"></a>[common]  <br>Content  <br>operator fun [div](div.md)(child: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Path](index.md)  <br>operator fun [div](div.md)(child: [Path](index.md)): [Path](index.md)  <br>More info  <br>Returns a path that resolves child relative to this path.  <br><br><br>[jvm]  <br>Content  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "resolve")  <br>  <br>operator fun [div](div.md)(child: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [Path](index.md)  <br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "resolve")  <br>  <br>operator fun [div](div.md)(child: [Path](index.md)): [Path](index.md)  <br>More info  <br>  <br><br><br>
| <a name="okio/Path/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](equals.md)| <a name="okio/Path/equals/#kotlin.Any?/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open operator override fun [equals](equals.md)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/Path/hashCode/#/PointingToDeclaration/"></a>[hashCode](hash-code.md)| <a name="okio/Path/hashCode/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open override fun [hashCode](hash-code.md)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/Path/toFile/#/PointingToDeclaration/"></a>[toFile](to-file.md)| <a name="okio/Path/toFile/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [toFile](to-file.md)(): [File](https://docs.oracle.com/javase/8/docs/api/java/io/File.html)  <br><br><br>
| <a name="okio/Path/toNioPath/#/PointingToDeclaration/"></a>[toNioPath](to-nio-path.md)| <a name="okio/Path/toNioPath/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>@IgnoreJRERequirement()  <br>  <br>fun [toNioPath](to-nio-path.md)(): [Path](https://docs.oracle.com/javase/8/docs/api/java/nio/file/Path.html)  <br><br><br>
| <a name="okio/Path/toString/#/PointingToDeclaration/"></a>[toString](to-string.md)| <a name="okio/Path/toString/#/PointingToDeclaration/"></a>[common, jvm]  <br>Content  <br>[common, jvm]  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>


## Properties  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/Path/isAbsolute/#/PointingToDeclaration/"></a>[isAbsolute](is-absolute.md)| <a name="okio/Path/isAbsolute/#/PointingToDeclaration/"></a> [common, jvm] val [isAbsolute](is-absolute.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)   <br>
| <a name="okio/Path/isRelative/#/PointingToDeclaration/"></a>[isRelative](is-relative.md)| <a name="okio/Path/isRelative/#/PointingToDeclaration/"></a> [common, jvm] val [isRelative](is-relative.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)   <br>
| <a name="okio/Path/isRoot/#/PointingToDeclaration/"></a>[isRoot](is-root.md)| <a name="okio/Path/isRoot/#/PointingToDeclaration/"></a> [common] val [isRoot](is-root.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)Returns true if this is an absolute path with no parent.   <br> [jvm] val [isRoot](is-root.md): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)   <br>
| <a name="okio/Path/name/#/PointingToDeclaration/"></a>[name](name.md)| <a name="okio/Path/name/#/PointingToDeclaration/"></a> [common, jvm] val [name](name.md): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)   <br>
| <a name="okio/Path/nameBytes/#/PointingToDeclaration/"></a>[nameBytes](name-bytes.md)| <a name="okio/Path/nameBytes/#/PointingToDeclaration/"></a> [common, jvm] val [nameBytes](name-bytes.md): [ByteString](../-byte-string/index.md)   <br>
| <a name="okio/Path/parent/#/PointingToDeclaration/"></a>[parent](parent.md)| <a name="okio/Path/parent/#/PointingToDeclaration/"></a> [common] val [parent](parent.md): [Path](index.md)?Returns the path immediately enclosing this path.   <br> [jvm] val [parent](parent.md): [Path](index.md)?   <br>
| <a name="okio/Path/volumeLetter/#/PointingToDeclaration/"></a>[volumeLetter](volume-letter.md)| <a name="okio/Path/volumeLetter/#/PointingToDeclaration/"></a> [common] val [volumeLetter](volume-letter.md): [Char](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)?This is the volume letter like "C" on Windows paths that starts with a volume letter.   <br> [jvm] val [volumeLetter](volume-letter.md): [Char](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-char/index.html)?   <br>

