//[okio-zipfilesystem](../../index.md)/[okio.zipfilesystem](../index.md)/[ZipFileSystem](index.md)



# ZipFileSystem  
 [jvm] class [ZipFileSystem](index.md) : FileSystem

Read only access to a [zip file](https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE_6.2.0.txt) and common [extra fields](https://opensource.apple.com/source/zip/zip-6/unzip/unzip/proginfo/extra.fld).





Zip Timestamps

 --------------



The base zip format tracks the last modified timestamp. It does not track created timestamps or last accessed timestamps. This format has limitations:

<ul><li>Timestamps are 16-bit values stored with 2-second precision. Some zip encoders (WinZip, PKZIP)     round up to the nearest 2 seconds; other encoders (Java) round down.</li><li>Timestamps before 1980-01-01 cannot be represented. They cannot represent dates after     2107-12-31.</li><li>Timestamps are stored in local time with no time zone offset. If the time zone offset changes     – due to daylight savings time or the zip file being sent to another time zone – file times     will be incorrect. The file time will be shifted by the difference in time zone offsets     between the encoder and decoder.</li></ul>

The zip format has optional extensions for timestamps.

<ul><li>UNIX timestamps (0x000d) support both last-access time and last modification time. These     timestamps are stored with 1-second precision using UTC.</li><li>NTFS timestamps (0x000a) support creation time, last access time, and last modified time.     These timestamps are stored with 100-millisecond precision using UTC.</li><li>Extended timestamps (0x5455) are stored as signed 32-bit timestamps with 1-second precision.     These cannot express dates beyond 2038-01-19.</li></ul>

This class currently supports base timestamps and extended timestamps.

   


## Types  
  
|  Name|  Summary| 
|---|---|
| <a name="okio.zipfilesystem/ZipFileSystem.Companion///PointingToDeclaration/"></a>[Companion](-companion/index.md)| <a name="okio.zipfilesystem/ZipFileSystem.Companion///PointingToDeclaration/"></a>[jvm]  <br>Content  <br>object [Companion](-companion/index.md)  <br><br><br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio.zipfilesystem/ZipFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[appendingSink](appending-sink.md)| <a name="okio.zipfilesystem/ZipFileSystem/appendingSink/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [appendingSink](appending-sink.md)(file: Path): Sink  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[atomicMove](atomic-move.md)| <a name="okio.zipfilesystem/ZipFileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [atomicMove](atomic-move.md)(source: Path, target: Path)  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[canonicalize](canonicalize.md)| <a name="okio.zipfilesystem/ZipFileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [canonicalize](canonicalize.md)(path: Path): Path  <br><br><br>
| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[copy](index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/copy/#okio.Path#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [copy](index.md#%5Bokio%2FFileSystem%2Fcopy%2F%23okio.Path%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(source: Path, target: Path)  <br><br><br>
| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[createDirectories](index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/createDirectories/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [createDirectories](index.md#%5Bokio%2FFileSystem%2FcreateDirectories%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(dir: Path)  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[createDirectory](create-directory.md)| <a name="okio.zipfilesystem/ZipFileSystem/createDirectory/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [createDirectory](create-directory.md)(dir: Path)  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[delete](delete.md)| <a name="okio.zipfilesystem/ZipFileSystem/delete/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [delete](delete.md)(path: Path)  <br><br><br>
| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[deleteRecursively](index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/deleteRecursively/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [deleteRecursively](index.md#%5Bokio%2FFileSystem%2FdeleteRecursively%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(fileOrDirectory: Path)  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[exists](index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/exists/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [exists](index.md#%5Bokio%2FFileSystem%2Fexists%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(path: Path): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[list](list.md)| <a name="okio.zipfilesystem/ZipFileSystem/list/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [list](list.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)<Path>  <br><br><br>
| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[metadata](index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/metadata/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>fun [metadata](index.md#%5Bokio%2FFileSystem%2Fmetadata%2F%23okio.Path%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(path: Path): FileMetadata  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[metadataOrNull](metadata-or-null.md)| <a name="okio.zipfilesystem/ZipFileSystem/metadataOrNull/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [metadataOrNull](metadata-or-null.md)(path: Path): FileMetadata?  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/open/#okio.Path/PointingToDeclaration/"></a>[open](open.md)| <a name="okio.zipfilesystem/ZipFileSystem/open/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [open](open.md)(file: Path): FileHandle  <br><br><br>
| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[read](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/read/#okio.Path#kotlin.Function1[okio.BufferedSource,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun <[T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)> [read](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(file: Path, readerAction: BufferedSource.() -> [T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)): [T](index.md#%5Bokio%2FFileSystem%2Fread%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSource%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[sink](sink.md)| <a name="okio.zipfilesystem/ZipFileSystem/sink/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [sink](sink.md)(file: Path): Sink  <br><br><br>
| <a name="okio.zipfilesystem/ZipFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[source](source.md)| <a name="okio.zipfilesystem/ZipFileSystem/source/#okio.Path/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [source](source.md)(path: Path): Source  <br><br><br>
| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[toString](-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="kotlin/Any/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [toString](-companion/index.md#%5Bkotlin%2FAny%2FtoString%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[write](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)| <a name="okio/FileSystem/write/#okio.Path#kotlin.Function1[okio.BufferedSink,TypeParam(bounds=[kotlin.Any?])]/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>inline fun <[T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)> [write](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)(file: Path, writerAction: BufferedSink.() -> [T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)): [T](index.md#%5Bokio%2FFileSystem%2Fwrite%2F%23okio.Path%23kotlin.Function1%5Bokio.BufferedSink%2CTypeParam%28bounds%3D%5Bkotlin.Any%3F%5D%29%5D%2FPointingToDeclaration%2F%5D%2FFunctions%2F1118567981)  <br><br><br>

