//[okio](../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[canonicalize](canonicalize.md)



# canonicalize  
[common]  
Content  
abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)  
More info  


Resolves path against the current working directory and symlinks in this file system. The returned path identifies the same file as path, but with an absolute path that does not include any symbolic links.



This is similar to File.getCanonicalFile() on the JVM and realpath on POSIX. Unlike File.getCanonicalFile(), this throws if the file doesn't exist.



#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[okio.IOException](../-i-o-exception/index.md)| <a name="okio/FileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a><br><br>if path cannot be resolved. This will occur if the file doesn't exist,     if the current working directory doesn't exist or is inaccessible, or if another failure     occurs while resolving the path.<br><br>
  
|  Name|  Summary| 
|---|---|
  


[js]  
Content  
abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)  
More info  


#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a>[okio.IOException](../-i-o-exception/index.md)| <a name="okio/FileSystem/canonicalize/#okio.Path/PointingToDeclaration/"></a><br><br>if path cannot be resolved. This will occur if the file doesn't exist,     if the current working directory doesn't exist or is inaccessible, or if another failure     occurs while resolving the path.<br><br>
  
|  Name|  Summary| 
|---|---|
  



