//[okio](../../index.md)/[okio](../index.md)/[DeflaterSink](index.md)



# DeflaterSink  
 [jvm] class [DeflaterSink](index.md) : [Sink](../-sink/index.md)

A sink that uses [DEFLATE](http://tools.ietf.org/html/rfc1951) to compress data written to another source.



###  Sync flush  


Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.



This is equivalent to using [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.

   


## Constructors  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/DeflaterSink/DeflaterSink/#okio.Sink#java.util.zip.Deflater/PointingToDeclaration/"></a>[DeflaterSink](-deflater-sink.md)| <a name="okio/DeflaterSink/DeflaterSink/#okio.Sink#java.util.zip.Deflater/PointingToDeclaration/"></a> [jvm] fun [DeflaterSink](-deflater-sink.md)(sink: [Sink](../-sink/index.md), deflater: [Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html))   <br>


## Functions  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/DeflaterSink/close/#/PointingToDeclaration/"></a>[close](close.md)| <a name="okio/DeflaterSink/close/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [close](close.md)()  <br><br><br>
| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F956581231)| <a name="kotlin/Any/equals/#kotlin.Any?/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open operator fun [equals](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2Fequals%2F%23kotlin.Any%3F%2FPointingToDeclaration%2F%5D%2FFunctions%2F956581231)(other: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)  <br><br><br>
| <a name="okio/DeflaterSink/flush/#/PointingToDeclaration/"></a>[flush](flush.md)| <a name="okio/DeflaterSink/flush/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [flush](flush.md)()  <br><br><br>
| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F956581231)| <a name="kotlin/Any/hashCode/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open fun [hashCode](../-timeout/-companion/index.md#%5Bkotlin%2FAny%2FhashCode%2F%23%2FPointingToDeclaration%2F%5D%2FFunctions%2F956581231)(): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)  <br><br><br>
| <a name="okio/DeflaterSink/timeout/#/PointingToDeclaration/"></a>[timeout](timeout.md)| <a name="okio/DeflaterSink/timeout/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)  <br><br><br>
| <a name="okio/DeflaterSink/toString/#/PointingToDeclaration/"></a>[toString](to-string.md)| <a name="okio/DeflaterSink/toString/#/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)  <br><br><br>
| <a name="okio/DeflaterSink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[write](write.md)| <a name="okio/DeflaterSink/write/#okio.Buffer#kotlin.Long/PointingToDeclaration/"></a>[jvm]  <br>Content  <br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))  <br><br><br>

